/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.swing.JOval;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.fsa.swing.OvalLayout;
import de.uni_paderborn.fujaba.fsa.swing.border.OvalBorder;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class OvalGrabLayouter
extends GrabLayouter {
    private static OvalGrabLayouter layouter = null;

    private OvalGrabLayouter() {
    }

    public static GrabLayouter get() {
        if (layouter == null) {
            layouter = new OvalGrabLayouter();
        }
        return layouter;
    }

    private OvalBorder searchForOvalBorder(Border border) {
        if (border instanceof OvalBorder) {
            return (OvalBorder)border;
        }
        if (border instanceof CompoundBorder) {
            OvalBorder outer = this.searchForOvalBorder(((CompoundBorder)border).getOutsideBorder());
            if (outer != null) {
                return outer;
            }
            OvalBorder inner = this.searchForOvalBorder(((CompoundBorder)border).getInsideBorder());
            if (inner != null) {
                return inner;
            }
        }
        return null;
    }

    public void layout(GrabManager manager) {
        OvalBorder ovalBorder = null;
        if (!(manager.getTarget() instanceof JOval)) {
            ovalBorder = this.searchForOvalBorder(manager.getTarget().getBorder());
        }
        Iterator grabIter = manager.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.layoutGrab(manager, grab, ovalBorder);
        }
    }

    protected void layoutGrab(GrabManager manager, JGrab grab, OvalBorder border) {
        Rectangle bounds = manager.getTarget().getBounds();
        double[] info = this.getPreferredLayoutInformation(grab);
        Direction orientation = Direction.fromInt((int)info[0]);
        double align = info[1];
        align = (1.0 - 2.0 * align) * Math.PI / 4.0;
        Insets insets = OvalLayout.getInsetsTilBorder(manager.getTarget(), border);
        Rectangle grabBounds = grab.getBounds();
        double grabWidth = grabBounds.getWidth();
        double grabHeight = grabBounds.getHeight();
        insets.left = (int)((double)insets.left - grabWidth / 2.0);
        insets.top = (int)((double)insets.top - grabHeight / 2.0);
        insets.right = (int)((double)insets.right - grabWidth / 2.0);
        insets.bottom = (int)((double)insets.bottom - grabHeight / 2.0);
        double xradius = (bounds.getWidth() - (double)insets.left - (double)insets.right) / 2.0;
        double yradius = (bounds.getHeight() - (double)insets.top - (double)insets.bottom) / 2.0;
        double centerX = bounds.getX() + (double)insets.left + xradius;
        double centerY = bounds.getY() + (double)insets.top + yradius;
        Point grabPoint = new Point();
        if (orientation == Direction.TOP) {
            grabPoint.x = (int)(centerX - Math.sin(align) * xradius);
            grabPoint.y = (int)(centerY - Math.cos(align) * yradius);
        } else if (orientation == Direction.BOTTOM) {
            grabPoint.x = (int)(centerX - Math.sin(align) * xradius);
            grabPoint.y = (int)(centerY + Math.cos(align) * yradius);
        } else if (orientation == Direction.LEFT) {
            grabPoint.x = (int)(centerX - Math.cos(align) * xradius);
            grabPoint.y = (int)(centerY - Math.sin(align) * yradius);
        } else {
            grabPoint.x = (int)(centerX + Math.cos(align) * xradius);
            grabPoint.y = (int)(centerY - Math.sin(align) * yradius);
        }
        grabPoint.x = (int)((double)grabPoint.x - grabWidth / 2.0);
        grabPoint.y = (int)((double)grabPoint.y - grabHeight / 2.0);
        Container targetParent = manager.getTarget().getParent();
        Container grabParent = grab.getParent();
        if (targetParent != null && grabParent != null) {
            grabPoint = SwingUtilities.convertPoint(targetParent, grabPoint, grabParent);
        }
        grab.setLocation(grabPoint);
    }

    protected double[] getPreferredLayoutInformation(JGrab grab) {
        JBend bend;
        Direction orientation = grab.getOrientation();
        double align = grab.getAlignment();
        if (grab.sizeOfLines() == 0 || grab.getTarget() == null) {
            if (grab.isAutoOrientation()) {
                orientation = Direction.LEFT;
                grab.setLayoutOrientation(orientation);
            }
            if (grab.isAutoAlignment()) {
                align = 0.5;
                grab.setLayoutAlignment(align);
            }
            return new double[]{orientation.asInt(), align};
        }
        Point mid = grab.getTarget().getLocation();
        mid.x += grab.getTarget().getWidth() / 2 - 1;
        mid.y += grab.getTarget().getHeight() / 2 - 1;
        Iterator lineIter = grab.iteratorOfLines();
        JBendLine line = (JBendLine)lineIter.next();
        if (line instanceof JPolyLine) {
            JPolyLine poly = (JPolyLine)line;
            bend = poly.getPrevFromBends(grab);
            if (bend == null) {
                bend = poly.getNextFromBends(grab);
            }
        } else {
            bend = line.getStartBend();
            if (bend == grab) {
                bend = line.getEndBend();
            }
        }
        Point p = bend.getPoint();
        if (bend.getParent() != null && grab.getTarget().getParent() != null) {
            p = SwingUtilities.convertPoint(bend.getParent(), p, grab.getTarget().getParent());
        }
        Direction tmpOrient = Direction.LEFT;
        double tmpAlign = 0.5;
        if (!p.equals(mid)) {
            int angle = (int)(Math.acos((double)(p.x - mid.x) / Math.sqrt((p.x - mid.x) * (p.x - mid.x) + (p.y - mid.y) * (p.y - mid.y))) * 180.0 / Math.PI);
            if (p.y > mid.y) {
                angle = 360 - angle;
            }
            if (angle <= 45) {
                tmpOrient = Direction.RIGHT;
                tmpAlign = 1.0 - ((double)angle + 45.0) / 90.0;
            } else if (angle > 315) {
                tmpOrient = Direction.RIGHT;
                tmpAlign = 1.0 - (double)(angle - 360 + 45) / 90.0;
            } else if (45 < angle && angle <= 135) {
                tmpOrient = Direction.TOP;
                tmpAlign = 1.0 - (double)(angle - 45) / 90.0;
            } else if (135 < angle && angle <= 225) {
                tmpOrient = Direction.LEFT;
                tmpAlign = (double)(angle - 135) / 90.0;
            } else {
                tmpOrient = Direction.BOTTOM;
                tmpAlign = (double)(angle - 225) / 90.0;
            }
        }
        if (grab.isAutoOrientation()) {
            grab.setLayoutOrientation(tmpOrient);
            orientation = tmpOrient;
        }
        if (grab.isAutoAlignment()) {
            grab.setLayoutAlignment(tmpAlign);
            align = tmpAlign;
        }
        return new double[]{orientation.asInt(), align};
    }
}

