/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.GrabUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class RhombGrabUI
extends GrabUI {
    private static RhombGrabUI filledUI = null;
    private static RhombGrabUI hollowUI = null;
    private boolean filled = false;

    public static RhombGrabUI get(boolean filled) {
        if (filled) {
            if (filledUI == null) {
                filledUI = new RhombGrabUI(true);
            }
            return filledUI;
        }
        if (hollowUI == null) {
            hollowUI = new RhombGrabUI(false);
        }
        return hollowUI;
    }

    public static ComponentUI createUI(JComponent c) {
        return RhombGrabUI.get(false);
    }

    private RhombGrabUI() {
        this(false);
    }

    private RhombGrabUI(boolean filled) {
        this.setFilled(filled);
    }

    public void setFilled(boolean filled) {
        if (this.filled != filled) {
            this.filled = filled;
        }
    }

    public boolean isFilled() {
        return this.filled;
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(3, 3);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(15, 15);
    }

    public void paint(Graphics g, JComponent c) {
        Color oldColor = g.getColor();
        Rectangle bounds = new Rectangle(c.getSize());
        Insets insets = c.getInsets();
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        int[] newX = new int[5];
        int[] newY = new int[5];
        newX[0] = bounds.x;
        newX[1] = bounds.x + bounds.width / 2;
        newX[2] = bounds.x + bounds.width - 1;
        newX[3] = bounds.x + bounds.width / 2 - 1;
        newX[4] = bounds.x;
        newY[0] = bounds.y + bounds.height / 2;
        newY[1] = bounds.y;
        newY[2] = bounds.y + bounds.width / 2 - 1;
        newY[3] = bounds.y + bounds.height - 1;
        newY[4] = bounds.y + bounds.height / 2;
        if (!this.isFilled()) {
            g.setColor(c.getBackground());
            g.fillPolygon(newX, newY, 5);
            g.setColor(c.getForeground());
            g.drawPolyline(newX, newY, 5);
        } else {
            g.setColor(c.getForeground());
            g.fillPolygon(newX, newY, 5);
        }
        g.setColor(oldColor);
    }
}

