/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JExtendedSeparator;
import de.uni_paderborn.fujaba.fsa.swing.JSeparatedPanel;
import de.upb.tools.fca.FLinkedList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class SeparatedPanelLayout
implements LayoutManager {
    private FLinkedList separatedComps = new FLinkedList();
    protected int gap = 3;
    private static SeparatedPanelLayout layouter = null;

    private SeparatedPanelLayout() {
    }

    public static SeparatedPanelLayout get() {
        if (layouter == null) {
            layouter = new SeparatedPanelLayout();
        }
        return layouter;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private Dimension getSeparatedPreferredSize(Container parent) {
        JExtendedSeparator lastSep = null;
        Dimension tmpPrefDim = null;
        Dimension separatedPrefDim = new Dimension();
        Component[] comp = parent.getComponents();
        this.separatedComps.clear();
        int i = 0;
        while (i < comp.length) {
            if (comp[i].isVisible() && comp[i] instanceof JExtendedSeparator) {
                lastSep = (JExtendedSeparator)comp[i];
                separatedPrefDim.height += lastSep.getPreferredSize().height + this.gap / 2;
                if (lastSep.getFirst() instanceof JScrollPane && !this.separatedComps.contains(lastSep.getFirst()) && lastSep.getFirst().isVisible()) {
                    this.separatedComps.add(lastSep.getFirst());
                    tmpPrefDim = lastSep.getFirst().getPreferredSize();
                    separatedPrefDim.height += tmpPrefDim.height + this.gap;
                }
                if (lastSep.getSecond() instanceof JScrollPane && !this.separatedComps.contains(lastSep.getSecond()) && lastSep.getSecond().isVisible()) {
                    this.separatedComps.add(lastSep.getSecond());
                    tmpPrefDim = lastSep.getSecond().getPreferredSize();
                    separatedPrefDim.height += tmpPrefDim.height + this.gap;
                }
            }
            ++i;
        }
        return separatedPrefDim;
    }

    public Dimension preferredLayoutSize(Container parent) {
        JSeparatedPanel tmpParent = (JSeparatedPanel)parent;
        Dimension parentDim = new Dimension();
        Component[] comp = tmpParent.getComponents();
        Insets insets = tmpParent.getInsets();
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < comp.length) {
            Dimension tempDim;
            if (comp[i].isVisible() && (tempDim = comp[i].getPreferredSize()) != null) {
                if (tempDim.width + 2 * this.gap > width && !(comp[i] instanceof JSeparator)) {
                    width = tempDim.width + 2 * this.gap;
                }
                height = height + tempDim.height + this.gap;
                if (comp[i] instanceof JSeparator) {
                    height -= this.gap / 2;
                }
            }
            ++i;
        }
        parentDim.width = width + insets.left + insets.right;
        parentDim.height = height + insets.top + insets.bottom + 2 * this.gap;
        return parentDim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension min = new Dimension();
        Insets insets = parent.getInsets();
        min.height = 0;
        min.width = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            Component comp = parent.getComponent(index);
            Dimension prefSize = null;
            if (comp.isVisible()) {
                prefSize = comp.getMinimumSize();
                min.height = comp instanceof JSeparator ? (min.height += prefSize.height + this.gap / 2) : (min.height += prefSize.height + this.gap);
                if (min.width > prefSize.width + 2 * this.gap && !(comp instanceof JSeparator)) {
                    min.width = prefSize.width + 2 * this.gap;
                }
            }
            ++index;
        }
        min.width = min.width + insets.left + insets.right;
        min.height = min.height + insets.top + insets.bottom + 2 * this.gap;
        return min;
    }

    public Dimension maximumLayoutSize(Container parent) {
        Dimension max = new Dimension();
        Insets insets = parent.getInsets();
        max.height = 0;
        max.width = 0;
        int index = 0;
        while (index < parent.getComponentCount()) {
            Component comp = parent.getComponent(index);
            Dimension prefSize = null;
            if (comp.isVisible()) {
                prefSize = comp.getMaximumSize();
                max.height = comp instanceof JSeparator ? (max.height += prefSize.height + this.gap / 2) : (max.height += prefSize.height + this.gap);
                if (max.width < prefSize.width + 2 * this.gap && !(comp instanceof JSeparator)) {
                    max.width = prefSize.width + 2 * this.gap;
                }
            }
            ++index;
        }
        max.height += insets.top + insets.bottom + 2 * this.gap;
        max.width += insets.left + insets.right;
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            JComponent comp;
            Component[] comps;
            int i;
            int deltaHeight = 0;
            Dimension minDim = null;
            Dimension maxDim = null;
            Rectangle rect = parent.getBounds();
            Insets insets = parent.getInsets();
            Dimension preferredSize = this.preferredLayoutSize(parent);
            Dimension separatedPrefDim = this.getSeparatedPreferredSize(parent);
            Dimension[] sepDims = new Dimension[parent.getComponentCount()];
            Dimension tmpSize = separatedPrefDim;
            int maxHeight = rect.height - insets.top - insets.bottom;
            int maxWidth = rect.width - insets.left - insets.right - 2 * this.gap;
            deltaHeight = preferredSize.height - separatedPrefDim.height - 2 * this.gap;
            boolean changed = true;
            while (changed && tmpSize.height > maxHeight - deltaHeight) {
                changed = false;
                i = 0;
                comps = parent.getComponents();
                while (tmpSize.height > maxHeight - deltaHeight && i < comps.length) {
                    comp = (JComponent)comps[i];
                    if (comp.isVisible() && this.separatedComps.contains(comp)) {
                        if (sepDims[i] == null) {
                            sepDims[i] = comp.getPreferredSize();
                        }
                        minDim = comp.getMinimumSize();
                        if (minDim.height < sepDims[i].height - 1) {
                            --sepDims[i].height;
                            --tmpSize.height;
                            changed = true;
                        }
                    }
                    ++i;
                }
            }
            changed = true;
            while (changed && tmpSize.height < maxHeight - deltaHeight) {
                changed = false;
                i = 0;
                comps = parent.getComponents();
                while (tmpSize.height < maxHeight - deltaHeight && i < comps.length) {
                    comp = (JComponent)comps[i];
                    if (comp.isVisible() && this.separatedComps.contains(comp)) {
                        if (sepDims[i] == null) {
                            sepDims[i] = comp.getPreferredSize();
                        }
                        maxDim = comp.getMaximumSize();
                        if (maxDim.height >= sepDims[i].height + 1) {
                            ++sepDims[i].height;
                            ++tmpSize.height;
                            changed = true;
                        }
                    }
                    ++i;
                }
            }
            Component[] comp2 = parent.getComponents();
            int x = this.gap + insets.left;
            int y = this.gap + insets.top;
            int i2 = 0;
            while (i2 < comp2.length) {
                if (comp2[i2].isVisible()) {
                    Dimension tempDim = this.separatedComps.contains(comp2[i2]) && sepDims[i2] != null ? sepDims[i2] : comp2[i2].getPreferredSize();
                    if (comp2[i2] instanceof JSeparator) {
                        comp2[i2].setLocation(x - this.gap, y - this.gap / 2);
                        y -= this.gap / 2;
                        tempDim.width = maxWidth + 2 * this.gap;
                    } else {
                        comp2[i2].setLocation(x, y);
                        tempDim.width = maxWidth;
                    }
                    comp2[i2].setSize(tempDim);
                    y = y + tempDim.height + this.gap;
                }
                ++i2;
            }
        }
    }
}

