/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;

public class CircleBorder
extends AbstractColorBorder {
    public Insets getBorderInsets(Component c) {
        Dimension size = c.getSize();
        int radius = (int)size.getWidth() / 2;
        int innerRectWidth2 = new Double((double)radius / 1.4142135624).intValue();
        return new Insets(radius - innerRectWidth2, radius - innerRectWidth2, radius - innerRectWidth2 + 1, radius - innerRectWidth2 + 1);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getBorderInsets(c);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public static Rectangle getInteriorRectangle(Component c, Border b, int x, int y, int width, int height) {
        int radius = width / 2;
        int innerRectWidth2 = new Double((double)radius / 1.4142135624).intValue();
        return new Rectangle(radius - innerRectWidth2, y + height / 2 - innerRectWidth2, innerRectWidth2 * 2, innerRectWidth2 * 2);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(FSAObject.COLOR_FOREGROUND);
        g.drawArc(x, y, width - 1, height - 1, 0, 360);
        g.setColor(oldColor);
    }
}

