/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.swing.LineStyle;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;

public class LineBorder
extends AbstractColorBorder {
    protected int thickness;
    protected boolean roundedCorners;
    private Stroke stroke = LineStyle.SOLID;
    private boolean dashedFlag;

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int thickness) {
        this(color, thickness, false);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    LineBorder(Color color, int thickness, boolean roundedCorners) {
        super(color);
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(this.getStroke());
        g.setColor(this.getBorderColor());
        if (!this.roundedCorners) {
            g.drawRect(x + this.thickness / 2, y + this.thickness / 2, width - this.thickness, height - this.thickness);
        } else {
            g.drawRoundRect(x + this.thickness / 2, y + this.thickness / 2, width - this.thickness, height - this.thickness, this.thickness, this.thickness);
        }
        g.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int newThickness) {
        BasicStroke stroke;
        this.thickness = newThickness;
        if (this.thickness < 0) {
            this.thickness = 0;
        }
        if (this.getStroke() != null) {
            BasicStroke defaultStroke = (BasicStroke)this.getStroke();
            stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
        } else {
            stroke = new BasicStroke(this.thickness);
        }
        this.setStroke(stroke);
    }

    public void setBorderDashed(boolean dashed) {
        this.dashedFlag = dashed;
        if (dashed) {
            BasicStroke defaultStroke = LineStyle.DASHED;
            BasicStroke stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
            this.setStroke(stroke);
        } else {
            this.setStroke(new BasicStroke(this.thickness));
        }
    }

    public boolean isBorderDashed() {
        return this.dashedFlag;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

