/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.update;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.update.Translator;

public abstract class AbstractUpdater
implements Translator {
    private Translator translator = null;
    private Object logicObject;
    private String logicAttrName;
    private String fsaAttrName;
    private FSAObject fsaObject;
    private boolean listenerActive = false;

    public AbstractUpdater() {
        this.setListenerActive(true);
    }

    public Translator getTranslator() {
        if (this.translator == null) {
            return this;
        }
        return this.translator;
    }

    public void setTranslator(Translator propValue) {
        Translator oldTranslator = this.getTranslator();
        this.translator = propValue;
        if (oldTranslator != this.getTranslator()) {
            boolean active = this.isListenerActive();
            this.setListenerActive(false);
            this.initialize();
            this.setListenerActive(active);
        }
    }

    public Object getLogicObject() {
        return this.logicObject;
    }

    public boolean setLogicObject(Object logicObject) {
        if (this.logicObject != logicObject) {
            boolean active = this.isListenerActive();
            this.setListenerActive(false);
            this.logicObject = logicObject;
            this.initialize();
            this.setListenerActive(active);
            return true;
        }
        return false;
    }

    public String getLogicAttrName() {
        return this.logicAttrName;
    }

    public boolean setLogicAttrName(String logicAttrName) {
        if (this.logicAttrName == null && logicAttrName != null || this.logicAttrName != null && !this.logicAttrName.equals(logicAttrName)) {
            boolean active = this.isListenerActive();
            this.setListenerActive(false);
            this.logicAttrName = logicAttrName;
            this.initialize();
            this.setListenerActive(active);
            return true;
        }
        return false;
    }

    public String getFsaAttrName() {
        return this.fsaAttrName;
    }

    public boolean setFsaAttrName(String fsaAttrName) {
        if (this.fsaAttrName == null && fsaAttrName != null || this.fsaAttrName != null && !this.fsaAttrName.equals(fsaAttrName)) {
            boolean active = this.isListenerActive();
            this.setListenerActive(false);
            this.fsaAttrName = fsaAttrName;
            this.initialize();
            this.setListenerActive(active);
            return false;
        }
        return false;
    }

    public boolean setFsaObject(FSAObject value) {
        if (this.fsaObject != value) {
            boolean active = this.isListenerActive();
            this.setListenerActive(false);
            if (this.fsaObject != null) {
                FSAObject oldValue = this.fsaObject;
                this.fsaObject = null;
                oldValue.removeFromUpdater(this);
            }
            this.fsaObject = value;
            if (value != null) {
                this.fsaObject.addToUpdater(this);
                this.initialize();
            }
            this.setListenerActive(active);
            return true;
        }
        return false;
    }

    public FSAObject getFsaObject() {
        return this.fsaObject;
    }

    public String toString() {
        return this.getClass() + " [getFsaObject=" + this.getFsaObject() + ",getFsaAttrName=" + this.getFsaAttrName() + ",getLogicObject=" + this.getLogicObject() + ",getLogicAttrName=" + this.getLogicAttrName() + "]";
    }

    public Object translateLogicToFsa(Object data) {
        return data;
    }

    public Object translateFsaToLogic(Object data) {
        return data;
    }

    void setListenerState(boolean state) {
        this.listenerActive = state;
    }

    public boolean setListenerActive(boolean active) {
        if (this.listenerActive != active) {
            this.listenerActive = active;
            if (active) {
                this.addListener();
            } else {
                this.removeListener();
            }
            return true;
        }
        return false;
    }

    public boolean isListenerActive() {
        return this.listenerActive;
    }

    protected abstract void initialize();

    protected abstract void addListener();

    protected abstract void removeListener();
}

