/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.update;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSATextComponent;
import de.uni_paderborn.fujaba.fsa.swing.JTextEditor;
import de.uni_paderborn.fujaba.fsa.update.ListenerHelper;
import de.uni_paderborn.fujaba.fsa.update.LogicAndFsaUpdater;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.JEditorPane;

public class TextComponentUpdater
extends LogicAndFsaUpdater
implements FocusListener,
PropertyChangeListener {
    private boolean focused = false;

    public TextComponentUpdater() {
        super.setFsaAttrName("text");
    }

    public Object translateLogicToFsa(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public boolean setFsaAttrName(String name) {
        if ("text".equals(name)) {
            return true;
        }
        throw new UnsupportedOperationException("FsaAttrName cannot be changed from \"text\" in TextComponentUpdater");
    }

    protected void addListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null) {
            if (this.getLogicListener() == null) {
                this.setLogicListener(this);
            }
            ListenerHelper.get().addPropertyChangeListener(this.getLogicObject(), this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
            if (this.getFsaListener() == null) {
                this.setFsaListener(this);
            }
            this.getFsaObject().addPropertyChangeListener("document", (PropertyChangeListener)this.getFsaListener());
            JTextEditor editor = (JTextEditor)this.getFsaObject().getJComponent();
            JEditorPane comp = editor.getEditorPane();
            comp.addFocusListener((FocusListener)this.getFsaListener());
        }
    }

    protected void removeListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null) {
            EventListener listener;
            if (this.getLogicListener() != null) {
                ListenerHelper.get().removePropertyChangeListener(this.getLogicObject(), this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
            }
            if ((listener = this.getFsaListener()) != null) {
                this.getFsaObject().removePropertyChangeListener("document", (PropertyChangeListener)listener);
                JTextEditor editor = (JTextEditor)this.getFsaObject().getJComponent();
                JEditorPane comp = editor.getEditorPane();
                comp.removeFocusListener((FocusListener)listener);
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.focused = this.getFsaObject() != null && this.getFsaObject().getJComponent() != null && this.getFsaObject().getJComponent().hasFocus();
    }

    public void setLogicValue(Object value) {
        Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods(this.getLogicAttrName(), this.getLogicObject());
        Method setMethod = methods[1];
        try {
            setMethod.invoke(this.getLogicObject(), value);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in " + this + ".setLogicValue: " + e.getMessage());
        }
    }

    public Object getLogicValue() {
        Object result;
        Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods(this.getLogicAttrName(), this.getLogicObject());
        Method getMethod = methods[0];
        try {
            result = getMethod.invoke(this.getLogicObject(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in " + this + ".getLogicValue: " + e.getMessage());
        }
        return result;
    }

    public boolean isFocused() {
        return this.focused;
    }

    void setFocused(boolean focused) {
        this.focused = focused;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.getLogicObject()) {
            Object value = e.getNewValue();
            String text = (String)this.getTranslator().translateLogicToFsa(value);
            ((FSATextComponent)this.getFsaObject()).setText(text);
        }
    }

    public void focusGained(FocusEvent e) {
        this.focused = true;
    }

    public void focusLost(FocusEvent e) {
        this.focused = false;
        if (this.getFsaObject() != null) {
            this.setLogicValue(this.getTranslator().translateFsaToLogic(((FSATextComponent)this.getFsaObject()).getText()));
        }
    }
}

