/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class AbstractDialog
extends JDialog {
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private int userChoice = 0;
    private JButton okButton;
    private JButton cancelButton;

    public AbstractDialog(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        this.addWindowListener(new DialogClose());
    }

    protected void setUserChoice(int userChoice) {
        if (userChoice != 0) {
            this.userChoice = userChoice;
        }
    }

    public int getUserChoice() {
        return this.userChoice;
    }

    protected void initialize() {
        this.unparse();
        this.pack();
        this.centerDialog();
    }

    protected void setOkButton(JButton button) {
        this.okButton = button;
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    protected void setCancelButton(JButton button) {
        this.cancelButton = button;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    protected abstract void unparse();

    protected abstract void parse();

    protected boolean checkConstraints() {
        return true;
    }

    public void okPressed() {
        if (this.checkConstraints()) {
            this.parse();
            this.setVisible(false);
            this.setUserChoice(1);
        }
    }

    public void cancelPressed() {
        this.setVisible(false);
        this.setUserChoice(2);
    }

    protected void createUserInterface() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createButtonPanel(), "South");
        panel.add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add(panel);
    }

    protected abstract JPanel createMainPanel();

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton("Ok");
        this.setOkButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.okPressed();
            }
        });
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.setCancelButton(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.cancelPressed();
            }
        });
        buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        return buttonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        this.setLocation(x, y);
    }

    protected class DialogClose
    extends WindowAdapter {
        protected DialogClose() {
        }

        public void windowClosing(WindowEvent e) {
            AbstractDialog.this.cancelPressed();
        }
    }
}

