/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.basic.Utility;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.tools.sdm.Path;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class CompletionKeyListener
implements KeyListener {
    private UMLClass contextClass = null;
    private UMLObject contextObject = null;
    private UMLStoryPattern contextStoryPattern = null;
    private UMLActivity contextActivity = null;
    private String prefix = null;
    boolean declarationWanted = false;
    boolean addBasicTypes = false;

    public CompletionKeyListener(Object target) {
        this.setContext(target, false);
    }

    public void setContext(Object target, boolean declarationWanted) {
        this.prefix = null;
        this.declarationWanted = declarationWanted;
        this.addBasicTypes = false;
        if (target != null && target instanceof UMLClass) {
            this.contextClass = (UMLClass)target;
        } else if (target != null && target instanceof UMLObject) {
            this.contextObject = (UMLObject)target;
            this.contextClass = this.contextObject.getInstanceOf();
            this.contextStoryPattern = (UMLStoryPattern)this.contextObject.getFirstFromDiagrams();
        } else if (target != null && target instanceof UMLActivity) {
            this.contextActivity = (UMLActivity)target;
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        try {
            Object obj;
            this.updateContextClass();
            if (this.contextClass == null) {
                return;
            }
            UMLClass localContext = this.contextClass;
            int control = e.getModifiers() & 2;
            if (e.getKeyChar() == ' ' && control > 0 && (obj = e.getSource()) != null && obj instanceof JTextComponent) {
                this.prefix = null;
                JTextComponent jtf = (JTextComponent)obj;
                int caretPos = jtf.getCaretPosition();
                String fullText = jtf.getText();
                String txt = jtf.getText(0, caretPos);
                localContext = this.computeLocalContext(localContext, txt);
                this.computeAlternatives(localContext, jtf, caretPos, fullText);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateContextClass() {
        if (this.contextClass == null && this.contextActivity != null) {
            UMLActivityDiagram activityDiag = (UMLActivityDiagram)this.contextActivity.getFirstFromDiagrams();
            UMLMethod myMethod = activityDiag.getStoryMethod();
            this.contextClass = myMethod.getParent();
        }
    }

    public UMLClass computeLocalContext(UMLClass localContext, String txt) {
        int pos = -1;
        String specialChars = ";+*-,{}=";
        int i = 0;
        while (i < specialChars.length()) {
            pos = txt.lastIndexOf(specialChars.charAt(i));
            if (pos >= 0) {
                txt = txt.substring(pos + 1);
            }
            ++i;
        }
        pos = txt.lastIndexOf(58);
        if (this.declarationWanted && pos >= 0) {
            txt = txt.substring(pos + 1);
            this.addBasicTypes = true;
        }
        StringTokenizer tokens = new StringTokenizer(txt, ".");
        String myToken = "";
        UMLClass oldLocalContext = null;
        while (localContext != null && tokens.hasMoreTokens()) {
            oldLocalContext = localContext;
            myToken = tokens.nextToken();
            if ("this".equals(myToken)) {
                localContext = oldLocalContext;
                continue;
            }
            localContext = this.changeAttrContext(oldLocalContext, myToken);
            if (localContext == null) {
                localContext = this.changeMethodContext(oldLocalContext, myToken);
            }
            if (localContext != null) continue;
            localContext = this.changeLocalVarContext(myToken);
        }
        if (localContext == null) {
            this.prefix = myToken.trim();
            localContext = oldLocalContext;
        }
        return localContext;
    }

    public void keyTyped(KeyEvent e) {
    }

    private UMLClass changeLocalVarContext(String myToken) {
        if (myToken == null || myToken.equals("")) {
            return null;
        }
        this.updateContextActivity();
        if (this.contextActivity != null) {
            UMLActivityDiagram myActDiag = (UMLActivityDiagram)this.contextActivity.getFirstFromDiagrams();
            UMLMethod myMethod = myActDiag.getStartActivity().getSpec();
            if (myMethod != null) {
                if ("this".equals(myToken)) {
                    return myMethod.getParent();
                }
                Iterator params = myMethod.iteratorOfParam();
                while (params.hasNext()) {
                    UMLParam param = (UMLParam)params.next();
                    if (!param.getName().equals(myToken) || !(param.getParamType() instanceof UMLClass)) continue;
                    return (UMLClass)param.getParamType();
                }
            }
            Path objPath = new Path(myActDiag, "elements.storyPattern.elements");
            while (objPath.hasNext()) {
                UMLObject anObject;
                String objName;
                boolean found;
                Object element = objPath.next();
                if (element == null || !(element instanceof UMLObject) || !(found = myToken.equals(objName = (anObject = (UMLObject)element).getObjectName()))) continue;
                return anObject.getInstanceOf();
            }
        }
        return null;
    }

    private void updateContextActivity() {
        if (this.contextStoryPattern != null) {
            this.contextActivity = this.contextStoryPattern.getRevStoryPattern();
        }
    }

    private UMLClass changeMethodContext(UMLClass localContext, String myToken) {
        UMLMethod myMethod;
        UMLType result = null;
        int bracePos = myToken.indexOf(40);
        if (bracePos >= 0) {
            myToken = myToken.substring(0, bracePos).trim();
        }
        if ((myMethod = localContext.getFromMethodsByShortNameIncludingInherited(myToken)) != null && (result = myMethod.getResultType()) != null && result instanceof UMLClass) {
            return (UMLClass)result;
        }
        return null;
    }

    private UMLClass changeAttrContext(UMLClass localContext, String myToken) {
        UMLType obj;
        UMLAttr attr = localContext.getFromAllAttrs(myToken);
        localContext = attr != null ? ((obj = attr.getAttrType()) != null && obj instanceof UMLClass ? (UMLClass)obj : null) : null;
        return localContext;
    }

    private void computeAlternatives(UMLClass localContext, JTextComponent jtf, int caretPos, String fullText) {
        JPopupMenu completionMenu = new JPopupMenu("choose completions:");
        CompletionAction completionAction = new CompletionAction(this.prefix, fullText, caretPos, jtf);
        if (this.addBasicTypes) {
            Iterator iter = UMLProject.get().getTypeList().iteratorOfTypes();
            while (iter.hasNext()) {
                UMLType baseType = (UMLType)iter.next();
                String name = baseType.getName();
                if (this.prefix != null && !this.prefix.trim().equals("") && !name.startsWith(this.prefix)) continue;
                this.addToCompletionMenu(completionMenu, completionAction, name, name);
            }
            completionMenu.show(jtf, 5 * caretPos, jtf.getHeight());
        } else if (localContext != null) {
            Iterator iter = localContext.iteratorOfAllAttrs();
            String text = "";
            while (iter.hasNext()) {
                UMLAttr attr = (UMLAttr)iter.next();
                if (this.prefix != null && !this.prefix.trim().equals("") && !attr.getName().startsWith(this.prefix)) continue;
                text = this.declarationWanted ? attr.getName() : "get" + Utility.upFirstChar(attr.getName()) + "()";
                this.addToCompletionMenu(completionMenu, completionAction, attr.getName(), text);
            }
            iter = localContext.iteratorOfAllAccessibleMethods();
            while (iter.hasNext()) {
                UMLMethod aMethod = (UMLMethod)iter.next();
                if (aMethod.getAccessedAttribute() != null || this.prefix != null && !this.prefix.trim().equals("") && !aMethod.getName().startsWith(this.prefix)) continue;
                String name = aMethod.getFullMethodName();
                this.addToCompletionMenu(completionMenu, completionAction, name, name);
            }
            completionMenu.show(jtf, 5 * caretPos, jtf.getHeight());
        }
    }

    private void addToCompletionMenu(JPopupMenu completionMenu, Action completionAction, String name, String command) {
        JMenuItem methodItem = new JMenuItem();
        methodItem.setAction(completionAction);
        methodItem.setText(name);
        methodItem.setActionCommand(command);
        completionMenu.add(methodItem);
    }

    class CompletionAction
    extends AbstractAction {
        private String prefix = null;
        private String fullText = null;
        private int caretPos;
        private JTextComponent jtf = null;

        public CompletionAction(String prefix, String fullText, int caretPos, JTextComponent jtf) {
            this.prefix = prefix;
            this.fullText = fullText;
            this.caretPos = caretPos;
            this.jtf = jtf;
        }

        public void actionPerformed(ActionEvent e) {
            String newText = this.fullText.substring(0, this.caretPos);
            if (this.prefix != null && newText.endsWith(this.prefix)) {
                newText = newText.substring(0, newText.length() - this.prefix.length());
            }
            newText = String.valueOf(newText) + e.getActionCommand() + this.fullText.substring(this.caretPos);
            this.jtf.setText(newText);
        }
    }
}

