/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.gui.NopActivityPanel;
import de.uni_paderborn.fujaba.gui.StartActivityPanel;
import de.uni_paderborn.fujaba.gui.StartActivityPanelForMethod;
import de.uni_paderborn.fujaba.gui.StateActivityPanel;
import de.uni_paderborn.fujaba.gui.StatementActivityPanel;
import de.uni_paderborn.fujaba.gui.StopActivityPanel;
import de.uni_paderborn.fujaba.gui.StoryActivityPanel;
import de.uni_paderborn.fujaba.gui.TextEditAction;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditActivityDialog
extends AbstractDialog
implements TextEditAction.ClosableDialog {
    JPanel propertiesPanel;
    CardLayout cardLayout;
    private ButtonGroup buttonGroup;
    private ASGElement asgElement;
    ActivityPanel currentActivityPanel;
    private LinkedList activityPanels;

    public ASGElement getAsgElement() {
        return this.asgElement;
    }

    public EditActivityDialog(JFrame frame, ASGElement asgElement) {
        super(frame, true);
        this.asgElement = asgElement;
        this.addToActivityPanels(new StartActivityPanel(asgElement));
        this.addToActivityPanels(new StartActivityPanelForMethod(asgElement));
        this.addToActivityPanels(new StateActivityPanel(asgElement));
        this.addToActivityPanels(new StoryActivityPanel(asgElement));
        this.addToActivityPanels(new StatementActivityPanel(asgElement));
        this.addToActivityPanels(new NopActivityPanel(asgElement));
        this.addToActivityPanels(new StopActivityPanel(asgElement));
        this.createUserInterface();
        this.initialize();
    }

    protected JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (this.asgElement instanceof UMLActivityDiagram || this.asgElement instanceof ViewDiagram && ((ViewDiagram)this.asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            this.setTitle("New Activity");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            buttonPanel.setBorder(new TitledBorder("Activity"));
            panel.add((Component)buttonPanel, "West");
            this.cardLayout = new CardLayout();
            this.propertiesPanel = new JPanel();
            this.propertiesPanel.setLayout(this.cardLayout);
            this.propertiesPanel.setBorder(new TitledBorder("Properties"));
            panel.add((Component)this.propertiesPanel, "Center");
            this.buttonGroup = new ButtonGroup();
            boolean firstSelected = false;
            Iterator iter = this.iteratorOfActivityPanels();
            while (iter.hasNext()) {
                ActivityPanel tmpActivityPanel = (ActivityPanel)iter.next();
                JRadioButton button = new JRadioButton(tmpActivityPanel.getName());
                button.addChangeListener(new RadioButtonListener());
                this.cardLayout.addLayoutComponent(this.propertiesPanel, button.getText());
                this.buttonGroup.add(button);
                buttonPanel.add(button);
                this.propertiesPanel.add((Component)tmpActivityPanel, tmpActivityPanel.getName());
                if (firstSelected || !button.isEnabled()) continue;
                button.setSelected(true);
                firstSelected = true;
                this.cardLayout.show(this.propertiesPanel, button.getText());
                this.currentActivityPanel = tmpActivityPanel;
            }
        } else {
            ActivityPanel tmpActivityPanel = null;
            Iterator iter = this.iteratorOfActivityPanels();
            boolean found = false;
            while (iter.hasNext() && !found) {
                tmpActivityPanel = (ActivityPanel)iter.next();
                if (!tmpActivityPanel.isResponsible()) continue;
                found = true;
            }
            if (tmpActivityPanel != null && found) {
                this.setTitle("Edit " + tmpActivityPanel.getName() + " Activity");
                panel.setBorder(new TitledBorder("Properties"));
                panel.add(tmpActivityPanel);
                this.currentActivityPanel = tmpActivityPanel;
            } else {
                this.setTitle("Edit Activity");
                panel.setBorder(new TitledBorder("Error"));
                panel.setLayout(new FlowLayout(1));
                panel.add(new JLabel("Item not editable!"));
                this.currentActivityPanel = null;
            }
        }
        return panel;
    }

    protected void unparse() {
        Iterator iter = this.iteratorOfActivityPanels();
        while (iter.hasNext()) {
            ActivityPanel tmpActivityPanel = (ActivityPanel)iter.next();
            if (!tmpActivityPanel.isResponsible()) continue;
            tmpActivityPanel.unparse();
        }
        if (this.asgElement instanceof UMLActivityDiagram || this.asgElement instanceof ViewDiagram && ((ViewDiagram)this.asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            this.getOkButton().setText("Add");
        } else {
            this.getOkButton().setText("Modify");
        }
    }

    protected void parse() {
        if (this.currentActivityPanel != null) {
            this.asgElement = this.currentActivityPanel.okPressed();
        }
    }

    public void okPressed() {
        super.okPressed();
    }

    public void cancelPressed() {
        super.cancelPressed();
    }

    public void addToActivityPanels(ActivityPanel elem) {
        if (elem != null && !this.hasInActivityPanels(elem)) {
            if (this.activityPanels == null) {
                this.activityPanels = new LinkedList();
            }
            this.activityPanels.add(elem);
            elem.setActivityDialog(this);
        }
    }

    public boolean hasInActivityPanels(ActivityPanel elem) {
        if (this.activityPanels == null) {
            return false;
        }
        return this.activityPanels.contains(elem);
    }

    public Iterator iteratorOfActivityPanels() {
        return this.activityPanels == null ? FEmptyIterator.get() : this.activityPanels.iterator();
    }

    public ActivityPanel getFromActivityPanels(String name) {
        ActivityPanel searchedPanel = null;
        Iterator iter = this.iteratorOfActivityPanels();
        while (iter.hasNext() && searchedPanel == null) {
            ActivityPanel currentPanel = (ActivityPanel)iter.next();
            if (!currentPanel.getName().equals(name)) continue;
            searchedPanel = currentPanel;
        }
        return searchedPanel;
    }

    public void removeFromActivityPanels(ActivityPanel elem) {
        if (this.hasInActivityPanels(elem)) {
            this.activityPanels.remove(elem);
            elem.setActivityDialog(null);
        }
    }

    public int sizeOfActivityPanels() {
        if (this.activityPanels == null) {
            return 0;
        }
        return this.activityPanels.size();
    }

    public void removeAllFromActivityPanels() {
        Iterator iter = this.iteratorOfActivityPanels();
        while (iter.hasNext()) {
            ActivityPanel tmpActivityPanel = (ActivityPanel)iter.next();
            iter.remove();
            tmpActivityPanel.setActivityDialog(null);
        }
    }

    public void hideWhileEditing() {
    }

    private class RadioButtonListener
    implements ChangeListener {
        RadioButtonListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JRadioButton currentButton = (JRadioButton)e.getSource();
            if (currentButton.isSelected()) {
                EditActivityDialog.this.cardLayout.show(EditActivityDialog.this.propertiesPanel, currentButton.getText());
                EditActivityDialog.this.currentActivityPanel = EditActivityDialog.this.getFromActivityPanels(currentButton.getText());
            }
        }
    }
}

