/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.messages.WarningMessages;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gui.comp.JglListModel;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLCommentary;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class EditClassDiagDialog
extends FujabaDialog {
    private JTextField diagramNameTextField = new JTextField();
    JList classesInDiagramList = new JList();
    JList availableClassesList = new JList();
    private JButton buttonAdd = new JButton("<--");
    private JButton buttonDelete = new JButton("-->");
    private JButton buttonAddContext = new JButton("<--");
    private JButton buttonDeleteContext = new JButton("-->");
    private UMLClassDiagram classDiag = null;
    private TreeMap displayedClasses = new TreeMap();
    private TreeMap availableClasses = new TreeMap();
    private Set initiallyDisplayedClasses = new HashSet();

    public EditClassDiagDialog(JFrame frame, UMLClassDiagram diag) {
        super(frame, "Classdiagram Editor", true);
        this.guiInit();
        this.classDiag = diag;
        this.unparse();
    }

    public EditClassDiagDialog(JFrame frame) {
        super(frame, "Classdiagram Editor", true);
        this.guiInit();
        this.classDiag = null;
        this.unparse();
    }

    private final void guiInit() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.guiNamePanel(), "North");
        panel.add((Component)this.guiWorkPanel(), "Center");
        panel.add((Component)this.guiPanelOkCancelHelp(), "South");
        this.classesInDiagramList.setSelectionMode(2);
        this.availableClassesList.setSelectionMode(2);
        this.getContentPane().add(panel);
    }

    private final JPanel guiNamePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        panel.setLayout(gridbag);
        panel.setBorder(new TitledBorder(new EtchedBorder(), "Diagram Name"));
        panel.add((Component)this.diagramNameTextField, constraints);
        return panel;
    }

    private final JPanel guiWorkPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridbag);
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        constraints.ipadx = 5;
        constraints.ipady = 5;
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.guiLeftSide(), constraints);
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        JPanel tmpPanel = this.guiMiddle();
        gridbag.setConstraints(tmpPanel, constraints);
        panel.add(tmpPanel);
        constraints.anchor = 18;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.guiRightSide(), constraints);
        return panel;
    }

    private final JPanel guiLeftSide() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        JScrollPane sPane = new JScrollPane(this.classesInDiagramList);
        leftPanel.setBorder(new TitledBorder(new EtchedBorder(), "classes of diagram"));
        leftPanel.add((Component)sPane, "Center");
        leftPanel.setPreferredSize(new Dimension(275, 425));
        return leftPanel;
    }

    private final JPanel guiRightSide() {
        JPanel rightPanel = new JPanel(new BorderLayout());
        JScrollPane sPane = new JScrollPane(this.availableClassesList);
        rightPanel.setBorder(new TitledBorder(new EtchedBorder(), "available classes"));
        rightPanel.add((Component)sPane, "Center");
        rightPanel.setPreferredSize(new Dimension(275, 425));
        return rightPanel;
    }

    private final JPanel guiMiddle() {
        GridLayout grid = new GridLayout(2, 1);
        JPanel contextPanel = new JPanel();
        contextPanel.setLayout(grid);
        contextPanel.setBorder(new TitledBorder(new EtchedBorder(), "Context"));
        contextPanel.add(this.buttonAddContext);
        contextPanel.add(this.buttonDeleteContext);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.buttonAddContext.addActionListener(new ButtonAddContextActionListener());
        this.buttonDeleteContext.addActionListener(new ButtonDeleteContextActionListener());
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        this.buttonAdd.addActionListener(new ButtonAddActionListener());
        panel.add((Component)this.buttonAdd, constraints);
        this.buttonDelete.addActionListener(new ButtonDeleteActionListener());
        panel.add((Component)this.buttonDelete, constraints);
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)contextPanel, constraints);
        return panel;
    }

    public void unparse() {
        if (this.classDiag != null) {
            this.diagramNameTextField.setText(this.classDiag.getName());
        }
        this.fillDisplayedClasses();
        this.fillAvailableClasses(UMLProject.get().getRootPackage());
        this.updateGuiList();
    }

    private void updateGuiList() {
        JglListModel displayedClassesListModel = new JglListModel(this.displayedClasses);
        displayedClassesListModel.setUseKey(true);
        this.classesInDiagramList.setModel(displayedClassesListModel);
        JglListModel availableClassesListModel = new JglListModel(this.availableClasses);
        availableClassesListModel.setUseKey(true);
        this.availableClassesList.setModel(availableClassesListModel);
    }

    private void fillDisplayedClasses() {
        this.displayedClasses.clear();
        this.initiallyDisplayedClasses.clear();
        Iterator iter = this.classDiag.iteratorOfElements();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof UMLClass)) continue;
            this.displayedClasses.put(((UMLClass)item).getFullClassName(), item);
            this.initiallyDisplayedClasses.add(item);
        }
    }

    private void fillAvailableClasses(UMLPackage pack) {
        Enumeration enumeration = pack.elementsOfAllChildren();
        while (enumeration.hasMoreElements()) {
            String key;
            Object obj = enumeration.nextElement();
            if (obj instanceof UMLPackage) {
                this.fillAvailableClasses((UMLPackage)obj);
                continue;
            }
            if (!(obj instanceof UMLClass) || this.displayedClasses.get(key = ((UMLClass)obj).getFullClassName()) != null) continue;
            this.availableClasses.put(key, obj);
        }
    }

    public void parse() {
        UMLCommentary comment;
        UMLClass clazz;
        boolean diagramNameValid = true;
        String newName = this.diagramNameTextField.getText();
        if (newName == null || newName.trim().equals("")) {
            WarningMessages.warnUnnamedDiagram(FrameMain.get(), "class");
            diagramNameValid = false;
        }
        Iterator<Object> iter = UMLProject.get().iteratorOfDiags();
        while (diagramNameValid && iter.hasNext()) {
            ASGDiagram diagram = (ASGDiagram)iter.next();
            if (!(diagram instanceof UMLClassDiagram) || diagram == this.classDiag || !diagram.getName().equals(newName)) continue;
            WarningMessages.warnDoubleIdentifiedDiagram(FrameMain.get(), "class", newName);
            diagramNameValid = false;
        }
        if (diagramNameValid) {
            this.classDiag.setName(this.diagramNameTextField.getText());
        }
        Set classesToRemove = this.initiallyDisplayedClasses;
        classesToRemove.removeAll(this.displayedClasses.values());
        iter = classesToRemove.iterator();
        while (iter.hasNext()) {
            UMLGeneralization generalization;
            Object obj = iter.next();
            if (!(obj instanceof UMLClass)) continue;
            clazz = (UMLClass)obj;
            comment = clazz.getComment();
            if (comment != null) {
                this.classDiag.removeFromElements(comment);
            }
            Iterator genIter = clazz.iteratorOfRevSubclass();
            while (genIter.hasNext()) {
                generalization = (UMLGeneralization)genIter.next();
                this.classDiag.removeFromElements(generalization);
            }
            genIter = clazz.iteratorOfRevSuperclass();
            while (genIter.hasNext()) {
                generalization = (UMLGeneralization)genIter.next();
                this.classDiag.removeFromElements(generalization);
            }
            Iterator rolesIter = clazz.iteratorOfRoles();
            while (rolesIter.hasNext()) {
                UMLRole role = (UMLRole)rolesIter.next();
                this.classDiag.removeFromElements(role.getAssoc());
            }
            String key = ((UMLClass)obj).getFullClassName();
            if (this.displayedClasses.get(key) != null) continue;
            this.classDiag.removeFromElements(clazz);
        }
        Collection classesToAdd = this.displayedClasses.values();
        classesToAdd.removeAll(this.initiallyDisplayedClasses);
        iter = classesToAdd.iterator();
        while (iter.hasNext()) {
            UMLGeneralization gen;
            clazz = (UMLClass)iter.next();
            this.classDiag.addToElements(clazz);
            comment = clazz.getComment();
            if (comment != null) {
                this.classDiag.addToElements(comment);
            }
            Enumeration enumGen = clazz.elementsOfRevSubclass();
            while (enumGen.hasMoreElements()) {
                gen = (UMLGeneralization)enumGen.nextElement();
                if (!this.classDiag.hasInElements(gen.getSuperclass())) continue;
                this.classDiag.addToElements(gen);
            }
            enumGen = clazz.elementsOfRevSuperclass();
            while (enumGen.hasMoreElements()) {
                gen = (UMLGeneralization)enumGen.nextElement();
                if (!this.classDiag.hasInElements(gen.getSubclass())) continue;
                this.classDiag.addToElements(gen);
            }
            Iterator roleIter = clazz.iteratorOfRoles();
            while (roleIter.hasNext()) {
                UMLClass partner;
                UMLRole role = (UMLRole)roleIter.next();
                UMLAssoc assoc = role.getAssoc();
                if (role.getPartnerRole() == null || !this.classDiag.hasInElements(partner = role.getPartnerRole().getTarget())) continue;
                this.classDiag.addToElements(assoc);
            }
        }
        FrameMain.get().createNewTreeItems();
        UMLProject.get().refreshDisplay();
    }

    void addToDisplayedClasses(Object[] add, boolean context) {
        this.moveClasses(this.displayedClasses, this.availableClasses, add, context);
    }

    void addToAvailableClasses(Object[] add, boolean context) {
        this.moveClasses(this.availableClasses, this.displayedClasses, add, context);
    }

    private Set moveClasses(TreeMap pasteInto, TreeMap cutFrom, Object[] classKeys, boolean context) {
        HashSet movedClasses = new HashSet();
        if (classKeys != null) {
            if (context) {
                int i = 0;
                while (i < classKeys.length) {
                    Object value = cutFrom.get(classKeys[i]);
                    if (value instanceof UMLClass) {
                        Set movedClassesWithContext = this.moveClasses(pasteInto, cutFrom, this.getContext((UMLClass)value));
                        movedClasses.addAll(movedClassesWithContext);
                    }
                    ++i;
                }
            }
            Set movedClassesWithoutContext = this.moveClasses(pasteInto, cutFrom, classKeys);
            movedClasses.addAll(movedClassesWithoutContext);
            this.updateGuiList();
        }
        return movedClasses;
    }

    private Set moveClasses(TreeMap pasteInto, TreeMap cutFrom, Object[] classKeys) {
        HashSet movedClasses = new HashSet();
        if (classKeys != null) {
            int i = 0;
            while (i < classKeys.length) {
                Object value = cutFrom.get(classKeys[i]);
                if (value instanceof UMLClass) {
                    cutFrom.remove(classKeys[i]);
                    pasteInto.put(classKeys[i], value);
                    movedClasses.add(value);
                }
                ++i;
            }
        }
        return movedClasses;
    }

    private Object[] getContext(UMLClass clazz) {
        UMLGeneralization gen;
        LinkedList<String> context = new LinkedList<String>();
        Enumeration enumeration = clazz.elementsOfRevSubclass();
        while (enumeration.hasMoreElements()) {
            gen = (UMLGeneralization)enumeration.nextElement();
            context.add(gen.getSuperclass().getFullClassName());
        }
        enumeration = clazz.elementsOfRevSuperclass();
        while (enumeration.hasMoreElements()) {
            gen = (UMLGeneralization)enumeration.nextElement();
            context.add(gen.getSubclass().getFullClassName());
        }
        Iterator iter = clazz.iteratorOfRoles();
        while (iter.hasNext()) {
            UMLRole role = (UMLRole)iter.next();
            UMLRole partner = role.getPartnerRole();
            context.add(partner.getTarget().getFullClassName());
        }
        return context.toArray();
    }

    class ButtonAddActionListener
    implements ActionListener {
        ButtonAddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EditClassDiagDialog.this.addToDisplayedClasses(EditClassDiagDialog.this.availableClassesList.getSelectedValues(), false);
        }
    }

    class ButtonAddContextActionListener
    implements ActionListener {
        ButtonAddContextActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EditClassDiagDialog.this.addToDisplayedClasses(EditClassDiagDialog.this.availableClassesList.getSelectedValues(), true);
        }
    }

    class ButtonDeleteActionListener
    implements ActionListener {
        ButtonDeleteActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EditClassDiagDialog.this.addToAvailableClasses(EditClassDiagDialog.this.classesInDiagramList.getSelectedValues(), false);
        }
    }

    class ButtonDeleteContextActionListener
    implements ActionListener {
        ButtonDeleteContextActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EditClassDiagDialog.this.addToAvailableClasses(EditClassDiagDialog.this.classesInDiagramList.getSelectedValues(), true);
        }
    }
}

