/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditNameAndConstraintsDialog
extends FujabaDialog {
    JList constraintList;
    private DefaultListModel constraintListModel;
    JTextField constraintTextField;
    private JTextField nameField;
    private ASGElement incr = null;

    public EditNameAndConstraintsDialog(JFrame frame, boolean enableName) {
        super(frame, "Constraint editor", true);
        this.guiInit(enableName);
    }

    public void guiInit(boolean enableName) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel constraintListPanel = new JPanel(new BorderLayout());
        constraintListPanel.setBorder(new TitledBorder("Constraint selection list"));
        this.constraintListModel = new DefaultListModel();
        this.constraintList = new JList(this.constraintListModel);
        JScrollPane constraintScrollPane = new JScrollPane(this.constraintList);
        this.constraintList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                String constraintText;
                UMLConstraint constraint = (UMLConstraint)EditNameAndConstraintsDialog.this.constraintList.getSelectedValue();
                if (constraint != null && (constraintText = constraint.getText()) != null) {
                    EditNameAndConstraintsDialog.this.constraintTextField.setText(constraintText);
                }
            }
        });
        constraintListPanel.add(constraintScrollPane);
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(new TitledBorder("Name"));
        this.nameField = new JTextField();
        namePanel.add((Component)this.nameField, "North");
        JPanel constraintPanel = new JPanel(new BorderLayout());
        constraintPanel.setBorder(new TitledBorder("Constraint text"));
        this.constraintTextField = new JTextField();
        constraintPanel.add((Component)this.constraintTextField, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton applyButton = new JButton("Apply");
        JButton newButton = new JButton("New");
        JButton removeButton = new JButton("Remove");
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditNameAndConstraintsDialog.this.writeFieldsToConstraint((UMLConstraint)EditNameAndConstraintsDialog.this.constraintList.getSelectedValue());
            }
        });
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditNameAndConstraintsDialog.this.makeNewConstraint();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditNameAndConstraintsDialog.this.removeConstraint((UMLConstraint)EditNameAndConstraintsDialog.this.constraintList.getSelectedValue());
            }
        });
        buttonPanel.add(newButton);
        buttonPanel.add(applyButton);
        buttonPanel.add(removeButton);
        if (enableName) {
            mainPanel.add(namePanel);
        }
        mainPanel.add(constraintListPanel);
        mainPanel.add(constraintPanel);
        mainPanel.add(buttonPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", mainPanel);
        container.add("South", this.guiPanelOkCancelHelp());
        this.pack();
    }

    void makeNewConstraint() {
        UMLConstraint newConstraint = new UMLConstraint();
        if (this.incr instanceof UMLIncrement) {
            ((UMLIncrement)this.incr).addToConstraints(newConstraint);
        } else if (this.incr instanceof UMLDiagram) {
            ((UMLDiagram)this.incr).addToConstraints(newConstraint);
        }
        this.constraintListModel.addElement(newConstraint);
        this.writeFieldsToConstraint(newConstraint);
        this.clearFieldsAndUpdateListBox();
    }

    void removeConstraint(UMLConstraint constraint) {
        this.constraintListModel.removeElement(constraint);
        constraint.removeYou();
        this.clearFieldsAndUpdateListBox();
    }

    private void clearFieldsAndUpdateListBox() {
        this.constraintList.setModel(this.constraintListModel);
        this.constraintTextField.setText("");
    }

    void writeFieldsToConstraint(UMLConstraint constraint) {
        if (constraint != null) {
            constraint.setText(this.constraintTextField.getText());
            this.clearFieldsAndUpdateListBox();
        }
    }

    public void unparse(ASGElement incr) {
        this.incr = incr;
        if (incr != null) {
            if (incr instanceof UMLStoryPattern || incr instanceof ViewDiagram && ((ViewDiagram)incr).getOriginalDiagram() instanceof UMLStoryPattern) {
                this.nameField.setText(incr.getName());
            }
            Iterator iter = null;
            iter = incr instanceof UMLIncrement ? ((UMLIncrement)incr).iteratorOfConstraints() : (incr instanceof UMLDiagram ? ((UMLDiagram)incr).iteratorOfConstraints() : FEmptyIterator.get());
            while (iter.hasNext()) {
                UMLConstraint tmpConst = (UMLConstraint)iter.next();
                this.constraintListModel.addElement(tmpConst);
            }
        }
    }

    public void parse() {
        String name = this.nameField.getText();
        if ((this.incr instanceof UMLStoryPattern || this.incr instanceof ViewDiagram && ((ViewDiagram)this.incr).getOriginalDiagram() instanceof UMLStoryPattern) && name.trim().length() != 0) {
            this.incr.setName(name);
        }
    }
}

