/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.CompletionKeyListener;
import de.uni_paderborn.fujaba.gui.PEActAssertion_addButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEActAssertion_modifyButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEActAssertion_removeButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEAttrSelection;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListbox;
import de.uni_paderborn.fujaba.gui.PERadioGroup;
import de.uni_paderborn.fujaba.gui.PERow;
import de.uni_paderborn.fujaba.gui.PEStringListModel;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PEVariable;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLAttrExprPair;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FLinkedList;
import java.awt.GridLayout;
import java.util.Iterator;
import javax.swing.JFrame;

public class PEActAssertion
extends PropertyEditor {
    public static final String ASSIGN = ":=";
    public static final String EQUAL = "=";
    public static final String NOTEQUAL = "!=";
    public static final String LESS = "<";
    public static final String GREATER = ">";
    public static final String LESSEQUAL = "<=";
    public static final String GREATEREQUAL = ">=";
    public static final String[] OPERATIONS = new String[]{":=", "=", "!=", "<", ">", "<=", ">="};
    private PERadioGroup operation;
    private PECheck assertion;
    private PETextField attrName;
    private PETextField value;
    private PEAttrSelection selection;
    private FLinkedList addExpr = new FLinkedList();
    private FLinkedList delExpr = new FLinkedList();

    public PETextField getAttrName() {
        return this.attrName;
    }

    public PEActAssertion(JFrame frame) {
        super(frame);
        this.setTitle("Attribute Assignment and Assertion Editor");
        this.initPE();
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.operation = new PERadioGroup(this, "Operation", OPERATIONS);
        this.operation.setStatus("Select the operation.");
        this.operation.setLayout(new GridLayout(1, 0));
        this.operation.setSelectedButtonIndex(0);
        this.assertion = new PECheck(this, "", "JUnit Assert");
        this.assertion.setStatus("Select the assign/assert behaviour");
        this.attrName = new PETextField(this, "Attribute Name");
        this.value = new PETextField(this, "Value");
        this.value.setStatus("Enter the value for the attribut");
        this.selection = new PEAttrSelection(this);
        this.selection.setAddListener(new PEActAssertion_addButton_actionAdapter(this));
        this.selection.setRemoveListener(new PEActAssertion_removeButton_actionAdapter(this));
        this.selection.setModifyListener(new PEActAssertion_modifyButton_actionAdapter(this));
        PEColumn column = new PEColumn(this);
        column.add(this.attrName);
        PERow row = new PERow(this);
        row.add(this.operation);
        row.add(this.assertion);
        column.add(row);
        column.add(this.value);
        column.add(this.selection);
        panel.add(column);
    }

    public String getPropertyName() {
        return "assertion";
    }

    protected void unparse() {
        if (this.getIncrement() != null && this.getIncrement() instanceof UMLObject) {
            UMLObject myObj = (UMLObject)this.getIncrement();
            this.value.addKeyListener(new CompletionKeyListener(myObj));
            this.selection.setIncrement(this.getIncrement());
        }
    }

    protected void parse() {
        if (this.getIncrement() instanceof UMLObject) {
            Iterator exprsIter = this.delExpr.iterator();
            UMLAttrExprPair expr = null;
            while (exprsIter.hasNext()) {
                expr = (UMLAttrExprPair)exprsIter.next();
                expr.removeYou();
            }
            UMLObject curObj = (UMLObject)this.getIncrement();
            exprsIter = this.addExpr.iterator();
            while (exprsIter.hasNext()) {
                expr = (UMLAttrExprPair)exprsIter.next();
                curObj.addToAttrs(expr);
            }
        }
        this.addExpr.clear();
        this.delExpr.clear();
    }

    protected void cancel() {
        Iterator exprs = this.addExpr.iterator();
        UMLAttrExprPair expr = null;
        while (exprs.hasNext()) {
            expr = (UMLAttrExprPair)exprs.next();
            expr.removeYou();
        }
        this.delExpr.clear();
        this.addExpr.clear();
    }

    private void provideAttrSelection() {
        String newAttrName;
        UMLObject curObj;
        UMLClass curClass;
        if (this.getIncrement() instanceof UMLObject && (curClass = (curObj = (UMLObject)this.getIncrement()).getInstanceOf()) != null && (newAttrName = this.attrName.getText()) != null && !newAttrName.equals("")) {
            UMLAttr newAttr = curClass.getFromAllAttrs(newAttrName);
            if (newAttr == null) {
                UMLBaseTypes str = UMLProject.get().getFromBaseTypes("String");
                newAttr = new UMLAttr(newAttrName, false, false, 1, null, str, curClass, null);
                PEVariable.handleAccessMethods(null, true, 1, newAttr);
                this.selection.fillSourceList();
            }
            this.selection.setSourceSelectedIncr(newAttr);
        }
    }

    public void addPressed() {
        ASGElement incr = null;
        if (this.value.getText().length() == 0) {
            return;
        }
        this.provideAttrSelection();
        String name = this.attrName.getText();
        if (this.selection.getSourceSelectedIncr() != null && (incr = this.selection.getSourceSelectedIncr()) instanceof UMLAttr) {
            name = incr.getName();
        }
        if (name != null && !name.equals("")) {
            int operationType = this.operation.getSelectedButtonIndex();
            int assertionType = operationType == 0 ? 2 : 1;
            operationType = operationType >= 1 ? operationType - 1 : 0;
            UMLAttrExprPair expression = new UMLAttrExprPair(name, assertionType, operationType, this.value.getText(), (UMLAttr)incr, null);
            expression.setAssertInUnitTest(this.assertion.isSelected());
            this.addExpr.add(expression);
            this.selection.addToDest(expression);
        }
    }

    public void removePressed() {
        UMLAttrExprPair expr = (UMLAttrExprPair)this.selection.getDestSelectedIncr();
        if (expr != null) {
            this.delExpr.add(expr);
            this.selection.removeFromDest(expr);
        }
    }

    public void modifyPressed() {
        ASGElement incr;
        if (this.selection.getSourceSelectedIncr() != null && this.value.getText().length() > 0 && (incr = this.selection.getDestSelectedIncr()) instanceof UMLAttrExprPair) {
            UMLAttrExprPair expression = (UMLAttrExprPair)incr;
            incr = this.selection.getSourceSelectedIncr();
            if (incr instanceof UMLAttr) {
                UMLAttr attr = (UMLAttr)incr;
                String name = attr.getName();
                int operationType = this.operation.getSelectedButtonIndex();
                int assertionType = operationType == 0 ? 2 : 1;
                operationType = operationType >= 1 ? operationType - 1 : 0;
                expression.setName(name);
                expression.setOperation(operationType);
                expression.setQualifier(assertionType);
                expression.setExpression(this.value.getText());
                expression.setInstanceOf(attr);
                expression.setAssertInUnitTest(this.assertion.isSelected());
                PEListbox list = this.selection.getDest().getList();
                PEStringListModel model = (PEStringListModel)list.getModel();
                model.setElementAt(expression.getText(), list.getSelectedIndex());
            }
        }
    }

    public void selectionChanged(UMLAttrExprPair attrPair) {
        int operationType;
        UMLAttr attr = attrPair.getInstanceOf();
        if (attr != null) {
            this.attrName.setText(attr.getName());
        }
        if ((operationType = attrPair.getQualifier() - 1) < 0) {
            operationType = 0;
        }
        operationType = operationType == 0 ? attrPair.getOperation() + 1 : 0;
        this.operation.setSelectedButtonIndex(operationType);
        this.value.setText(attrPair.getExpression());
        this.assertion.setSelected(attrPair.isAssertInUnitTest());
    }
}

