/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.FujabaComparator;
import de.uni_paderborn.fujaba.gui.EditAssocDialog;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEItem;
import de.uni_paderborn.fujaba.gui.PEListEntry;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PERadioGroup;
import de.uni_paderborn.fujaba.gui.PERolePanel;
import de.uni_paderborn.fujaba.gui.PERow;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLCardinality;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLPath;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.utility.MultiLinkGenerator;
import de.uni_paderborn.fujaba.uml.utility.UMLObjectDiagramUtility;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FTreeSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PEActLink
extends PropertyEditor {
    public static final String NullLink = "Null";
    public static final String NegLink = "Negative";
    public static final String OptLink = "Optional";
    public static final String NoneLink = "None";
    public static final String DeleteLink = "Destroy";
    public static final String CreateLink = "Create";
    public static final String AnyElement = "Any";
    public static final String FirstElement = "First";
    public static final String LastElement = "Last";
    public static final String TotalityLink = "Totality";
    public static final String AssertLink = "Assert";
    public static final String ChildElement = "Child Element";
    public static final String IDRef = "IDRef";
    private UMLIncrement second;
    private PERolePanel rolePanel;
    private PETextField name;
    private PEListIncr associations;
    private PETextField range;
    private PERadioGroup type;
    private PERadioGroup multiLinkRadioGoup;
    private JComboBox containerComboBox;
    private PERadioGroup modifier;
    private PECheck set;
    private PECheck assertion;
    private PETextField pathExpr;

    public PEActLink(JFrame frame) {
        super(frame);
        this.setTitle("Link Activity Editor");
        this.initPE();
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.name = new PETextField(this, "Name");
        this.name.setStatus("Enter the name of the link");
        this.associations = new PEListIncr(this, "Associations");
        this.associations.setStatus("Select the association");
        this.associations.addSelectionListener(new PESelectionListener(this));
        this.range = new PETextField(this, "Range");
        String[] typeNames = new String[]{NullLink, NegLink, OptLink};
        this.type = new PERadioGroup(this, "Type", typeNames);
        this.type.setStatus("Select the type of the link");
        String[] modifierNames = new String[]{NoneLink, DeleteLink, CreateLink};
        this.modifier = new PERadioGroup(this, "Modifier", modifierNames);
        this.modifier.setStatus("Select the modifier");
        PERow multiLinkPanel = new PERow(this);
        multiLinkPanel.setBorder(new TitledBorder("MultiLink"));
        String[] sortNames = new String[]{AnyElement, FirstElement, LastElement};
        this.multiLinkRadioGoup = new PERadioGroup(this, "Type", sortNames);
        String helpTextSortNames = "Select from which position of the sorted assoc the object should be.";
        this.modifier.setStatus(helpTextSortNames);
        this.multiLinkRadioGoup.setToolTipText(helpTextSortNames);
        multiLinkPanel.add(this.multiLinkRadioGoup);
        PEColumn containerColumn = new PEColumn(this);
        JLabel containerLabel = new JLabel(" Container Object");
        containerColumn.add(containerLabel);
        this.containerComboBox = new JComboBox();
        this.containerComboBox.setRenderer(new MyCellRenderer());
        containerColumn.add(this.containerComboBox);
        multiLinkPanel.add(containerColumn);
        this.multiLinkRadioGoup.setEnabled(false);
        this.containerComboBox.setEnabled(false);
        PERow setPanel = new PERow(this);
        setPanel.setBorder(new TitledBorder("Set Behavior"));
        this.set = new PECheck(this, "", TotalityLink);
        this.set.setStatus("Select the set behaviour");
        setPanel.add(this.set);
        this.assertion = new PECheck(this, "", AssertLink);
        this.assertion.setStatus("Select the assert behaviour");
        setPanel.add(this.assertion);
        this.rolePanel = new PERolePanel();
        this.pathExpr = new PETextField(this, "Path Expression");
        this.pathExpr.setStatus("Enter a path expression like a.b.c*");
        PEColumn column = new PEColumn(this);
        column.add(this.rolePanel);
        column.add(this.name);
        column.add(this.associations);
        column.add(this.range);
        PERow modRow = new PERow(this);
        modRow.add(this.type);
        modRow.add(this.modifier);
        modRow.add(setPanel);
        modRow.add(multiLinkPanel);
        column.add(modRow);
        column.add(this.pathExpr);
        panel.add(column);
    }

    public void setIncrement(UMLIncrement incr, UMLIncrement addIncr) {
        this.second = addIncr;
        super.setIncrement(incr);
    }

    public void rolePanelItemStateChanged(ItemEvent e) {
        UMLObject srcObj = (UMLObject)((PEObjListEntry)this.rolePanel.getLeftComboSelectedItem()).getItem();
        UMLObject tgtObj = (UMLObject)((PEObjListEntry)this.rolePanel.getRightComboSelectedItem()).getItem();
        this.fillAssociations(srcObj, tgtObj);
    }

    public String getPropertyName() {
        return "ActivityLink";
    }

    private boolean checkMultiLinkMode(UMLAssoc assoc) {
        if (assoc != null) {
            Iterator iter = assoc.iteratorOfConstraints();
            while (iter.hasNext()) {
                UMLConstraint constraint = (UMLConstraint)iter.next();
                if (!constraint.getText().equals("sorted") && !constraint.getText().equals("ordered") || this.rolePanel.getLeftComboSelectedItem() == null || this.rolePanel.getRightComboSelectedItem() == null) continue;
                this.multiLinkRadioGoup.setEnabled(true);
                this.containerComboBox.setEnabled(true);
                this.fillContainerComboBox(assoc);
                return true;
            }
        }
        this.multiLinkRadioGoup.setEnabled(false);
        this.containerComboBox.setEnabled(false);
        return false;
    }

    private void fillContainerComboBox(UMLAssoc assoc) {
        int leftCard = assoc.getLeftRole().getCard().getUpperBound();
        int rightCard = assoc.getRightRole().getCard().getUpperBound();
        UMLObject sourceObj = (UMLObject)((PEObjListEntry)this.rolePanel.getLeftComboSelectedItem()).getItem();
        UMLObject targetObj = (UMLObject)((PEObjListEntry)this.rolePanel.getRightComboSelectedItem()).getItem();
        UMLClass leftClass = assoc.getLeftRole().getTarget();
        UMLClass rightClass = assoc.getRightRole().getTarget();
        this.containerComboBox.removeAllItems();
        if (rightCard > 1) {
            if (sourceObj != null && sourceObj.getInstanceOf() == leftClass) {
                this.containerComboBox.addItem(sourceObj);
                this.containerComboBox.setSelectedIndex(0);
            } else if (targetObj != null && targetObj.getInstanceOf() == leftClass) {
                this.containerComboBox.addItem(targetObj);
                this.containerComboBox.setSelectedIndex(0);
            }
        }
        if (leftCard > 1) {
            if (sourceObj != null && sourceObj.getInstanceOf() == rightClass) {
                this.containerComboBox.addItem(sourceObj);
                this.containerComboBox.setSelectedIndex(0);
            } else if (targetObj != null && targetObj.getInstanceOf() == rightClass) {
                this.containerComboBox.addItem(targetObj);
                this.containerComboBox.setSelectedIndex(0);
            }
        }
    }

    private void fillAssocs(FTreeSet intersection, UMLClass class1, UMLClass class2) {
        UMLAssoc firstAssoc = null;
        this.associations.removeAll();
        Iterator iter = intersection.iterator();
        while (iter.hasNext()) {
            UMLAssoc tmpAssoc = (UMLAssoc)iter.next();
            UMLClass left = tmpAssoc.getLeftRole().getTarget();
            UMLClass right = tmpAssoc.getRightRole().getTarget();
            if ((!class1.isChildOf(left) || !class2.isChildOf(right)) && (!class2.isChildOf(left) || !class1.isChildOf(right))) continue;
            this.associations.add(tmpAssoc);
            if (firstAssoc != null) continue;
            firstAssoc = tmpAssoc;
        }
        if (firstAssoc != null) {
            this.associations.selectIncrement(firstAssoc);
        }
    }

    private void fillAssociations(UMLLink link) {
        FTreeSet assocs = UMLObjectDiagramUtility.getAssociations(link);
        UMLClass firstClass = null;
        UMLClass secondClass = null;
        UMLObject object = link.getSource();
        if (object != null) {
            firstClass = object.getInstanceOf();
        }
        if ((object = link.getTarget()) != null) {
            secondClass = object.getInstanceOf();
        }
        this.fillAssocs(assocs, firstClass, secondClass);
    }

    private void fillAssociations(UMLObject srcObj, UMLObject tgtObj) {
        FTreeSet intersection = UMLObjectDiagramUtility.getAssociations(srcObj, tgtObj);
        UMLClass firstClass = srcObj.getInstanceOf();
        UMLClass secondClass = tgtObj.getInstanceOf();
        this.fillAssocs(intersection, firstClass, secondClass);
    }

    private void fillRolePanel(UMLObject sourceObj, UMLObject targetObj, UMLDiagram diag) {
        UMLClass tmpClass;
        boolean addClassDiagDeclsOnTheFlyOption = true;
        PEObjListEntry sourceEntry = null;
        PEObjListEntry targetEntry = null;
        Iterator itemsIter = diag.iteratorOfElements();
        while (itemsIter.hasNext()) {
            ASGElement tmpItem = (ASGElement)itemsIter.next();
            if (!(tmpItem instanceof UMLObject)) continue;
            UMLObject tmpObj = (UMLObject)tmpItem;
            PEObjListEntry newEntry = new PEObjListEntry(tmpObj);
            boolean isSource = false;
            boolean isTarget = false;
            boolean interfaceIsTarget = false;
            UMLClass instClass = tmpObj.getInstanceOf();
            while (instClass != null) {
                Iterator tmpIter = instClass.iteratorOfRoles();
                while (tmpIter.hasNext()) {
                    UMLRole tmpRole = (UMLRole)tmpIter.next();
                    if (tmpRole.getRevLeftRole() != null) {
                        isSource = true;
                    }
                    if (tmpRole.getRevRightRole() == null) continue;
                    isTarget = true;
                }
                Iterator genIter = instClass.iteratorOfRevSubclass();
                instClass = null;
                while (genIter.hasNext() && instClass == null) {
                    UMLClass tmpClass2 = ((UMLGeneralization)genIter.next()).getSuperclass();
                    if (!tmpClass2.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"))) {
                        instClass = tmpClass2;
                        continue;
                    }
                    tmpIter = tmpClass2.iteratorOfRoles();
                    while (tmpIter.hasNext()) {
                        UMLRole tmpRole = (UMLRole)tmpIter.next();
                        if (tmpRole.getRevRightRole() == null) continue;
                        interfaceIsTarget = true;
                    }
                }
            }
            if (isSource || addClassDiagDeclsOnTheFlyOption) {
                this.rolePanel.addItemToLeftComboBox(newEntry);
            }
            if (isTarget || interfaceIsTarget || addClassDiagDeclsOnTheFlyOption) {
                this.rolePanel.addItemToRightComboBox(newEntry);
            }
            if (tmpObj == sourceObj) {
                sourceEntry = newEntry;
                this.rolePanel.setLeftComboSelectedItem(sourceEntry);
            }
            if (tmpObj != targetObj) continue;
            targetEntry = newEntry;
            this.rolePanel.setRightComboSelectedItem(targetEntry);
        }
        UMLClass sourceClass = sourceObj.getInstanceOf();
        UMLClass targetClass = targetObj.getInstanceOf();
        TreeSet<UMLClass> sourceClassAndParents = new TreeSet<UMLClass>(FujabaComparator.getLessBasicIncr());
        TreeSet<UMLClass> targetClassAndParents = new TreeSet<UMLClass>(FujabaComparator.getLessBasicIncr());
        UMLClass startClass = sourceClass;
        while (startClass != null) {
            sourceClassAndParents.add(startClass);
            Iterator genIter = startClass.iteratorOfRevSubclass();
            while (genIter.hasNext()) {
                tmpClass = ((UMLGeneralization)genIter.next()).getSuperclass();
                if (!tmpClass.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"))) continue;
                sourceClassAndParents.add(tmpClass);
            }
            startClass = startClass.getSuperClass();
        }
        startClass = targetClass;
        while (startClass != null) {
            targetClassAndParents.add(startClass);
            Iterator genIter = startClass.iteratorOfRevSubclass();
            while (genIter.hasNext()) {
                tmpClass = ((UMLGeneralization)genIter.next()).getSuperclass();
                if (!tmpClass.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"))) continue;
                targetClassAndParents.add(tmpClass);
            }
            startClass = startClass.getSuperClass();
        }
        Enumeration enumeration = this.associations.elements();
        while (enumeration.hasMoreElements()) {
            UMLAssoc assoc = (UMLAssoc)((PEItem)enumeration.nextElement()).getIncrement();
            UMLClass leftClass = assoc.getLeftRole().getTarget();
            UMLClass rightClass = assoc.getRightRole().getTarget();
            if (sourceClassAndParents.contains(leftClass) && targetClassAndParents.contains(rightClass)) {
                this.rolePanel.setLeftComboSelectedItem(sourceEntry);
                this.rolePanel.setRightComboSelectedItem(targetEntry);
                continue;
            }
            if (!sourceClassAndParents.contains(rightClass) || !targetClassAndParents.contains(leftClass)) continue;
            this.rolePanel.setLeftComboSelectedItem(targetEntry);
            this.rolePanel.setRightComboSelectedItem(sourceEntry);
        }
        this.rolePanel.addItemListener(new PERolePanelItemListener(this));
    }

    protected void unparse() {
        if (this.getIncrement() != null) {
            ASGElement asgElement = this.getIncrement();
            if (asgElement instanceof UMLPath) {
                UMLPath myPath = (UMLPath)asgElement;
                this.pathExpr.setText(myPath.getExpression());
            } else if (asgElement instanceof UMLLink) {
                UMLMultiLink multiLink;
                UMLLink link = (UMLLink)asgElement;
                this.fillAssociations(link);
                this.fillRolePanel(link.getSource(), link.getTarget(), link.getCurrentActiveDiagram());
                this.checkMultiLinkMode(link.getInstanceOf());
                this.name.setText(link.getName());
                if (link.getInstanceOf() != null) {
                    this.associations.selectIncrement(link.getInstanceOf());
                }
                this.range.setText(link.getRange());
                this.type.setSelectedButtonIndex(link.getType());
                this.modifier.setSelectedButtonIndex(link.getModifier());
                this.set.setSelected(link.getTotality());
                this.set.setEnabled(link.getSource().isSet() && link.getTarget().isSet());
                this.assertion.setSelected(link.isAssertInUnitTest());
                if (link.getRevTargetLink() != null) {
                    UMLMultiLink multiLink2 = link.getRevTargetLink();
                    if (multiLink2.getType() == 0) {
                        this.multiLinkRadioGoup.setSelectedButtonIndex(1);
                    }
                } else if (link.getRevSourceLink() != null && (multiLink = link.getRevSourceLink()).getType() == 1) {
                    this.multiLinkRadioGoup.setSelectedButtonIndex(2);
                }
            } else if (asgElement instanceof UMLObject && this.second instanceof UMLObject) {
                UMLObject srcObj = (UMLObject)asgElement;
                UMLObject tgtObj = (UMLObject)this.second;
                this.fillAssociations(srcObj, tgtObj);
                this.fillRolePanel(srcObj, tgtObj, srcObj.getCurrentActiveDiagram());
                if (this.associations.getSelectedIncrement() != null) {
                    this.checkMultiLinkMode((UMLAssoc)this.associations.getSelectedIncrement());
                } else {
                    this.checkMultiLinkMode(null);
                }
            }
        }
    }

    protected void parse() {
        ASGElement asgElement = this.getIncrement();
        if (asgElement != null) {
            UMLLink link = null;
            if (asgElement instanceof UMLPath) {
                UMLPath myPath = (UMLPath)asgElement;
                myPath.setExpression(this.pathExpr.getText());
            } else if (asgElement instanceof UMLLink) {
                UMLLink oldLink = (UMLLink)asgElement;
                link = new UMLLink();
                String linkName = this.name.getText();
                if (linkName == null || linkName.equals("")) {
                    return;
                }
                UMLObject sourceObj = (UMLObject)((PEObjListEntry)this.rolePanel.getLeftComboSelectedItem()).getItem();
                UMLObject targetObj = (UMLObject)((PEObjListEntry)this.rolePanel.getRightComboSelectedItem()).getItem();
                UMLAssoc myAssoc = this.findOrNewAssocForLinkName(linkName, sourceObj, targetObj);
                link.setInstanceOf(myAssoc);
                link.setName(linkName);
                link.setRange(this.range.getText() == null ? "" : this.range.getText());
                link.setType(this.type.getSelectedButtonIndex());
                link.setModifier(this.modifier.getSelectedButtonIndex());
                link.setTotality(this.set.isSelected());
                link.setAssertInUnitTest(this.assertion.isSelected());
                UMLObject oldSourceObj = link.getSource();
                UMLObject oldTargetObj = link.getTarget();
                if (oldSourceObj != sourceObj) {
                    link.setSource(sourceObj);
                }
                if (oldTargetObj != targetObj) {
                    link.setTarget(targetObj);
                }
                Iterator iter = oldLink.iteratorOfDiagrams();
                while (iter.hasNext()) {
                    ASGDiagram diag = (ASGDiagram)iter.next();
                    diag.addToElements(link);
                }
                oldLink.removeYou();
            } else if (asgElement instanceof UMLObject && this.second instanceof UMLObject) {
                String linkName = this.name.getText();
                String pathText = this.pathExpr.getText();
                UMLObject sourceObj = (UMLObject)((PEObjListEntry)this.rolePanel.getLeftComboSelectedItem()).getItem();
                UMLObject targetObj = (UMLObject)((PEObjListEntry)this.rolePanel.getRightComboSelectedItem()).getItem();
                if (linkName != null && !linkName.equals("")) {
                    boolean doLink;
                    boolean bl = doLink = pathText == null || pathText.equals("");
                    if (doLink) {
                        UMLAssoc myAssoc = this.findOrNewAssocForLinkName(linkName, sourceObj, targetObj);
                        link = new UMLLink(this.name.getText(), this.type.getSelectedButtonIndex(), this.modifier.getSelectedButtonIndex(), "", sourceObj, targetObj, myAssoc);
                        if (this.range.getText().length() > 0) {
                            link.setRange(this.range.getText());
                        }
                        this.addToAllDiags(asgElement, link);
                        if (this.multiLinkRadioGoup.isEnabled() && link != null) {
                            if (link.getRevSourceLink() != null) {
                                link.getRevSourceLink().removeYou();
                            }
                            if (link.getRevTargetLink() != null) {
                                link.getRevTargetLink().removeYou();
                            }
                            switch (this.multiLinkRadioGoup.getSelectedButtonIndex()) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    MultiLinkGenerator myGenerator = new MultiLinkGenerator();
                                    UMLObject obj = (UMLObject)this.containerComboBox.getSelectedItem();
                                    myGenerator.generateFirstMultiLink(obj, link);
                                    break;
                                }
                                case 2: {
                                    MultiLinkGenerator myGenerator = new MultiLinkGenerator();
                                    UMLObject obj = (UMLObject)this.containerComboBox.getSelectedItem();
                                    myGenerator.generateLastMultiLink(obj, link);
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    pathText = this.pathExpr.getText();
                    if (pathText != null && !pathText.equals("")) {
                        UMLPath myPath = new UMLPath(sourceObj, pathText, targetObj);
                        Iterator iter = sourceObj.iteratorOfDiagrams();
                        if (iter.hasNext()) {
                            UMLDiagram diag = (UMLDiagram)iter.next();
                            diag.addToElements(myPath);
                        }
                    }
                }
            } else if (link != null) {
                if (link.getRevSourceLink() != null) {
                    link.getRevSourceLink().removeYou();
                }
                if (link.getRevTargetLink() != null) {
                    link.getRevTargetLink().removeYou();
                }
            }
        }
    }

    private void addToAllDiags(ASGElement asgElement, UMLLink link) {
        Iterator diags = ((UMLObject)asgElement).iteratorOfDiagrams();
        if (diags != null) {
            UMLDiagram diag = null;
            while (diags.hasNext()) {
                ViewDiagram viewDiag;
                Iterator viewDefIter;
                diag = (UMLDiagram)diags.next();
                if (!diag.hasInElements(asgElement) || !diag.hasInElements(this.second) || !(diag instanceof ViewDiagram) || !(viewDefIter = (viewDiag = (ViewDiagram)diag).iteratorOfViewDefinitions()).hasNext()) continue;
                ViewDefinition viewDefinition = (ViewDefinition)viewDefIter.next();
                viewDefinition.addToItems(link);
                viewDefinition.addToStartItems(link);
            }
            diags = ((UMLObject)asgElement).iteratorOfDiagrams();
            if (diags != null) {
                diag = null;
                while (diags.hasNext()) {
                    diag = (UMLDiagram)diags.next();
                    if (!diag.hasInElements(asgElement) || !diag.hasInElements(this.second) || diag instanceof ViewDiagram) continue;
                    diag.addToElements(link);
                }
            }
        }
    }

    private UMLAssoc findOrNewAssocForLinkName(String linkName, UMLObject sourceObj, UMLObject targetObj) {
        UMLAssoc myAssoc = (UMLAssoc)this.associations.getSelectedIncrement();
        if (!(myAssoc != null && linkName.equals(myAssoc.getName()) || (myAssoc = this.findAssocForLinkName(linkName)) != null)) {
            myAssoc = this.createAssocOnTheFly(sourceObj, targetObj, linkName);
        }
        return myAssoc;
    }

    private UMLAssoc findAssocForLinkName(String linkName) {
        if (linkName == null) {
            return null;
        }
        Enumeration myEnum = this.associations.elements();
        while (myEnum.hasMoreElements()) {
            UMLAssoc myAssoc = (UMLAssoc)((PEItem)myEnum.nextElement()).getIncrement();
            if (!linkName.equals(myAssoc.getName())) continue;
            return myAssoc;
        }
        return null;
    }

    private UMLAssoc createAssocOnTheFly(UMLObject sourceObj, UMLObject targetObj, String name) {
        UMLClass srcClass = sourceObj.getInstanceOf();
        UMLClass tgtClass = targetObj.getInstanceOf();
        if (srcClass == null || tgtClass == null) {
            return null;
        }
        UMLRole leftRole = new UMLRole();
        leftRole.setCard(new UMLCardinality());
        leftRole.setTarget(srcClass);
        UMLRole rightRole = new UMLRole();
        rightRole.setCard(new UMLCardinality());
        rightRole.setTarget(tgtClass);
        UMLAssoc result = new UMLAssoc(name, 10, null, leftRole, rightRole);
        leftRole.getCard().setCardString("0..1");
        String rightRoleName = name;
        if (name.endsWith("s") || name.endsWith("en")) {
            rightRole.getCard().setCardString("0..n");
        } else {
            rightRole.getCard().setCardString("0..1");
        }
        String leftRoleName = EditAssocDialog.toUnused(srcClass.getName(), leftRole, rightRoleName, rightRole, tgtClass);
        leftRole.setName(leftRoleName);
        rightRoleName = EditAssocDialog.toUnused(rightRoleName, rightRole, leftRoleName, leftRole, srcClass);
        rightRole.setName(rightRoleName);
        EditAssocDialog.addAssocToAllClassDiags(result);
        return result;
    }

    protected void cancel() {
    }

    public void selectionChanged() {
        ASGElement selectedAssoc = this.associations.getSelectedIncrement();
        if (selectedAssoc != null) {
            this.name.setText(selectedAssoc.getText());
        }
        if (selectedAssoc instanceof UMLAssoc) {
            UMLAssoc assoc = (UMLAssoc)selectedAssoc;
            this.checkMultiLinkMode(assoc);
        } else {
            this.multiLinkRadioGoup.setEnabled(false);
            this.containerComboBox.setEnabled(false);
        }
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        if (buttonIdentifier.equals(IDRef)) {
            this.name.setReadOnly(true);
        } else if (buttonIdentifier.equals(ChildElement) && this.name.isReadOnly()) {
            this.name.setReadOnly(false);
        }
        return PEButton.remainedUnbound;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof UMLObject) {
                UMLObject obj = (UMLObject)value;
                this.setText(" " + obj.getObjectName() + ": " + obj.getInstanceOf() + " ");
            } else {
                this.setText("unknown_value");
            }
            return this;
        }
    }

    class PESelectionListener
    implements ListSelectionListener {
        PEActLink adaptor;

        PESelectionListener(PEActLink adapter) {
            this.adaptor = adapter;
        }

        public void valueChanged(ListSelectionEvent e) {
            this.adaptor.selectionChanged();
        }
    }

    class PEObjListEntry
    extends PEListEntry {
        public PEObjListEntry(UMLObject obj) {
            super(obj);
        }

        public String toString() {
            UMLObject tmpObj = (UMLObject)this.getItem();
            String result = tmpObj.getObjectName();
            if (!tmpObj.isBound()) {
                result = String.valueOf(result) + ":" + tmpObj.getObjectType();
            }
            return result;
        }
    }

    class PERolePanelItemListener
    implements ItemListener {
        private PEActLink adaptee;

        public PERolePanelItemListener(PEActLink adaptee) {
            this.adaptee = adaptee;
        }

        public void itemStateChanged(ItemEvent e) {
            this.adaptee.rolePanelItemStateChanged(e);
        }
    }
}

