/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEActivityDiagramSelectionListener;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEComboIncr;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PEActivityDiagram
extends PropertyEditor {
    PETextField diagramName;
    PEComboIncr classesCombo;
    PEListIncr methodsList;
    PECheck storyboard;
    private boolean result = true;

    public PEActivityDiagram(JFrame frame, String title, boolean modal) {
        super(frame);
        try {
            this.pack();
            this.setTitle("Activity Diagram Editor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initPE();
    }

    public PEActivityDiagram(JFrame frame) {
        this(frame, "", false);
    }

    public PEActivityDiagram(JFrame frame, boolean modal) {
        this(frame, "", modal);
    }

    public PEActivityDiagram(JFrame frame, String title) {
        this(frame, title, false);
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.diagramName = new PETextField(this, "Diagram Name");
        this.classesCombo = new PEComboIncr(this, "Class List");
        this.methodsList = new PEListIncr(this, "Method List");
        this.storyboard = new PECheck(this, null, "Storyboard");
        this.diagramName.setText(this.getPropertyName());
        this.classesCombo.setStatus("Select the class");
        this.classesCombo.addItemListener(new PEActivityDiagramSelectionListener(this));
        this.methodsList.setStatus("Select the associated method");
        PEColumn column = new PEColumn(this);
        column.add(this.diagramName);
        column.add(this.storyboard);
        column.add(this.classesCombo);
        column.add(this.methodsList);
        panel.add(column);
    }

    public boolean isResult() {
        return this.result;
    }

    protected void unparse() {
        Enumeration classes;
        UMLProject proj;
        ASGElement asgElement = this.getIncrement();
        if (asgElement instanceof ViewDiagram) {
            asgElement = ((ViewDiagram)asgElement).getOriginalDiagram();
        }
        if (asgElement instanceof UMLActivityDiagram && (proj = UMLProject.get()) != null && (classes = proj.elementsOfClasses()) != null) {
            ASGElement classIncr = null;
            while (classes.hasMoreElements()) {
                classIncr = (ASGElement)classes.nextElement();
                this.classesCombo.add(classIncr);
            }
        }
    }

    protected void parse() {
        ASGElement asgElement = this.getIncrement();
        if (asgElement instanceof UMLActivityDiagram || asgElement instanceof ViewDiagram && ((ViewDiagram)asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            UMLDiagram activityDiagram = (UMLDiagram)asgElement;
            activityDiagram.setName(this.diagramName.getText());
            ((UMLActivityDiagram)activityDiagram).setIsStoryBoard(this.storyboard.isSelected());
            if (this.storyboard.isSelected()) {
                UMLStartActivity activity = new UMLStartActivity(null);
                activity.setStoryName("Storyboard::" + this.diagramName.getText());
                activityDiagram.addToElements(activity);
            } else if (this.methodsList.getSelectedIncrement() != null) {
                UMLMethod selectedMethod = (UMLMethod)this.methodsList.getSelectedIncrement();
                if (selectedMethod.getRevSpec() != null) {
                    int result = JOptionPane.showConfirmDialog(this.getFrame(), "The selected method is associated to a start activity.", "Confirm method", 0);
                    if (result == 0) {
                        UMLStartActivity start = new UMLStartActivity(selectedMethod);
                        activityDiagram.addToElements(start);
                        this.result = true;
                    } else {
                        activityDiagram.removeYou();
                        this.result = false;
                    }
                } else {
                    activityDiagram.addToElements(new UMLStartActivity(selectedMethod));
                }
            }
        }
    }

    protected void cancel() {
        this.result = false;
    }

    protected String getPropertyName() {
        return "Activity Diagram";
    }

    public void selectionChanged() {
        UMLClass selectedClass = (UMLClass)this.classesCombo.getSelectedIncrement();
        if (selectedClass != null) {
            this.methodsList.removeAll();
            Iterator methodIter = selectedClass.iteratorOfMethods();
            UMLMethod method = null;
            while (methodIter.hasNext()) {
                method = (UMLMethod)methodIter.next();
                this.methodsList.add(method);
            }
        }
    }
}

