/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PEComponentGroup;
import de.uni_paderborn.fujaba.gui.PEComponentLayout;
import de.uni_paderborn.fujaba.gui.PEResizable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;

public abstract class PEBaseComponent
extends JPanel
implements PEResizable {
    private String componentName = null;
    private String status = null;
    private Insets inset = null;
    protected BasicPropertyEditor parent = null;

    public PEBaseComponent(BasicPropertyEditor editor) {
        this.setParent(editor);
        this.setLayout(this.getLayoutManager());
        this.addComponents();
    }

    public PEBaseComponent(BasicPropertyEditor editor, String name) {
        this(editor);
        this.setComponentName(name);
    }

    public Insets getInsets() {
        if (this.inset == null) {
            return super.getInsets();
        }
        return this.inset;
    }

    public void setInsets(Insets newInset) {
        this.inset = newInset;
    }

    public void setComponentName(String name) {
        this.componentName = name;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public PEBaseComponent getComponentByName(String searchName) {
        int nmembers = this.getComponentCount();
        Component comp = null;
        PEBaseComponent basecomp = null;
        int i = 0;
        while (i < nmembers) {
            comp = this.getComponent(i);
            if (comp instanceof PEBaseComponent) {
                PEBaseComponent c;
                basecomp = (PEBaseComponent)comp;
                if (basecomp.getComponentName() != null && basecomp.getComponentName().equals(searchName)) {
                    return basecomp;
                }
                if (basecomp instanceof PEComponentGroup && (c = basecomp.getComponentByName(searchName)) != null) {
                    return c;
                }
            }
            ++i;
        }
        return null;
    }

    public PEBaseComponent() {
    }

    protected void setParent(BasicPropertyEditor parent) {
        this.parent = parent;
    }

    protected LayoutManager getLayoutManager() {
        return new PEComponentLayout();
    }

    protected abstract void addComponents();

    public abstract void setReadOnly(boolean var1);

    public void focusGained() {
        this.parent.setStatus(this.getStatus());
    }

    public void focusLost() {
        this.parent.setStatus("");
    }

    public void setStatus(String status) {
        this.status = status;
    }

    protected String getStatus() {
        if (this.status == null) {
            return "";
        }
        return this.status;
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        return PEButton.remainedUnbound;
    }
}

