/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEItem;
import de.uni_paderborn.fujaba.gui.PEListSelectionListener;
import de.uni_paderborn.fujaba.gui.PEStringListModel;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FLinkedList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JList;

public class PEListbox
extends JList {
    private FLinkedList itemList = new FLinkedList();
    private PEStringListModel slm = (PEStringListModel)this.getModel();

    PEListbox() {
        super(new PEStringListModel());
        this.addListSelectionListener(new PEListSelectionListener(this));
    }

    public void add(PEItem item) {
        this.itemList.add(item);
        this.slm.add(item.getText());
    }

    public void add(ASGElement incr) {
        PEItem item = new PEItem(incr);
        this.add(item);
    }

    public void add(String s) {
        this.itemList.add((Object)null);
        this.slm.add(s);
    }

    public void remove(ASGElement incr) {
        int i = 0;
        int index = -1;
        Iterator items = this.itemList.iterator();
        PEItem item = null;
        while (items.hasNext() && index < 0) {
            item = (PEItem)items.next();
            if (item.getIncrement() == incr) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            this.itemList.remove(index);
            this.slm.remove(index);
        }
    }

    public void removeAll() {
        this.slm.clear();
        this.itemList.clear();
    }

    public PEItem getItemByIndex(int index) {
        PEItem item = null;
        Iterator list = this.itemList.iterator();
        int i = 0;
        while (list.hasNext() && i <= index) {
            item = (PEItem)list.next();
            ++i;
        }
        if (i == index + 1) {
            return item;
        }
        return null;
    }

    public int getIncrementIndex(ASGElement incr) {
        PEItem item = null;
        Iterator list = this.itemList.iterator();
        int i = 0;
        while (list.hasNext()) {
            item = (PEItem)list.next();
            if (item != null && item.getIncrement() == incr) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ASGElement getSelectedIncrement() {
        PEItem item;
        int index = this.getSelectedIndex();
        if (index >= 0 && (item = this.getItemByIndex(index)) != null) {
            return item.getIncrement();
        }
        return null;
    }

    public Enumeration elements() {
        return new EnumerationForAnIterator(this.iterator());
    }

    public Iterator iterator() {
        return this.itemList.iterator();
    }

    public int[] getSelectedElements() {
        return this.getSelectedIndices();
    }

    public boolean isIncrementSelected(ASGElement incr) {
        int i = 0;
        Iterator incrs = this.itemList.iterator();
        while (incrs.hasNext() && ((PEItem)incrs.next()).getIncrement() != incr) {
            ++i;
        }
        return this.isSelectedIndex(i);
    }

    public void selectIncrement(ASGElement incr) {
        int i = this.getIncrementIndex(incr);
        if (i >= 0) {
            this.setSelectedIndex(i);
        }
    }

    public ASGElement getIncrementByName(String name) {
        Iterator items = this.itemList.iterator();
        PEItem item = null;
        while (items.hasNext()) {
            item = (PEItem)items.next();
            if (!item.getText().equals(name)) continue;
            return item.getIncrement();
        }
        return null;
    }

    public void selectionChanged() {
    }
}

