/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PEMethod;
import de.uni_paderborn.fujaba.gui.PETypeSelection;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import java.awt.event.ActionEvent;
import java.util.Iterator;

class PEMethodSelection
extends PETypeSelection {
    private PEButton parameter;
    private PEButton throwsButton;
    private PEMethod parent;
    private PEMethod methodEditor;

    PEMethodSelection(PEMethod parent) {
        super(parent, "Void");
        this.getDest().setHeader("Methods");
        this.parent = parent;
        this.parameter = new PEButton(this, "parameter");
        this.throwsButton = new PEButton(this, "throws...");
        this.getButtonColumn().add(this.parameter);
        this.getButtonColumn().add(this.throwsButton);
        this.methodEditor = parent;
    }

    protected void destSelectionChanged() {
        ASGElement umlIncr = this.destination.getSelectedIncrement();
        if (umlIncr instanceof UMLMethod) {
            UMLMethod umlMethod = (UMLMethod)umlIncr;
            this.methodEditor.setPropertyName(umlMethod.getName());
            this.methodEditor.setSignalModifier(umlMethod.isSignal());
            this.methodEditor.setFinalModifier(umlMethod.isFinal());
            this.methodEditor.setStaticModifier(umlMethod.isStatic());
            this.methodEditor.setVisibilityChoice(umlMethod.getVisibility());
            this.methodEditor.setAbstractModifier(umlMethod.isAbstract());
            this.methodEditor.setSynchronizedModifier(umlMethod.isSynchronized());
            this.methodEditor.setNativeModifier(umlMethod.isUmlNative());
            this.methodEditor.setResultTypeIsPointer(umlMethod.isResultTypeIsPointer());
            this.source.selectIncrement((UMLIncrement)((Object)umlMethod.getResultType()));
        }
    }

    public void fillDestList() {
        this.clearDest();
        ASGElement incr = this.getIncrement();
        if (incr instanceof UMLClass) {
            Iterator methodIter = ((UMLClass)incr).iteratorOfMethods();
            while (methodIter.hasNext()) {
                UMLMethod umlMethod = (UMLMethod)methodIter.next();
                if (umlMethod == null) continue;
                this.addToDest(umlMethod);
            }
        }
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        if (buttonIdentifier.equals(this.parameter.getIdentifier())) {
            this.parent.parametersButton_actionPerformed(e);
            return PEButton.caughtEvent;
        }
        if (buttonIdentifier.equals(this.throwsButton.getIdentifier())) {
            this.parent.throwsButton_actionPerformed(e);
            return PEButton.caughtEvent;
        }
        return this.parent.buttonActionPerformed(buttonIdentifier, e);
    }
}

