/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PERow;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.utility.MultiLinkGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class PEMultiLink
extends BasicPropertyEditor {
    private ASGElement secondIncrement;
    private JTextField sourceLabel;
    private JTextField targetLabel;
    private PEButton swapButton;
    private JComboBox containerComboBox;
    JTextField indexTextField;
    private JRadioButton firstRadioButton;
    private JRadioButton lastRadioButton;
    private JRadioButton directRadioButton;
    private JRadioButton indirectRadioButton;
    JRadioButton indexRadioButton;
    private JCheckBox negativeCheckBox;
    private static String IDSwap = "Swap";

    public PEMultiLink(JFrame frame) {
        super(frame);
        this.setTitle("MultiLink Editor");
        this.initPE();
    }

    protected void additionalProperties(PEEditPanel panel) {
        PEColumn column = new PEColumn(this);
        PERow linknTypeRow = new PERow(this);
        PEColumn linkColumn = new PEColumn(this);
        linkColumn.setBorder(new TitledBorder("MultiLink"));
        linkColumn.setLayout(new BorderLayout());
        PERow linkRow = new PERow(this);
        JLabel fromLabel = new JLabel("From ");
        this.sourceLabel = new JTextField(15);
        this.sourceLabel.setEditable(false);
        JLabel toLabel = new JLabel(" to ");
        this.targetLabel = new JTextField(15);
        this.targetLabel.setEditable(false);
        JPanel swapButtonPanel = new JPanel();
        swapButtonPanel.setLayout(new FlowLayout(1));
        this.swapButton = new PEButton(this, IDSwap);
        this.swapButton.setEnabled(false);
        swapButtonPanel.add(this.swapButton);
        linkRow.add(fromLabel);
        linkRow.add(this.sourceLabel);
        linkRow.add(toLabel);
        linkRow.add(this.targetLabel);
        linkColumn.add((Component)linkRow, "Center");
        linkColumn.add((Component)swapButtonPanel, "South");
        linknTypeRow.add(linkColumn);
        PERow containerGollum = new PERow(this);
        containerGollum.setBorder(new TitledBorder("Container Object"));
        this.containerComboBox = new JComboBox();
        this.containerComboBox.setRenderer(new MyCellRenderer());
        containerGollum.add(this.containerComboBox);
        linknTypeRow.add(containerGollum);
        column.add(linknTypeRow);
        PERow typeConstraintRow = new PERow(this);
        PERow typeColumn = new PERow(this);
        typeColumn.setBorder(new TitledBorder("Type"));
        ButtonGroup typeButtonGroup = new ButtonGroup();
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        this.firstRadioButton = new JRadioButton("First");
        this.firstRadioButton.addActionListener(radioButtonListener);
        typeButtonGroup.add(this.firstRadioButton);
        typeColumn.add(this.firstRadioButton);
        this.lastRadioButton = new JRadioButton("Last");
        this.lastRadioButton.addActionListener(radioButtonListener);
        typeButtonGroup.add(this.lastRadioButton);
        typeColumn.add(this.lastRadioButton);
        this.directRadioButton = new JRadioButton("Direct");
        this.directRadioButton.addActionListener(radioButtonListener);
        typeButtonGroup.add(this.directRadioButton);
        typeColumn.add(this.directRadioButton);
        this.indirectRadioButton = new JRadioButton("Indirect");
        this.indirectRadioButton.addActionListener(radioButtonListener);
        typeButtonGroup.add(this.indirectRadioButton);
        typeColumn.add(this.indirectRadioButton);
        PERow indexRow = new PERow(this);
        this.indexRadioButton = new JRadioButton("Index");
        this.indexRadioButton.addActionListener(radioButtonListener);
        typeButtonGroup.add(this.indexRadioButton);
        indexRow.add(this.indexRadioButton);
        this.indexTextField = new JTextField(5);
        indexRow.add(this.indexTextField);
        typeColumn.add(indexRow);
        typeConstraintRow.add(typeColumn);
        PERow constraintRow = new PERow(this);
        constraintRow.setBorder(new TitledBorder("Constraint"));
        this.negativeCheckBox = new JCheckBox("Negative");
        constraintRow.add(this.negativeCheckBox);
        typeConstraintRow.add(constraintRow);
        column.add(typeConstraintRow);
        panel.add(column);
    }

    public void setIncrement(ASGElement asgElement, ASGElement secondAsgElement) {
        this.secondIncrement = secondAsgElement;
        super.setIncrement(asgElement);
    }

    protected void parse() {
        UMLObject containerObject;
        ASGElement umlIncrement = this.getIncrement();
        MultiLinkGenerator multiLinkGen = new MultiLinkGenerator();
        int type = -1;
        if (this.firstRadioButton.isSelected()) {
            type = 0;
        } else if (this.lastRadioButton.isSelected()) {
            type = 1;
        } else if (this.directRadioButton.isSelected()) {
            type = 2;
        } else if (this.indirectRadioButton.isSelected()) {
            type = 4;
        } else if (this.indexRadioButton.isSelected()) {
            type = 3;
        } else {
            JOptionPane.showMessageDialog(this.getFrame(), "No MultiLink type selected.", "Edit MultiLink", 0);
            return;
        }
        int index = 0;
        if (this.indexTextField.isEnabled() && this.indexTextField.isEditable()) {
            try {
                index = Integer.parseInt(this.indexTextField.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this.getFrame(), "Invalid index. Index must be an integer value", "Edit MultiLink", 0);
                return;
            }
        }
        if ((containerObject = (UMLObject)this.containerComboBox.getSelectedItem()) == null) {
            JOptionPane.showMessageDialog(this.getFrame(), "Container Object is null!", "Edit MultiLink", 0);
        }
        multiLinkGen.generateMultiLink(type, index, this.negativeCheckBox.isSelected(), containerObject, umlIncrement, this.secondIncrement);
        UMLProject.get().refreshDisplay();
    }

    protected void unparse() {
        ASGElement umlIncrement = this.getIncrement();
        if (umlIncrement instanceof UMLMultiLink) {
            UMLMultiLink multiLink = (UMLMultiLink)umlIncrement;
            UMLObject sourceObj = multiLink.getSourceObject();
            UMLObject targetObj = multiLink.getTargetObject();
            if (sourceObj != null) {
                this.sourceLabel.setText(sourceObj.getObjectName());
            } else {
                this.sourceLabel.setText("undefined_value");
            }
            if (targetObj != null) {
                this.targetLabel.setText(targetObj.getObjectName());
            } else {
                this.targetLabel.setText("undefined_value");
            }
            int type = multiLink.getType();
            if (type == 0) {
                this.firstRadioButton.setSelected(true);
                this.indexTextField.setEditable(false);
                this.firstRadioButton.setEnabled(true);
                this.lastRadioButton.setEnabled(true);
                this.indexRadioButton.setEnabled(false);
                this.directRadioButton.setEnabled(false);
                this.indirectRadioButton.setEnabled(false);
            } else if (type == 1) {
                this.lastRadioButton.setSelected(true);
                this.indexTextField.setEditable(false);
                this.firstRadioButton.setEnabled(true);
                this.lastRadioButton.setEnabled(true);
                this.indexRadioButton.setEnabled(false);
                this.directRadioButton.setEnabled(false);
                this.indirectRadioButton.setEnabled(false);
            } else if (type == 2) {
                this.directRadioButton.setSelected(true);
                this.indexTextField.setEditable(false);
                this.firstRadioButton.setEnabled(false);
                this.lastRadioButton.setEnabled(false);
                this.indexRadioButton.setEnabled(true);
                this.directRadioButton.setEnabled(true);
                this.indirectRadioButton.setEnabled(true);
            } else if (type == 4) {
                this.indirectRadioButton.setSelected(true);
                this.indexTextField.setEditable(false);
                this.firstRadioButton.setEnabled(false);
                this.lastRadioButton.setEnabled(false);
                this.indexRadioButton.setEnabled(true);
                this.directRadioButton.setEnabled(true);
                this.indirectRadioButton.setEnabled(true);
            } else if (type == 3) {
                this.indexRadioButton.setSelected(true);
                this.indexTextField.setEditable(true);
                this.indexTextField.setText(String.valueOf(multiLink.getIndex()));
                this.firstRadioButton.setEnabled(false);
                this.lastRadioButton.setEnabled(false);
                this.indexRadioButton.setEnabled(true);
                this.directRadioButton.setEnabled(true);
                this.indirectRadioButton.setEnabled(true);
            }
            UMLLink link = multiLink.getSourceLink() != null ? multiLink.getSourceLink() : multiLink.getTargetLink();
            int leftCard = link.getInstanceOf().getLeftRole().getCard().getUpperBound();
            int rightCard = link.getInstanceOf().getRightRole().getCard().getUpperBound();
            if (rightCard > 1) {
                this.containerComboBox.addItem(link.getSource());
            }
            if (leftCard > 1) {
                this.containerComboBox.addItem(link.getTarget());
            }
            this.containerComboBox.setSelectedItem(multiLink.getContainerObject());
            if (multiLink.isNegative()) {
                this.negativeCheckBox.setSelected(true);
            }
            this.setTitle("Edit MultiLink");
        } else if (umlIncrement instanceof UMLLink && this.secondIncrement != null && this.secondIncrement instanceof UMLLink && umlIncrement != this.secondIncrement) {
            UMLObject targetObject;
            UMLObject sourceObject;
            UMLLink sourceLink = (UMLLink)umlIncrement;
            UMLLink targetLink = (UMLLink)this.secondIncrement;
            UMLObject sourceObjTarget = sourceLink.getTarget();
            UMLObject targetObjTarget = targetLink.getTarget();
            if (sourceObjTarget != null) {
                this.sourceLabel.setText(sourceObjTarget.getObjectName());
            } else {
                this.sourceLabel.setText("undefined_value");
            }
            if (targetObjTarget != null) {
                this.targetLabel.setText(targetObjTarget.getObjectName());
            } else {
                this.targetLabel.setText("undefined_value");
            }
            if (sourceObjTarget != null && targetObjTarget != null) {
                this.swapButton.setEnabled(true);
            }
            if ((sourceObject = sourceLink.getSource()) == (targetObject = targetLink.getSource())) {
                this.containerComboBox.addItem(sourceObject);
            } else {
                sourceObject = sourceLink.getTarget();
                if (sourceObject == targetObject) {
                    this.containerComboBox.addItem(sourceObject);
                } else {
                    this.containerComboBox.addItem(targetLink.getTarget());
                }
            }
            this.containerComboBox.setSelectedIndex(0);
            this.firstRadioButton.setEnabled(false);
            this.lastRadioButton.setEnabled(false);
            this.indexRadioButton.setEnabled(true);
            this.directRadioButton.setEnabled(true);
            this.indirectRadioButton.setEnabled(true);
            this.indexTextField.setEditable(false);
            this.setTitle("New MultiLink");
        } else if (umlIncrement instanceof UMLLink) {
            UMLMultiLink multiLink;
            UMLLink link = (UMLLink)umlIncrement;
            this.sourceLabel.setText("");
            UMLObject linkTarget = link.getTarget();
            if (linkTarget != null) {
                this.targetLabel.setText(linkTarget.getObjectName());
            }
            int leftCard = link.getInstanceOf().getLeftRole().getCard().getUpperBound();
            int rightCard = link.getInstanceOf().getRightRole().getCard().getUpperBound();
            if (rightCard > 1) {
                this.containerComboBox.addItem(link.getSource());
                this.containerComboBox.setSelectedIndex(0);
            }
            if (leftCard > 1) {
                this.containerComboBox.addItem(link.getTarget());
                this.containerComboBox.setSelectedIndex(0);
            }
            this.firstRadioButton.setEnabled(true);
            this.lastRadioButton.setEnabled(true);
            this.indexRadioButton.setEnabled(false);
            this.directRadioButton.setEnabled(false);
            this.indirectRadioButton.setEnabled(false);
            this.indexTextField.setEditable(false);
            if (link.getRevTargetLink() != null) {
                UMLMultiLink multiLink2 = link.getRevTargetLink();
                if (multiLink2.getType() == 0) {
                    this.firstRadioButton.setSelected(true);
                }
            } else if (link.getRevSourceLink() != null && (multiLink = link.getRevSourceLink()).getType() == 1) {
                this.lastRadioButton.setSelected(true);
            }
            this.setTitle("New MultiLink");
        }
    }

    protected boolean checkConstraints() {
        int index = -1;
        int type = -1;
        boolean result = true;
        ASGElement umlIncrement = this.getIncrement();
        if (this.firstRadioButton.isSelected()) {
            type = 0;
        } else if (this.lastRadioButton.isSelected()) {
            type = 1;
        } else if (this.directRadioButton.isSelected()) {
            type = 2;
        } else if (this.indirectRadioButton.isSelected()) {
            type = 4;
        } else if (this.indexRadioButton.isSelected()) {
            type = 3;
        } else {
            JOptionPane.showMessageDialog(this, "Please specify the type of the multilink.", "No multilink type", 0);
            result = false;
            return result;
        }
        if (umlIncrement instanceof UMLLink && this.secondIncrement != null && this.secondIncrement instanceof UMLLink) {
            UMLLink sourceLink = (UMLLink)umlIncrement;
            UMLLink targetLink = (UMLLink)this.secondIncrement;
            if (!sourceLink.getInstanceOf().equals(targetLink.getInstanceOf())) {
                JOptionPane.showMessageDialog(this, "Please select two links of the same association, press cancel to leave the dialog!", "Link mismatch", 0);
                result = false;
            }
        } else if (type == 0) {
            UMLLink link = (UMLLink)umlIncrement;
            UMLObject object = !link.getTarget().equals(this.containerComboBox.getSelectedItem()) ? link.getTarget() : link.getSource();
            if (object.getType() == 3) {
                result = false;
                JOptionPane.showMessageDialog(this, "First-MultiLink can only points to a normal object, press cancel to leave the dialog!", "Object is set", 0);
            }
        } else if (type == 1) {
            UMLLink link = (UMLLink)umlIncrement;
            UMLObject object = !link.getTarget().equals(this.containerComboBox.getSelectedItem()) ? link.getTarget() : link.getSource();
            if (object.getType() == 3) {
                result = false;
                JOptionPane.showMessageDialog(this, "Last-MultiLink can only points to a normal object, press cancel to leave the dialog!", "Object is set", 0);
            }
        } else if (type == 3) {
            try {
                index = Integer.parseInt(this.indexTextField.getText());
            }
            catch (Exception e) {
                result = false;
                JOptionPane.showMessageDialog(this, "Please enter only integer values in the index field.", "Index is not integer", 0);
            }
            if (result) {
                if (index >= 1) {
                    result = true;
                } else {
                    result = false;
                    JOptionPane.showMessageDialog(this, "Please enter an index >= 1", "Invalid index", 0);
                }
            }
        }
        return result;
    }

    protected void cancel() {
    }

    public void buttonOK_actionPerformed(ActionEvent e) {
        if (this.checkConstraints()) {
            super.buttonOK_actionPerformed(e);
        }
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        if (buttonIdentifier.equals(IDSwap) && this.secondIncrement != null) {
            this.setIncrement(this.secondIncrement, this.getIncrement());
            this.containerComboBox.removeAllItems();
            this.unparse();
        }
        return PEButton.remainedUnbound;
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof UMLObject) {
                UMLObject obj = (UMLObject)value;
                this.setText(" " + obj.getObjectName() + ": " + obj.getInstanceOf() + " ");
            } else {
                this.setText("unknown_value");
            }
            return this;
        }
    }

    private class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PEMultiLink.this.indexRadioButton.isSelected()) {
                PEMultiLink.this.indexTextField.setEditable(true);
            } else {
                PEMultiLink.this.indexTextField.setEditable(false);
            }
        }
    }
}

