/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.CMAFocusListener;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PEListbox;
import de.uni_paderborn.fujaba.gui.PEParameterSelection;
import de.uni_paderborn.fujaba.gui.PEParameter_addButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEParameter_modifyButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEParameter_removeButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.upb.tools.fca.FLinkedList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PEParameters
extends PropertyEditor {
    private static final transient Logger log;
    private FLinkedList addParameters = new FLinkedList();
    private FLinkedList delParameters = new FLinkedList();
    private FLinkedList modParameters = new FLinkedList();
    private FLinkedList refClasses = new FLinkedList();
    PETextField propertyName;
    PEParameterSelection selection;
    private PEListIncr methodTypeList;
    private ASGElement second = null;
    private PECheck pointer = null;
    private PECheck callByReference = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.PEParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PEParameters(JFrame frame, String title, boolean modal) {
        super(frame);
        try {
            this.pack();
            this.setTitle("Parameters Editor: ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initPE();
        this.addFocusListener(new CMAFocusListener(this.propertyName));
        this.propertyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PEParameters.this.addButton_actionPerformed(e);
            }
        });
    }

    public PEParameters(JFrame frame) {
        this(frame, "", false);
    }

    public PEParameters(JFrame frame, boolean modal, PEListIncr methodTypeList) {
        this(frame, "", modal);
    }

    public PEParameters(JFrame frame, String title, PEListIncr methodTypeList) {
        this(frame, title, false);
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.propertyName = new PETextField(this, "Parameter Name");
        this.selection = new PEParameterSelection(this);
        this.propertyName.setText(this.getPropertyName());
        this.propertyName.setStatus("Enter the name of the parameter");
        this.pointer = new PECheck(this, "Pointer", "pointer of type");
        this.pointer.setSelected(this.isPointer());
        this.callByReference = new PECheck(this, "Call", "call by reference");
        this.callByReference.setSelected(this.isCallByReference());
        this.selection.setAddListener(new PEParameter_addButton_actionAdapter(this));
        this.selection.setRemoveListener(new PEParameter_removeButton_actionAdapter(this));
        this.selection.setModifyListener(new PEParameter_modifyButton_actionAdapter(this));
        this.selection.setSourceMouseListener(new SourceMouseListener(this.selection.getSource().getList()));
        this.selection.setDestMouseListener(new DestMouseListener(this.selection.getSource().getList()));
        PEColumn column = new PEColumn(this);
        column.add(this.propertyName);
        column.add(this.pointer);
        column.add(this.callByReference);
        column.add(this.selection);
        panel.add(column);
    }

    public void setIncrement(ASGElement incr, ASGElement second) {
        super.setIncrement(incr);
        this.second = second;
        if (incr instanceof UMLMethod) {
            this.propertyName.setReadOnly(this.isReadOnly());
            this.setTitle("Editor: " + ((UMLMethod)incr).getName());
        }
    }

    public void setPropertyName(String name) {
        this.propertyName.setText(name);
    }

    public void setPointer(boolean isPointer) {
        this.pointer.setSelected(isPointer);
    }

    public void setCallByReference(boolean isCallByReference) {
        this.callByReference.setSelected(isCallByReference);
    }

    public void setParamType(UMLIncrement umlIncr) {
        this.methodTypeList.selectIncrement(umlIncr);
    }

    public void setTypeList(Enumeration typelist) {
        this.selection.setTypeList(typelist);
    }

    protected void unparse() {
        this.propertyName.setText(this.getPropertyName());
        this.pointer.setSelected(this.isPointer());
        this.callByReference.setSelected(this.isCallByReference());
        this.propertyName.selectAll();
        this.selection.setIncrement(this.getIncrement());
    }

    protected void parse() {
        if (!this.isReadOnly()) {
            UMLParam parameter = null;
            ASGElement incr = this.getIncrement();
            if (incr instanceof UMLMethod) {
                Iterator iter = this.addParameters.iterator();
                while (iter.hasNext()) {
                    parameter = (UMLParam)iter.next();
                    ((UMLMethod)incr).addToParam(parameter);
                }
                this.addParameters.clear();
                iter = this.modParameters.iterator();
                while (iter.hasNext()) {
                    parameter = (UMLParam)iter.next();
                    ((UMLMethod)incr).addToParam(parameter);
                }
                this.modParameters.clear();
                iter = this.delParameters.iterator();
                while (iter.hasNext()) {
                    parameter = (UMLParam)iter.next();
                    ((UMLMethod)incr).removeFromParam(parameter);
                    parameter.removeYou();
                }
                this.delParameters.clear();
                iter = this.refClasses.iterator();
                UMLClass refClass = null;
                while (iter.hasNext()) {
                    Iterator diags;
                    refClass = (UMLClass)iter.next();
                    if (this.second == null || !(this.second instanceof UMLClass) || (diags = ((UMLClass)this.second).iteratorOfDiagrams()) == null) continue;
                    UMLDiagram diag = null;
                    while (diags.hasNext()) {
                        diag = (UMLDiagram)diags.next();
                        diag.addToElements(refClass);
                    }
                }
                this.refClasses.clear();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Editor in ReadOnly mode.");
        }
    }

    protected void cancel() {
        this.addParameters.clear();
        this.delParameters.clear();
        this.modParameters.clear();
        this.refClasses.clear();
        this.setVisible(false);
        this.dispose();
    }

    protected String getPropertyName() {
        ASGElement incr = this.getIncrement();
        if (incr != null && incr instanceof UMLMethod) {
            return "p" + String.valueOf(((UMLMethod)incr).sizeOfParam() + 1);
        }
        return "New Parameter";
    }

    protected boolean isPointer() {
        return false;
    }

    protected boolean isCallByReference() {
        return false;
    }

    void addButton_actionPerformed(ActionEvent e) {
        if (this.selection.getTypeName().length() > 0 && this.propertyName.getText().length() > 0) {
            UMLParam newParam = new UMLParam();
            newParam.setName(this.propertyName.getText());
            newParam.setPointer(this.pointer.isSelected());
            newParam.setCallByReference(this.callByReference.isSelected());
            ASGElement incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
            if (incr == null) {
                UMLTypeList typelist = null;
                if (this.getIncrement() instanceof UMLClass) {
                    typelist = ((UMLClass)this.getIncrement()).getRevTypes();
                }
                UMLClass refClass = new UMLClass(this.selection.getTypeName(), UMLStereotypeManager.get().getFromStereotypes("reference"), typelist, null);
                newParam.setParamType(refClass);
                this.refClasses.add(refClass);
            } else {
                newParam.setParamType((UMLType)((Object)incr));
            }
            this.addParameters.add(newParam);
            this.selection.addToDest(newParam);
            this.setPropertyName("");
            this.propertyName.requestFocus();
        }
    }

    void removeButton_actionPerformed(ActionEvent e) {
        ASGElement incr = this.selection.getDestSelectedIncr();
        if (incr != null) {
            this.delParameters.add(incr);
            this.selection.removeFromDest(incr);
        }
    }

    void modifyButton_actionPerformed(ActionEvent e) {
        ASGElement oldIncr = this.selection.getDestSelectedIncr();
        if (oldIncr != null) {
            this.delParameters.add(oldIncr);
            this.selection.removeFromDest(oldIncr);
            if (this.selection.getTypeName().length() > 0 && this.propertyName.getText().length() > 0) {
                UMLParam newParam = new UMLParam();
                newParam.setName(this.propertyName.getText());
                newParam.setPointer(this.pointer.isSelected());
                newParam.setCallByReference(this.callByReference.isSelected());
                ASGElement incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
                if (incr == null) {
                    UMLTypeList typelist = null;
                    if (this.getIncrement() instanceof UMLClass) {
                        typelist = ((UMLClass)this.getIncrement()).getRevTypes();
                    }
                    UMLClass refClass = new UMLClass(this.selection.getTypeName(), UMLStereotypeManager.get().getFromStereotypes("reference"), typelist, null);
                    newParam.setParamType(refClass);
                    this.refClasses.add(refClass);
                } else {
                    newParam.setParamType((UMLType)((Object)incr));
                }
                this.modParameters.add(newParam);
                this.selection.addToDest(newParam);
            }
        }
    }

    private class SourceMouseListener
    implements MouseListener {
        PEListbox liste;

        SourceMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ASGElement oldIncr = PEParameters.this.selection.getDestSelectedIncr();
                if (oldIncr != null && oldIncr instanceof UMLParam) {
                    UMLParam curParam = (UMLParam)oldIncr;
                    if (PEParameters.this.propertyName.getText().equals(curParam.getName())) {
                        PEParameters.this.modifyButton_actionPerformed(null);
                    } else {
                        PEParameters.this.addButton_actionPerformed(null);
                    }
                } else {
                    PEParameters.this.addButton_actionPerformed(null);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DestMouseListener
    implements MouseListener {
        PEListbox liste;

        DestMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isRightMouseButton(e)) {
                PEParameters.this.removeButton_actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

