/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.PEBaseComponent;
import de.uni_paderborn.fujaba.gui.PEListEntry;
import de.uni_paderborn.fujaba.gui.SwapButtonActionAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class PERolePanel
extends PEBaseComponent {
    private JComboBox leftCombo;
    private JComboBox rightCombo;
    private JButton swapButton = new JButton("Swap");
    private int gapHorz = 10;
    private int gapVert = 20;
    private int gapLine = 40;

    public PERolePanel() {
        this.swapButton.addActionListener(new SwapButtonActionAdapter(this));
        this.add(this.swapButton);
        this.leftCombo = new JComboBox();
        this.leftCombo.setEditable(false);
        this.leftCombo.setMaximumRowCount(5);
        this.add(this.leftCombo);
        this.rightCombo = new JComboBox();
        this.rightCombo.setEditable(false);
        this.rightCombo.setMaximumRowCount(5);
        this.add(this.rightCombo);
        this.setInsets(new Insets(1, 1, 10, 1));
    }

    public int getGapHorz() {
        return this.gapHorz;
    }

    public void setGapHorz(int newGapHorz) {
        if (newGapHorz > 0 && newGapHorz != this.gapHorz) {
            this.gapHorz = newGapHorz;
        }
    }

    public int getGapVert() {
        return this.gapVert;
    }

    public void setGapVert(int newGapVert) {
        if (newGapVert > 0 && newGapVert != this.gapVert) {
            this.gapVert = newGapVert;
        }
    }

    public int getGapLine() {
        return this.gapLine;
    }

    public void setGapLine(int newGapLine) {
        if (newGapLine > 0 && newGapLine != this.gapLine) {
            this.gapLine = newGapLine;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(0, 0);
        Dimension leftSize = this.leftCombo.getPreferredSize();
        Dimension rightSize = this.rightCombo.getPreferredSize();
        Dimension buttonSize = this.swapButton.getPreferredSize();
        dim.width = leftSize.width + rightSize.width + 4 * this.getGapHorz();
        dim.height = Math.max(leftSize.height, rightSize.height) + 2 * this.getGapVert();
        dim.width = dim.width + buttonSize.width + 2 * this.getGapLine();
        dim.height = Math.max(dim.height, 2 * buttonSize.height);
        Insets inset = this.getInsets();
        dim.width = dim.width + inset.left + inset.right;
        dim.height = dim.height + inset.top + inset.bottom;
        return dim;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addItemToLeftComboBox(PEListEntry item) {
        this.leftCombo.addItem(item);
    }

    public void addItemToRightComboBox(PEListEntry item) {
        this.rightCombo.addItem(item);
    }

    public PEListEntry getLeftComboSelectedItem() {
        return (PEListEntry)this.leftCombo.getSelectedItem();
    }

    public void setLeftComboSelectedItem(PEListEntry item) {
        this.leftCombo.setSelectedItem(item);
    }

    public PEListEntry getRightComboSelectedItem() {
        return (PEListEntry)this.rightCombo.getSelectedItem();
    }

    public void setRightComboSelectedItem(PEListEntry item) {
        this.rightCombo.setSelectedItem(item);
    }

    public void swapEntries() {
        Object oldLeftEntry = this.leftCombo.getSelectedItem();
        Object oldRightEntry = this.rightCombo.getSelectedItem();
        this.leftCombo.setSelectedItem(oldRightEntry);
        this.rightCombo.setSelectedItem(oldLeftEntry);
        if (this.leftCombo.getSelectedItem() != oldRightEntry || this.rightCombo.getSelectedItem() != oldLeftEntry) {
            this.leftCombo.setSelectedItem(oldLeftEntry);
            this.rightCombo.setSelectedItem(oldRightEntry);
        }
        this.repaint();
    }

    public void addItemListener(ItemListener listener) {
        this.leftCombo.addItemListener(listener);
        this.rightCombo.addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.leftCombo.removeItemListener(listener);
        this.rightCombo.removeItemListener(listener);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Insets inset = this.getInsets();
        Dimension origSize = this.getSize();
        int height = this.getPreferredSize().height - inset.top - inset.bottom;
        g.setColor(Color.black);
        int leftWidth = this.leftCombo.getSize().width + 2 * this.getGapHorz();
        g.drawRect(inset.left, inset.top, leftWidth, height);
        g.drawRect(inset.left + 1, inset.top + 1, leftWidth - 2, height - 2);
        int rightWidth = this.rightCombo.getSize().width + 2 * this.getGapHorz();
        g.drawRect(origSize.width - inset.right - rightWidth - 1, inset.top, rightWidth, height);
        g.drawRect(origSize.width - inset.right - rightWidth, inset.top + 1, rightWidth - 2, height - 2);
        g.drawLine(inset.left + leftWidth, inset.top + height / 2, origSize.width - inset.right - rightWidth - 1, inset.top + height / 2);
        g.drawLine(inset.left + leftWidth, inset.top + 1 + height / 2, origSize.width - inset.right - rightWidth - 1, inset.top + 1 + height / 2);
        g.drawLine(inset.left + leftWidth, inset.top - 1 + height / 2, origSize.width - inset.right - rightWidth - 1, inset.top - 1 + height / 2);
        g.drawString("source", inset.left + leftWidth + 5, inset.top + height / 2 - 5);
        g.drawString("target", origSize.width - inset.right - rightWidth - 5 - g.getFontMetrics().stringWidth("target"), inset.top + height / 2 - 5);
    }

    public void doLayout() {
        Insets inset = this.getInsets();
        Dimension origSize = this.getSize();
        int height = this.getPreferredSize().height - inset.top - inset.bottom;
        Dimension dim = this.leftCombo.getPreferredSize();
        this.leftCombo.setSize(dim);
        int leftWidth = dim.width + 2 * this.getGapHorz();
        Point loc = new Point(inset.left + (leftWidth - dim.width) / 2, inset.top + (height - dim.height) / 2);
        this.leftCombo.setLocation(loc);
        dim = this.rightCombo.getPreferredSize();
        this.rightCombo.setSize(dim);
        int rightWidth = dim.width + 2 * this.getGapHorz();
        loc = new Point(origSize.width - rightWidth - inset.right - 1 + (rightWidth - dim.width) / 2, inset.top + (height - dim.height) / 2);
        this.rightCombo.setLocation(loc);
        dim = this.swapButton.getPreferredSize();
        this.swapButton.setSize(dim);
        loc = new Point(inset.left + leftWidth + (origSize.width - inset.left - inset.right - leftWidth - rightWidth - dim.width) / 2, height + inset.top - dim.height);
        this.swapButton.setLocation(loc);
    }

    protected void addComponents() {
    }

    public void setReadOnly(boolean b) {
    }

    public boolean isHorzResizable() {
        return true;
    }

    public boolean isVertResizable() {
        return true;
    }

    public void setCombosEnabled(boolean value) {
        this.rightCombo.setEnabled(value);
        this.leftCombo.setEnabled(value);
    }

    public boolean isCombosEnabled() {
        return this.rightCombo.isEnabled() && this.leftCombo.isEnabled();
    }
}

