/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEDestSelectionListener;
import de.uni_paderborn.fujaba.gui.PEHeaderComponent;
import de.uni_paderborn.fujaba.gui.PEItem;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PEResizable;
import de.uni_paderborn.fujaba.gui.PERow;
import de.uni_paderborn.fujaba.gui.PESourceSelectionListener;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;

public class PESelection
extends PEHeaderComponent
implements PEResizable {
    PEListIncr source;
    PEListIncr destination;
    PEColumn buttonCol = null;
    private PEButton addButton = null;
    private PEButton removeButton = null;
    private PEButton modifyButton = null;
    private ASGElement umlIncr = null;

    public PESelection(BasicPropertyEditor parent) {
        this.setParent(parent);
        this.source = new PEListIncr(this.parent, "Source");
        this.destination = new PEListIncr(this.parent, "Destination");
        this.source.addSelectionListener(new PESourceSelectionListener(this));
        this.destination.addSelectionListener(new PEDestSelectionListener(this));
        this.setLayout(this.getLayoutManager());
        this.addComponents();
    }

    public void setReadOnly(boolean b) {
    }

    protected PEColumn getButtonColumn() {
        return this.buttonCol;
    }

    protected BasicPropertyEditor getParentPE() {
        return this.parent;
    }

    protected void addComponents() {
        PEColumn column = new PEColumn(this.getParentPE());
        PERow row = new PERow(this.getParentPE());
        row.add(this.source);
        this.buttonCol = new PEColumn(this.getParentPE());
        this.buttonCol.setComponentName("buttons");
        this.addButton = new PEButton(this, "add");
        this.removeButton = new PEButton(this, "remove");
        this.modifyButton = new PEButton(this, "apply");
        this.buttonCol.add(this.addButton);
        this.buttonCol.add(this.removeButton);
        this.buttonCol.add(this.modifyButton);
        row.add(this.buttonCol);
        row.add(this.destination);
        column.add(row);
        this.add(column);
    }

    public void setIncrement(ASGElement incr) {
        this.umlIncr = incr;
        this.source.removeAll();
        this.destination.removeAll();
        this.fillSourceList();
        this.fillDestList();
    }

    public ASGElement getIncrement() {
        return this.umlIncr;
    }

    public void clearSource() {
        this.source.removeAll();
    }

    public void clearDest() {
        this.destination.removeAll();
    }

    public ASGElement getSourceSelectedIncr() {
        return this.source.getSelectedIncrement();
    }

    public ASGElement getDestSelectedIncr() {
        return this.destination.getSelectedIncrement();
    }

    public void setSourceSelectedIncr(ASGElement incr) {
        this.getSource().selectIncrement(incr);
    }

    public void setDestSelectedIncr(ASGElement incr) {
        this.getDest().selectIncrement(incr);
    }

    public void setAddListener(ActionListener listener) {
        this.addButton.setListener(listener);
    }

    public void setRemoveListener(ActionListener listener) {
        this.removeButton.setListener(listener);
    }

    public void setModifyListener(ActionListener listener) {
        this.modifyButton.setListener(listener);
    }

    public void setSourceMouseListener(MouseListener listener) {
        this.source.addMouseListener(listener);
    }

    public void setDestMouseListener(MouseListener listener) {
        this.destination.addMouseListener(listener);
    }

    public void addToSource(ASGElement incr) {
        PEItem item = new PEItem(incr);
        this.source.add(item);
    }

    public void addToSource(ASGElement incr, String s) {
        PEItem item = new PEItem(incr, s);
        this.source.add(item);
    }

    public void addToDest(ASGElement incr) {
        PEItem item = new PEItem(incr);
        this.destination.add(item);
    }

    public void addToDest(ASGElement incr, String s) {
        PEItem item = new PEItem(incr, s);
        this.destination.add(item);
    }

    public void removeFromSource(ASGElement incr) {
        this.source.remove(incr);
    }

    public void removeFromDest(ASGElement incr) {
        this.destination.remove(incr);
    }

    public Enumeration getSourceList() {
        return this.source.elements();
    }

    public PEListIncr getSource() {
        return this.source;
    }

    public PEListIncr getDest() {
        return this.destination;
    }

    protected void fillSourceList() {
    }

    protected void fillDestList() {
    }

    protected void sourceSelectionChanged() {
    }

    protected void destSelectionChanged() {
    }

    public ASGElement getSourceIncrementByName(String name) {
        return this.source.getIncrementByName(name);
    }

    public ASGElement getDestIncrementByName(String name) {
        return this.destination.getIncrementByName(name);
    }

    public boolean isHorzResizable() {
        return true;
    }

    public boolean isVertResizable() {
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.drawString("test", 0, 0);
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        return PEButton.remainedUnbound;
    }

    protected PEButton getAddButton() {
        return this.addButton;
    }

    protected PEButton getRemoveButton() {
        return this.removeButton;
    }

    protected PEButton getModifyButton() {
        return this.modifyButton;
    }
}

