/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.CMAFocusListener;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PECombo;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListbox;
import de.uni_paderborn.fujaba.gui.PERadioGroup;
import de.uni_paderborn.fujaba.gui.PESelection;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PEVariableSelection;
import de.uni_paderborn.fujaba.gui.PEVariable_addButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEVariable_modifyButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PEVariable_removeButton_actionAdapter;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.upb.tools.fca.FLinkedList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PEVariable
extends PropertyEditor {
    private static final transient Logger log;
    PETextField propertyName;
    PETextField initialValue;
    PECombo umlVisibilityChoice;
    PEVariableSelection selection;
    PECheck finalModifier;
    PECheck staticModifier;
    PECheck transientModifier;
    PERadioGroup createAccessMethods;
    PECheck pointer = null;
    FLinkedList addAttrs = new FLinkedList();
    FLinkedList delAttrs = new FLinkedList();
    FLinkedList refClasses = new FLinkedList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.PEVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PEVariable(JFrame frame, String title, boolean modal) {
        super(frame);
        this.setModal(modal);
        this.setTitle(title);
        try {
            this.pack();
            this.setTitle("Attribute Editor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initPE();
        this.addFocusListener(new CMAFocusListener(this.propertyName));
        this.propertyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PEVariable.this.addButton_actionPerformed(e);
            }
        });
    }

    public PEVariable(JFrame frame) {
        this(frame, "", false);
    }

    public PEVariable(JFrame frame, boolean modal) {
        this(frame, "", modal);
    }

    public PEVariable(JFrame frame, String title) {
        this(frame, title, false);
    }

    public void setPropertyName(String name) {
        this.propertyName.setText(name);
    }

    public void setInitialValue(String value) {
        this.initialValue.setText(value);
    }

    public void setUmlVisibilityChoice(int index) {
        this.umlVisibilityChoice.setSelectedIndex(index);
    }

    public void setFinalModifier(boolean b) {
        this.finalModifier.setSelected(b);
    }

    public void setStaticModifier(boolean b) {
        this.staticModifier.setSelected(b);
    }

    public void setCreateAccessMethods(int create) {
        this.createAccessMethods.setSelectedButtonIndex(create);
    }

    public void setCreateAccessMethods(boolean create) {
        this.setCreateAccessMethods(create ? 2 : 1);
    }

    public void setPointer(boolean b) {
        this.pointer.setSelected(b);
    }

    public void setTransientModifier(boolean b) {
        this.transientModifier.setSelected(b);
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.propertyName = new PETextField(this, "Attribute Name");
        this.initialValue = new PETextField(this, "Initial Value");
        this.umlVisibilityChoice = new PECombo(this, "UML Visibility");
        this.selection = new PEVariableSelection(this);
        this.finalModifier = new PECheck(this, "Final Modifier", "Attribut is final");
        this.staticModifier = new PECheck(this, "Static Modifier", "Attribut is static");
        this.transientModifier = new PECheck(this, "Transient Modifier", "Attribut is transient");
        this.createAccessMethods = new PERadioGroup(this, "Access methods", new String[]{"Yes", "No", "Yes, except for constants"});
        this.pointer = new PECheck(this, "Pointer", "Attribut type is pointer");
        this.propertyName.setText(this.getPropertyName());
        this.propertyName.setStatus("Enter the name of the attribute");
        this.initialValue.setText("");
        this.initialValue.setStatus("Enter the initial value of the attribute");
        this.setCreateAccessMethods(2);
        this.umlVisibilityChoice.add("- private");
        this.umlVisibilityChoice.add("+ public");
        this.umlVisibilityChoice.add("# protected");
        this.umlVisibilityChoice.add("~ package");
        this.umlVisibilityChoice.setSelectedIndex(1);
        this.umlVisibilityChoice.setStatus("Select the visibility of the attribute");
        this.selection.setSourceMouseListener(new SourceMouseListener(this.selection.getSource().getList()));
        this.selection.setDestMouseListener(new DestMouseListener(this.selection.getSource().getList()));
        this.selection.setAddListener(new PEVariable_addButton_actionAdapter(this));
        this.selection.setRemoveListener(new PEVariable_removeButton_actionAdapter(this));
        this.selection.setModifyListener(new PEVariable_modifyButton_actionAdapter(this));
        PEColumn column = new PEColumn(this);
        column.add(this.propertyName);
        column.add(this.finalModifier);
        column.add(this.staticModifier);
        column.add(this.transientModifier);
        column.add(this.umlVisibilityChoice);
        column.add(this.createAccessMethods);
        column.add(this.pointer);
        column.add(this.initialValue);
        column.add(this.selection);
        panel.add(column);
    }

    public void setIncrement(UMLIncrement incr) {
        this.setReadOnly(this.isReadOnly());
        if (incr instanceof UMLAttr) {
            super.setIncrement(((UMLAttr)incr).getParent());
            this.selection.getDest().selectIncrement(incr);
        } else {
            super.setIncrement(incr);
        }
        if (this.getClassIncrement() != null) {
            this.propertyName.setReadOnly(this.isReadOnly());
            this.initialValue.setReadOnly(this.isReadOnly());
            this.setTitle("Attribute Editor: " + this.getClassIncrement().getName());
        }
    }

    public void unparse() {
        if (this.getIncrement() instanceof UMLClass) {
            UMLClass selectedClass = (UMLClass)this.getIncrement();
            this.propertyName.setText(this.getPropertyName());
            this.selection.setIncrement(selectedClass);
            this.propertyName.selectAll();
        }
    }

    protected void parse() {
        if (!this.isReadOnly()) {
            ASGElement incr = this.getIncrement();
            if (incr instanceof UMLClass) {
                UMLAttr attr = null;
                Iterator iter = this.addAttrs.iterator();
                while (iter.hasNext()) {
                    attr = (UMLAttr)iter.next();
                    attr.setParent((UMLClass)incr);
                    Iterator it = attr.iteratorOfAccessMethods();
                    while (it.hasNext()) {
                        UMLMethod method = (UMLMethod)it.next();
                        method.setParent((UMLClass)incr);
                    }
                }
                this.addAttrs.clear();
                iter = this.delAttrs.iterator();
                while (iter.hasNext()) {
                    attr = (UMLAttr)iter.next();
                    attr.removeYou();
                }
                this.delAttrs.clear();
                iter = this.refClasses.iterator();
                while (iter.hasNext()) {
                    UMLClass refClass = (UMLClass)iter.next();
                    Iterator diags = ((UMLClass)incr).iteratorOfDiagrams();
                    if (diags == null) continue;
                    UMLDiagram diag = null;
                    while (diags.hasNext()) {
                        diag = (UMLDiagram)diags.next();
                        diag.addToElements(refClass);
                    }
                }
                this.refClasses.clear();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Editor in ReadOnly mode.");
        }
    }

    protected void cancel() {
        this.refClasses.clear();
        this.addAttrs.clear();
        this.delAttrs.clear();
        this.setVisible(false);
        this.dispose();
    }

    void addButton_actionPerformed(ActionEvent e) {
        if (this.selection.getTypeName().length() > 0 && this.propertyName.getText().length() > 0) {
            UMLAttr newAttr = new UMLAttr();
            newAttr.setName(this.propertyName.getText());
            newAttr.setFinal(this.finalModifier.isSelected());
            newAttr.setUmlStatic(this.staticModifier.isSelected());
            newAttr.setTransient(this.transientModifier.isSelected());
            newAttr.setInitialValue(this.initialValue.getText());
            ASGElement incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
            if (incr == null) {
                UMLTypeList typelist = null;
                if (this.getIncrement() instanceof UMLClass) {
                    typelist = ((UMLClass)this.getIncrement()).getRevTypes();
                }
                UMLClass refClass = new UMLClass(this.selection.getTypeName(), UMLStereotypeManager.get().getFromStereotypes("reference"), typelist, null);
                newAttr.setAttrType(refClass);
                this.refClasses.add(refClass);
            } else {
                newAttr.setAttrType((UMLType)((Object)incr));
            }
            newAttr.setVisibility(this.umlVisibilityChoice.getSelectedIndex());
            newAttr.setPointer(this.pointer.isSelected());
            newAttr.setParent((UMLClass)this.getIncrement());
            newAttr.setCreateAccessMethods(this.createAccessMethods.getSelectedButtonIndex());
            PEVariable.handleAccessMethods(this.selection, false, this.umlVisibilityChoice.getSelectedIndex(), newAttr);
            newAttr.setParent(null);
            this.addAttrs.add(newAttr);
            this.selection.addToDest(newAttr);
            this.propertyName.setText("");
            this.propertyName.requestFocus();
            this.pointer.setSelected(false);
        }
    }

    public static void handleAccessMethods(PESelection selection, boolean createAccessMethods, int umlVisibilityChoice, UMLAttr newAttr) {
        if (selection != null) {
            selection.setDestSelectedIncr(newAttr);
        }
        Iterator iter = newAttr.iteratorOfAccessMethods();
        while (iter.hasNext()) {
            UMLMethod method = (UMLMethod)iter.next();
            method.removeYou();
        }
    }

    protected void removeButton_actionPerformed(ActionEvent e) {
        ASGElement incr = this.selection.getDestSelectedIncr();
        if (incr != null) {
            this.delAttrs.add(incr);
            this.selection.removeFromDest(incr);
            this.addAttrs.remove(incr);
        }
    }

    void modifyButton_actionPerformed(ActionEvent e) {
        ASGElement oldIncr = this.selection.getDestSelectedIncr();
        if (oldIncr != null && oldIncr instanceof UMLAttr) {
            UMLAttr curAttr = (UMLAttr)oldIncr;
            UMLAttr oldAttr = new UMLAttr();
            oldAttr.setName(curAttr.getName());
            oldAttr.setFinal(curAttr.isFinal());
            oldAttr.setUmlStatic(curAttr.isUmlStatic());
            oldAttr.setTransient(curAttr.isTransient());
            oldAttr.setInitialValue(curAttr.getInitialValue());
            oldAttr.setVisibility(curAttr.getVisibility());
            oldAttr.setAttrType(curAttr.getAttrType());
            oldAttr.setCreateAccessMethods(curAttr.getCreateAccessMethods());
            oldAttr.setPointer(curAttr.isPointer());
            curAttr.setName(this.propertyName.getText());
            curAttr.setFinal(this.finalModifier.isSelected());
            curAttr.setUmlStatic(this.staticModifier.isSelected());
            curAttr.setTransient(this.transientModifier.isSelected());
            curAttr.setInitialValue(this.initialValue.getText());
            curAttr.setVisibility(this.umlVisibilityChoice.getSelectedIndex());
            curAttr.setCreateAccessMethods(this.createAccessMethods.getSelectedButtonIndex());
            curAttr.setPointer(this.pointer.isSelected());
            ASGElement incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
            if (incr == null) {
                UMLTypeList typelist = null;
                if (this.getIncrement() instanceof UMLClass) {
                    typelist = ((UMLClass)this.getIncrement()).getRevTypes();
                }
                UMLClass refClass = new UMLClass(this.selection.getTypeName(), UMLStereotypeManager.get().getFromStereotypes("reference"), typelist, null);
                curAttr.setAttrType(refClass);
                this.refClasses.add(refClass);
            } else {
                curAttr.setAttrType((UMLType)((Object)incr));
            }
            PEVariable.handleAccessMethods(this.selection, this.createAccessMethods.getSelectedButtonIndex() != 1, this.umlVisibilityChoice.getSelectedIndex(), curAttr);
            this.selection.removeFromDest(curAttr);
            this.selection.addToDest(curAttr);
        }
    }

    protected String getPropertyName() {
        if (this.getClassIncrement() != null) {
            int count = 1;
            Iterator iter = this.getClassIncrement().iteratorOfAttrs();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return "var" + count;
        }
        return "New Variable";
    }

    private class SourceMouseListener
    implements MouseListener {
        PEListbox liste;

        SourceMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ASGElement oldIncr = PEVariable.this.selection.getDestSelectedIncr();
                if (oldIncr != null && oldIncr instanceof UMLAttr) {
                    UMLAttr curAttr = (UMLAttr)oldIncr;
                    if (PEVariable.this.propertyName.getText().equals(curAttr.getName())) {
                        PEVariable.this.modifyButton_actionPerformed(null);
                    } else {
                        PEVariable.this.addButton_actionPerformed(null);
                    }
                } else {
                    PEVariable.this.addButton_actionPerformed(null);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DestMouseListener
    implements MouseListener {
        PEListbox liste;

        DestMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isRightMouseButton(e)) {
                PEVariable.this.removeButton_actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

