/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ListUI;

public class SelectFromListDialog
extends AbstractDialog {
    Collection objects;
    JList objectList;
    Object selectedObject = null;
    JLabel heading;

    public SelectFromListDialog(JFrame frame) {
        super(frame, true);
        this.createUserInterface();
        this.initialize();
    }

    public void setHeading(String heading) {
        this.heading.setText(heading);
    }

    public void setObjects(Collection objects) {
        this.objects = objects;
        if (objects != null) {
            Vector objectsVector = new Vector(objects);
            this.objectList.setListData(objectsVector);
        }
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    protected JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.heading = new JLabel();
        panel.add((Component)this.heading, "North");
        this.objectList = new JList();
        this.objectList.setSelectionMode(0);
        this.objectList.addMouseListener(new DoubleClickListener());
        JScrollPane scrollPane = new JScrollPane(this.objectList);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    protected void unparse() {
    }

    protected void parse() {
        this.selectedObject = this.objectList.getSelectedValue();
    }

    private class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                boolean clickedAnItem;
                ListUI ui = SelectFromListDialog.this.objectList.getUI();
                boolean bl = clickedAnItem = ui.locationToIndex(SelectFromListDialog.this.objectList, e.getPoint()) != -1;
                if (SelectFromListDialog.this.objectList.getSelectedValue() != null && clickedAnItem) {
                    SelectFromListDialog.this.okPressed();
                }
            }
        }
    }
}

