/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.app.PanelColumnLayout;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StartActivityPanel
extends ActivityPanel {
    private JComboBox classesComboBox;
    private JCheckBox historyCheckBox;
    JRadioButton shallowRadioButton;
    JRadioButton deepRadioButton;
    private JList methodsList;
    MethodsListModel methodsListModel;

    public StartActivityPanel(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        if (this.isResponsible()) {
            if (asgElement instanceof ViewDiagram) {
                asgElement = ((ViewDiagram)asgElement).getOriginalDiagram();
            }
            if (asgElement instanceof UMLActivityDiagram && ((UMLActivityDiagram)asgElement).belongsToState() || asgElement instanceof UMLStartActivity && ((UMLStartActivity)asgElement).getActivityDiagram().belongsToState()) {
                this.createStatechartStartEditor();
            } else {
                this.createActivityStartEditor();
            }
        }
    }

    private void createStatechartStartEditor() {
        this.setLayout(new PanelColumnLayout());
        this.shallowRadioButton = new JRadioButton("Shallow");
        this.deepRadioButton = new JRadioButton("Deep");
        this.historyCheckBox = new JCheckBox("History");
        this.historyCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                StartActivityPanel.this.shallowRadioButton.setEnabled(checkBox.isSelected());
                StartActivityPanel.this.deepRadioButton.setEnabled(checkBox.isSelected());
            }
        });
        this.historyCheckBox.setSelected(false);
        this.add(this.historyCheckBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.shallowRadioButton);
        buttonGroup.add(this.deepRadioButton);
        this.shallowRadioButton.setSelected(true);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 0));
        radioButtonPanel.add(new JLabel("       "));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridLayout(2, 0));
        rightPanel.add(this.shallowRadioButton);
        rightPanel.add(this.deepRadioButton);
        radioButtonPanel.add(rightPanel);
        this.add(radioButtonPanel);
    }

    private void createActivityStartEditor() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(gridBag);
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        JLabel classLabel = new JLabel("Select Class");
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(classLabel, constraints);
        this.add(classLabel);
        this.classesComboBox = new JComboBox();
        this.classesComboBox.setToolTipText("Select a class for the activity.");
        this.classesComboBox.addItemListener(new ClassesComboBoxListener());
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.classesComboBox, constraints);
        this.add(this.classesComboBox);
        JLabel methodLabel = new JLabel("Select Method");
        constraints.insets = new Insets(8, 3, 0, 3);
        gridBag.setConstraints(methodLabel, constraints);
        this.add(methodLabel);
        this.methodsListModel = new MethodsListModel();
        this.methodsList = new JList(this.methodsListModel);
        this.methodsList.setSelectionMode(0);
        this.methodsList.setToolTipText("Select the method for this activity.");
        JScrollPane scrollPane = new JScrollPane(this.methodsList);
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.weighty = 1.0;
        gridBag.setConstraints(scrollPane, constraints);
        this.add(scrollPane);
    }

    public String getName() {
        return "Start";
    }

    public boolean isResponsible() {
        UMLActivityDiagram actDiagram;
        boolean responsible = false;
        ASGElement incr = this.getAsgElement();
        if (incr instanceof UMLActivityDiagram || incr instanceof ViewDiagram && ((ViewDiagram)incr).getOriginalDiagram() instanceof UMLActivityDiagram) {
            responsible = true;
        } else if (incr instanceof UMLStartActivity && (actDiagram = ((UMLStartActivity)incr).getActivityDiagram()).belongsToState()) {
            responsible = true;
        }
        return responsible;
    }

    public UMLActivity parse() {
        UMLStartActivity start = null;
        if (this.getAsgElement() instanceof UMLDiagram) {
            UMLDiagram diag = (UMLDiagram)this.getAsgElement();
            UMLActivityDiagram actDiag = null;
            if (diag instanceof UMLActivityDiagram) {
                actDiag = (UMLActivityDiagram)diag;
            } else if (diag instanceof ViewDiagram && ((ViewDiagram)diag).getOriginalDiagram() instanceof UMLActivityDiagram) {
                actDiag = (UMLActivityDiagram)((ViewDiagram)diag).getOriginalDiagram();
            } else {
                return null;
            }
            if (actDiag.belongsToState()) {
                start = new UMLStartActivity();
                if (this.historyCheckBox.isSelected()) {
                    if (this.deepRadioButton.isSelected()) {
                        start.setHistoryKind(1);
                    } else if (this.shallowRadioButton.isSelected()) {
                        start.setHistoryKind(2);
                    }
                }
                diag.addToElements(start);
            } else if (this.methodsList.getSelectedIndex() >= 0) {
                UMLMethod selectedMethod = this.methodsListModel.getMethodAt(this.methodsList.getSelectedIndex());
                if (selectedMethod != null) {
                    start = new UMLStartActivity(selectedMethod);
                    diag.addToElements(start);
                }
            } else {
                start = new UMLStartActivity();
                diag.addToElements(start);
            }
        } else if (this.getAsgElement() instanceof UMLStartActivity) {
            start = (UMLStartActivity)this.getAsgElement();
            if (this.historyCheckBox.isSelected()) {
                if (this.deepRadioButton.isSelected()) {
                    start.setHistoryKind(1);
                } else if (this.shallowRadioButton.isSelected()) {
                    start.setHistoryKind(2);
                }
            } else {
                start.setHistoryKind(0);
            }
        }
        return start;
    }

    public void unparse() {
        if (this.getAsgElement() instanceof UMLStartActivity) {
            UMLStartActivity startActivity = (UMLStartActivity)this.getAsgElement();
            if (startActivity.isHistory()) {
                this.historyCheckBox.setSelected(true);
                if (startActivity.getHistoryKind() == 1) {
                    this.deepRadioButton.setSelected(true);
                } else {
                    this.shallowRadioButton.setSelected(true);
                }
            }
        } else if (this.getAsgElement() instanceof UMLDiagram) {
            UMLProject proj;
            UMLDiagram diag = (UMLDiagram)this.getAsgElement();
            UMLActivityDiagram actDiag = null;
            if (diag instanceof UMLActivityDiagram) {
                actDiag = (UMLActivityDiagram)diag;
            } else if (diag instanceof ViewDiagram && ((ViewDiagram)diag).getOriginalDiagram() instanceof UMLActivityDiagram) {
                actDiag = (UMLActivityDiagram)((ViewDiagram)diag).getOriginalDiagram();
            }
            if (!actDiag.belongsToState() && (proj = UMLProject.get()) != null) {
                Enumeration classes = proj.elementsOfClasses();
                if (classes != null) {
                    while (classes.hasMoreElements()) {
                        this.classesComboBox.addItem(classes.nextElement());
                    }
                }
                if (this.classesComboBox.getItemCount() > 0) {
                    this.classesComboBox.setSelectedIndex(0);
                }
            }
        }
    }

    private class ClassesComboBoxListener
    implements ItemListener {
        ClassesComboBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            UMLClass currentClass = (UMLClass)comboBox.getSelectedItem();
            if (currentClass != null) {
                Iterator methodIter = currentClass.iteratorOfMethods();
                UMLMethod method = null;
                Vector<UMLMethod> vector = new Vector<UMLMethod>();
                while (methodIter.hasNext()) {
                    method = (UMLMethod)methodIter.next();
                    if (method.getRevSpec() != null) continue;
                    vector.add(method);
                }
                StartActivityPanel.this.methodsListModel.setMethods(vector);
            }
        }
    }

    private class MethodsListModel
    extends AbstractListModel {
        private Vector methods = new Vector();

        public void setMethods(Vector methods) {
            this.methods = methods;
            this.fireContentsChanged(this, 0, methods.size());
        }

        public Object getElementAt(int index) {
            return ((UMLMethod)this.methods.elementAt(index)).getText();
        }

        public UMLMethod getMethodAt(int index) {
            return (UMLMethod)this.methods.elementAt(index);
        }

        public int getSize() {
            return this.methods.size();
        }
    }
}

