/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.actions.KillDisplay;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.tools.util.MethodDeclaration;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StartActivityPanelForMethod
extends ActivityPanel {
    private JTextField signatureTextField;
    private AbstractAction changeSignatureAction;

    public StartActivityPanelForMethod(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        this.changeSignatureAction = UserInterfaceManager.get().getFromActions("refactor.changeSignature");
        if (this.isResponsible()) {
            this.init();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        JPanel panel = new JPanel();
        panel.setLayout(gridBag);
        JLabel nameLabel = new JLabel("Method Signature");
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(nameLabel, constraints);
        panel.add(nameLabel);
        this.signatureTextField = new JTextField();
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.signatureTextField, constraints);
        panel.add(this.signatureTextField);
        this.add((Component)panel, "North");
    }

    public String getName() {
        return "Method start";
    }

    public boolean isResponsible() {
        return this.changeSignatureAction != null && this.getMethod() != null;
    }

    private UMLMethod getMethod() {
        UMLMethod method;
        if (this.getAsgElement() instanceof UMLStartActivity) {
            UMLStartActivity startActivity = (UMLStartActivity)this.getAsgElement();
            method = startActivity.getSpec();
        } else {
            method = null;
        }
        return method;
    }

    public UMLActivity parse() {
        Vector<Object> params = new Vector<Object>(2);
        params.add(this.getMethod());
        params.add(this.signatureTextField.getText());
        this.changeSignatureAction.actionPerformed(new ActionEvent(params.iterator(), 0, null));
        new KillDisplay().actionPerformed(null);
        return (UMLActivity)this.getAsgElement();
    }

    public void unparse() {
        UMLMethod method = this.getMethod();
        String signature = MethodDeclaration.userReadableSignature(method);
        this.signatureTextField.setText(signature);
    }
}

