/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StopActivityPanel
extends ActivityPanel {
    private JComboBox objectsComboBox;
    private JCheckBox checkBoxGenerateCode;

    public StopActivityPanel(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        if (this.isResponsible()) {
            this.setLayout(new BorderLayout());
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel panel = new JPanel();
            panel.setLayout(gridBag);
            constraints.fill = 1;
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            JLabel objectLabel = new JLabel("Return Object");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(objectLabel, constraints);
            panel.add(objectLabel);
            this.objectsComboBox = new JComboBox();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.objectsComboBox, constraints);
            panel.add(this.objectsComboBox);
            this.objectsComboBox.setEditable(true);
            this.checkBoxGenerateCode = new JCheckBox("Generate Code");
            this.checkBoxGenerateCode.setSelected(true);
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(this.checkBoxGenerateCode, constraints);
            panel.add(this.checkBoxGenerateCode);
            this.add((Component)panel, "North");
        }
    }

    public String getName() {
        return "Stop";
    }

    public boolean isResponsible() {
        return this.getAsgElement() instanceof UMLStopActivity || this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram;
    }

    private void fillObjectsComboBox(UMLActivityDiagram diag) {
        if (diag != null) {
            FHashSet objects = new FHashSet();
            Iterator iter = diag.iteratorOfObjects();
            if (iter != null) {
                UMLObject object = null;
                while (iter.hasNext()) {
                    object = (UMLObject)iter.next();
                    String text = object.getText();
                    if (objects.contains(text)) continue;
                    objects.add(text);
                    this.objectsComboBox.addItem(text);
                }
            }
        }
    }

    public UMLActivity parse() {
        ASGElement incr = this.getAsgElement();
        UMLStopActivity stop = null;
        if (incr instanceof UMLActivityDiagram || incr instanceof ViewDiagram && ((ViewDiagram)incr).getOriginalDiagram() instanceof UMLActivityDiagram) {
            UMLActivityDiagram diag = (UMLActivityDiagram)this.getAsgElement();
            if (diag.getRevContains() == null && diag != null) {
                stop = new UMLStopActivity(this.checkBoxGenerateCode.isSelected(), (String)this.objectsComboBox.getSelectedItem());
                diag.addToElements(stop);
            } else {
                JOptionPane.showMessageDialog(null, "You only can add a stop activity in the uttermost state.", "error", 0);
            }
        } else if (incr instanceof UMLStopActivity && (stop = (UMLStopActivity)incr) != null) {
            stop.setReturnValue((String)this.objectsComboBox.getSelectedItem());
            stop.setGenerateCode(this.checkBoxGenerateCode.isSelected());
        }
        return stop;
    }

    public void unparse() {
        ASGElement incr = this.getAsgElement();
        this.objectsComboBox.addItem("");
        this.objectsComboBox.addItem("null");
        if (incr instanceof UMLActivityDiagram) {
            this.fillObjectsComboBox((UMLActivityDiagram)incr);
            this.checkBoxGenerateCode.setSelected(true);
        } else if (incr instanceof ViewDiagram && ((ViewDiagram)incr).getOriginalDiagram() instanceof UMLActivityDiagram) {
            this.fillObjectsComboBox((UMLActivityDiagram)((ViewDiagram)incr).getOriginalDiagram());
            this.checkBoxGenerateCode.setSelected(true);
        } else if (incr instanceof UMLStopActivity) {
            UMLStopActivity stop = (UMLStopActivity)incr;
            this.checkBoxGenerateCode.setSelected(stop.isGenerateCode());
            Iterator diags = stop.iteratorOfDiagrams();
            if (diags != null) {
                UMLDiagram diag = null;
                while (diags.hasNext()) {
                    diag = (UMLDiagram)diags.next();
                    if (!(diag instanceof UMLActivityDiagram)) continue;
                    this.fillObjectsComboBox((UMLActivityDiagram)diag);
                }
            }
            this.objectsComboBox.setSelectedItem(stop.getReturnValue());
        }
    }
}

