/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StoryActivityPanel
extends ActivityPanel {
    private JTextField nameTextField;
    private JCheckBox typeCheckBox;

    public StoryActivityPanel(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        if (this.isResponsible()) {
            this.setLayout(new BorderLayout());
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            JPanel panel = new JPanel();
            panel.setLayout(gridBag);
            JLabel nameLabel = new JLabel("Name");
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(nameLabel, constraints);
            panel.add(nameLabel);
            this.nameTextField = new JTextField();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.nameTextField, constraints);
            panel.add(this.nameTextField);
            this.typeCheckBox = new JCheckBox("\"For Each\"-Activity");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(this.typeCheckBox, constraints);
            panel.add(this.typeCheckBox);
            this.add((Component)panel, "North");
        }
    }

    public String getName() {
        return "Story";
    }

    public boolean isResponsible() {
        return this.getAsgElement() instanceof UMLStoryActivity || this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram;
    }

    public UMLActivity parse() {
        if (this.getAsgElement() != null) {
            ASGElement incr = this.getAsgElement();
            if (incr instanceof UMLDiagram) {
                UMLDiagram diag = (UMLDiagram)this.getAsgElement();
                UMLActivityDiagram actDiag = null;
                UMLStoryActivity story = null;
                if (diag instanceof UMLActivityDiagram) {
                    actDiag = (UMLActivityDiagram)diag;
                } else if (diag instanceof ViewDiagram && ((ViewDiagram)diag).getOriginalDiagram() instanceof UMLActivityDiagram) {
                    actDiag = (UMLActivityDiagram)((ViewDiagram)diag).getOriginalDiagram();
                } else {
                    return null;
                }
                if (actDiag.belongsToState()) {
                    UMLComplexState complexState = new UMLComplexState();
                    UMLStoryPattern storyPattern = new UMLStoryPattern(this.nameTextField.getText(), UMLProject.get(), 0, null);
                    story = new UMLStoryActivity(this.typeCheckBox.isSelected(), storyPattern);
                    complexState.setName(this.nameTextField.getText());
                    complexState.setStory(story);
                    diag.addToElements(complexState);
                    return complexState;
                }
                UMLStoryPattern storyPattern = new UMLStoryPattern(this.nameTextField.getText(), UMLProject.get(), 0, null);
                story = new UMLStoryActivity(this.typeCheckBox.isSelected(), storyPattern);
                diag.addToElements(story);
                return story;
            }
            if (incr instanceof UMLStoryActivity) {
                UMLStoryActivity umlStoryActivity = (UMLStoryActivity)incr;
                umlStoryActivity.setForEach(this.typeCheckBox.isSelected());
                UMLStoryPattern storyPattern = umlStoryActivity.getStoryPattern();
                if (storyPattern != null) {
                    storyPattern.setName(this.nameTextField.getText());
                }
                return umlStoryActivity;
            }
            return null;
        }
        return null;
    }

    public void unparse() {
        if (this.getAsgElement() != null) {
            ASGElement incr = this.getAsgElement();
            if (incr instanceof UMLDiagram) {
                UMLDiagram diag = (UMLDiagram)this.getAsgElement();
                UMLActivityDiagram actDiag = null;
                if (diag instanceof UMLActivityDiagram) {
                    actDiag = (UMLActivityDiagram)diag;
                } else if (diag instanceof ViewDiagram && ((ViewDiagram)diag).getOriginalDiagram() instanceof UMLActivityDiagram) {
                    actDiag = (UMLActivityDiagram)((ViewDiagram)diag).getOriginalDiagram();
                } else {
                    return;
                }
                this.typeCheckBox.setEnabled(!actDiag.belongsToState());
                this.nameTextField.setText("");
                this.typeCheckBox.setSelected(false);
            } else if (incr instanceof UMLStoryActivity) {
                try {
                    this.typeCheckBox.setEnabled(!((UMLActivityDiagram)((UMLStoryActivity)incr).getFirstFromDiagrams()).belongsToState());
                }
                catch (Exception e) {
                    this.typeCheckBox.setEnabled(true);
                }
                this.typeCheckBox.setSelected(((UMLStoryActivity)incr).isForEach());
                UMLStoryPattern story = ((UMLStoryActivity)incr).getStoryPattern();
                if (story != null) {
                    this.nameTextField.setText(story.getName());
                }
            }
        }
    }
}

