/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gxl;

import de.uni_paderborn.fujaba.gxl.FXMLTree;
import de.uni_paderborn.fujaba.gxl.GXLHandler;
import de.uni_paderborn.fujaba.gxl.XSLTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Validator {
    private static final transient Logger log;
    private File gxlFile = null;
    private File[] stylesheets;
    private BufferedReader input = null;
    private StringBuffer output = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gxl.Validator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public Validator(File myFile) {
        this.gxlFile = myFile;
    }

    public Validator(File myFile, File[] stylesheets) {
        this.gxlFile = myFile;
        this.stylesheets = stylesheets;
    }

    public boolean valid() {
        if (this.gxlFile != null) {
            return this.valid(this.gxlFile);
        }
        return false;
    }

    public boolean valid(File candidate) {
        try {
            try {
                this.input = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(candidate))));
            }
            catch (Exception gz) {
                this.input = new BufferedReader(new InputStreamReader(new FileInputStream(candidate)));
            }
            this.output = new StringBuffer();
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(this.input), (DefaultHandler)new GXLHandler());
            this.input.close();
            log.error((Object)this.output.substring(0));
            if (this.output.capacity() > 16) {
                throw new Exception(String.valueOf(this.output.capacity()) + " " + this.output.substring(0));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return false;
        }
    }

    public FXMLTree getDOMTree() {
        if (this.gxlFile != null) {
            return this.getDOMTree(this.gxlFile);
        }
        return null;
    }

    public FXMLTree getDOMTree(File candidate) {
        try {
            Document xmlFormat = null;
            if (this.stylesheets != null && this.stylesheets.length > 1) {
                xmlFormat = XSLTransformer.transform(candidate, this.stylesheets[0]);
                int idx = 1;
                while (idx < this.stylesheets.length) {
                    xmlFormat = XSLTransformer.transform(xmlFormat, this.stylesheets[idx]);
                    ++idx;
                }
            } else {
                xmlFormat = XSLTransformer.transform(candidate);
            }
            FXMLTree root = new FXMLTree(xmlFormat.getDocumentElement());
            return root;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }
}

