/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout;

import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.layout.MrLayout;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import java.awt.Container;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;

public abstract class AbstractLayouter {
    private boolean lastCondition = false;
    private int horizDist;
    private int vertDist;
    private MrLayout revMyLayouter;
    private double presetAdjustment = 1.4;

    protected AbstractLayouter() {
    }

    protected boolean isLastCondition() {
        return this.lastCondition;
    }

    protected boolean setLastCondition(boolean lastCondition) {
        if (this.lastCondition != lastCondition) {
            this.lastCondition = lastCondition;
        }
        return this.lastCondition;
    }

    public int getHorizDist() {
        return this.horizDist;
    }

    public int setHorizDist(int horizDist) {
        if (horizDist >= 0) {
            this.horizDist = horizDist;
        }
        return this.horizDist;
    }

    public int getVertDist() {
        return this.vertDist;
    }

    public int setVertDist(int vertDist) {
        if (vertDist >= 0) {
            this.vertDist = vertDist;
        }
        return this.vertDist;
    }

    public void refreshOptions() {
        LayoutPreferences myOptions = LayoutPreferences.get();
        this.horizDist = myOptions.getHorizDist();
        this.vertDist = myOptions.getVertDist();
    }

    protected FSAObject getChild(FSABend itemGrab) {
        JBendLine line;
        FSAObject item = null;
        FSABend targetGrab = null;
        JBend grab = (JBend)itemGrab.getJComponent();
        if (grab == (line = grab.getFirstFromLines()).getStartBend()) {
            targetGrab = (FSABend)FSAObject.getFSAObjectFromJComponent(line.getEndBend());
        } else if (grab == line.getEndBend()) {
            targetGrab = (FSABend)FSAObject.getFSAObjectFromJComponent(line.getStartBend());
        }
        if (targetGrab instanceof FSAGrab) {
            item = ((FSAGrab)targetGrab).getTarget();
        } else if (targetGrab != null) {
            this.getChild(targetGrab);
        }
        return item;
    }

    protected void innerLayout(FSAContainer currentClass) throws InterruptedException {
        Object myObject;
        Iterator myIter = currentClass.iteratorOfChildren();
        if (myIter.hasNext() && (myObject = myIter.next()) instanceof FSAContainer) {
            this.reLayout((FSAContainer)myObject);
        }
    }

    protected boolean checkVisited(Object tocheckObject) {
        if (tocheckObject instanceof FSAObject) {
            return ((FSAObject)tocheckObject).isGenerated() ^ this.lastCondition;
        }
        return false;
    }

    protected FSAObject searchStart(FSAContainer searchCanvas, boolean withVisited) {
        FSAObject myObject = null;
        FSAObject myFirstObject = null;
        Iterator myIter = searchCanvas.iteratorOfChildren();
        boolean found = false;
        boolean isActivityDiag = searchCanvas.getLogic() != null && searchCanvas.getLogic() instanceof UMLActivityDiagram;
        while (!found && myIter.hasNext()) {
            myObject = (FSAObject)myIter.next();
            boolean bl = found = myObject instanceof FSAPanel && (!this.checkVisited(myObject) || !withVisited);
            if (!found || !(found = myObject.isVisible()) || !isActivityDiag) continue;
            boolean bl2 = found = myObject.getLogic() != null && myObject.getLogic() instanceof UMLStartActivity;
            if (myFirstObject != null) continue;
            myFirstObject = myObject;
        }
        if (!found && isActivityDiag) {
            myObject = myFirstObject;
            boolean bl = found = myObject != null;
        }
        if (found) {
            return myObject;
        }
        return null;
    }

    protected int getLeft(int pos, Vector rowDepths) {
        int left;
        if (pos < rowDepths.size()) {
            left = (Integer)rowDepths.elementAt(pos);
        } else {
            left = 0;
            rowDepths.addElement(new Integer(left));
        }
        return left;
    }

    protected void setLeft(int left, int pos, Vector rowDepths) {
        rowDepths.setElementAt(new Integer(left), pos);
    }

    public JFrame getFrame(FSAObject canvas) {
        while (canvas != null) {
            if (canvas instanceof FSALayeredPane) {
                Container p = canvas.getJComponent();
                while (p != null) {
                    if (p instanceof JFrame) {
                        return (JFrame)p;
                    }
                    p = p.getParent();
                }
                return null;
            }
            canvas = canvas.getParent();
        }
        return null;
    }

    public abstract void reLayout(FSAContainer var1) throws InterruptedException;

    public MrLayout getRevMyLayouter() {
        return this.revMyLayouter;
    }

    public void setRevMyLayouter(MrLayout revMyLayouter) {
        if (this.revMyLayouter != revMyLayouter) {
            if (this.revMyLayouter != null) {
                MrLayout oldRevMyLayouter = this.revMyLayouter;
                this.revMyLayouter = null;
                oldRevMyLayouter.setMyLayouter(null);
            }
            this.revMyLayouter = revMyLayouter;
            if (revMyLayouter != null) {
                revMyLayouter.setMyLayouter(this);
            }
        }
    }

    public void removeYou() {
        this.setRevMyLayouter(null);
    }

    protected FSAObject getFromToFrame(FSABendLine myLine, int what) {
        FSAObject whatsThere = null;
        if (what == 1) {
            whatsThere = ((FSAGrab)myLine.getStartBend()).getTarget();
        } else if (what == 2) {
            whatsThere = ((FSAGrab)myLine.getEndBend()).getTarget();
        }
        if (whatsThere instanceof FSABendLine) {
            return this.getFromToFrame((FSABendLine)whatsThere, what);
        }
        return whatsThere;
    }

    public double getPresetAdjustment() {
        return this.presetAdjustment;
    }

    public void setPresetAdjustment(double presetAdjustment) {
        if (presetAdjustment > 0.0) {
            this.presetAdjustment = presetAdjustment;
        }
    }

    protected int getPreferredLen(FSABendLine myLine) {
        int width;
        int height;
        FSAObject front242Frame = this.getFromToFrame(myLine, 1);
        FSAObject backFrame = this.getFromToFrame(myLine, 2);
        int len = 0;
        if (front242Frame != null) {
            height = front242Frame.getPreferredSize().height;
            width = front242Frame.getPreferredSize().width;
            len = (int)Math.sqrt(height * height + width * width);
        }
        if (backFrame != null) {
            height = backFrame.getPreferredSize().height;
            width = backFrame.getPreferredSize().width;
            len += (int)Math.sqrt(height * height + width * width);
        }
        len = (int)((double)len * this.presetAdjustment);
        return len;
    }
}

