/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.actions.AddBendAction;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.layout.classdiag.internalmodel.LayoutedEdge;
import java.awt.Point;
import java.util.Iterator;

public abstract class ClassdiagramEdge
implements LayoutedEdge {
    private static int vGap;
    private static int hGap;
    private FSABendLine currentEdge = null;
    private FSAPolyLine underlyingFig = null;
    private FSAObject destFigNode;
    private FSAObject sourceFigNode;

    public ClassdiagramEdge(FSABendLine edge) {
        this.currentEdge = edge;
        this.underlyingFig = (FSAPolyLine)edge;
        this.destFigNode = ((FSAGrab)edge.getStartBend()).getTarget();
        this.sourceFigNode = ((FSAGrab)edge.getEndBend()).getTarget();
        FSABend start = edge.getStartBend();
        FSABend end = edge.getEndBend();
        LogicUnparseInterface lui = edge.getLogic();
        Iterator bendIter = lui.getFSAInterface().iteratorOfFsaObjects();
        while (bendIter.hasNext()) {
            FSABend bend;
            Object obj = bendIter.next();
            if (!(obj instanceof FSABend) || (bend = (FSABend)obj) == start || bend == end) continue;
            bend.removeYou();
        }
    }

    public abstract void layout();

    public static void setHGap(int h) {
        hGap = h;
    }

    public static void setVGap(int v) {
        vGap = v;
    }

    public static int getHGap() {
        return hGap;
    }

    public static int getVGap() {
        return vGap;
    }

    FSAObject getDestFigNode() {
        return this.destFigNode;
    }

    FSAObject getSourceFigNode() {
        return this.sourceFigNode;
    }

    protected FSABendLine getCurrentEdge() {
        return this.currentEdge;
    }

    protected FSAPolyLine getUnderlyingFig() {
        return this.underlyingFig;
    }

    protected void addPoint(int x, int y) {
        FSAPolyLine selectedLine = this.getUnderlyingFig();
        JPolyLine polyLine = (JPolyLine)selectedLine.getJComponent();
        Point cursorPosition = new Point(x, y);
        FSABend bend = AddBendAction.newBend(selectedLine, cursorPosition);
        SelectionManager.get().setSelected(bend, true, true);
        polyLine.insertInBends(1, (JBend)bend.getJComponent());
    }
}

