/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.layout.AbstractLayouter;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramAssociationEdge;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramEdge;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramGeneralizationEdge;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramNode;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramRealizationEdge;
import de.uni_paderborn.fujaba.layout.classdiag.internalmodel.LayoutedObject;
import de.uni_paderborn.fujaba.layout.classdiag.internalmodel.Layouter;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ClassdiagramLayouter
extends AbstractLayouter
implements Layouter {
    public static ClassdiagramLayouter theInstance = null;
    private static final Logger LOG;
    private Vector layoutedObjects = new Vector();
    private Vector layoutedClassNodes = new Vector();
    private int maxPackageRank = -1;
    private int hGap = 80;
    private int vGap = 80;
    private int vMax = 5;
    private int xPos;
    private int yPos;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramLayouter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public static ClassdiagramLayouter get() {
        if (theInstance == null) {
            theInstance = new ClassdiagramLayouter();
        }
        return theInstance;
    }

    private ClassdiagramLayouter() {
    }

    private void init(UMLDiagram curDiagram, int hGap, int vGap) {
        this.layoutedObjects.clear();
        this.layoutedClassNodes.clear();
        this.vGap = vGap;
        this.hGap = hGap;
        Iterator nodeIter = curDiagram.iteratorOfElements();
        while (nodeIter.hasNext()) {
            FSAObject fig;
            Object obj = nodeIter.next();
            if (!(obj instanceof UMLDiagramItem)) continue;
            UMLDiagramItem item = (UMLDiagramItem)obj;
            if (item instanceof UMLClass) {
                fig = item.getFSAInterface().getFirstFromFsaObjects("entry");
                this.add(new ClassdiagramNode((FSAPanel)fig));
            } else if (item instanceof UMLGeneralization) {
                UMLGeneralization gen = (UMLGeneralization)item;
                FSAPolyLine fig2 = (FSAPolyLine)item.getFSAInterface().getFirstFromFsaObjects("line");
                if (gen.getSuperclass().hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"))) {
                    this.add(new ClassdiagramRealizationEdge(fig2));
                } else {
                    this.add(new ClassdiagramGeneralizationEdge(fig2));
                }
            } else if (item instanceof UMLAssoc) {
                fig = (FSAPolyLine)item.getFSAInterface().getFirstFromFsaObjects("line");
                this.add(new ClassdiagramAssociationEdge((FSABendLine)fig));
            } else {
                this.add(null);
            }
            LOG.debug((Object)("Do not know how to deal with: " + item.toString() + "\nUsing standard layout"));
        }
        this.layoutedClassNodes = this.getClassdiagramNodes();
    }

    public void add(LayoutedObject obj) {
        this.layoutedObjects.add(obj);
    }

    public void add(ClassdiagramNode obj) {
        this.layoutedObjects.add(obj);
    }

    public void remove(LayoutedObject obj) {
        this.layoutedObjects.remove(obj);
    }

    public LayoutedObject[] getObjects() {
        Object[] result = new LayoutedObject[this.layoutedObjects.size()];
        this.layoutedObjects.copyInto(result);
        return result;
    }

    public LayoutedObject getObject(int index) {
        return (LayoutedObject)this.layoutedObjects.elementAt(index);
    }

    public ClassdiagramNode getClassdiagramNode(int index) {
        return (ClassdiagramNode)this.layoutedClassNodes.elementAt(index);
    }

    private Vector getClassdiagramNodes() {
        Vector classNodes = new Vector();
        int i = 0;
        while (i < this.layoutedObjects.size()) {
            if (this.layoutedObjects.elementAt(i) instanceof ClassdiagramNode) {
                classNodes.add(this.layoutedObjects.elementAt(i));
            }
            ++i;
        }
        return classNodes;
    }

    public void layout() {
        HashMap maptoAssocNodes = new HashMap();
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            LogicUnparseInterface lui;
            ClassdiagramNode classdiagramNode = this.getClassdiagramNode(i);
            if (!classdiagramNode.isPackage() && (lui = classdiagramNode.getFigure().getLogic()) instanceof UMLClass) {
                UMLGeneralization gen;
                UMLClass clazz = (UMLClass)lui;
                Iterator iter = clazz.iteratorOfRevSubclass();
                while (iter.hasNext()) {
                    gen = (UMLGeneralization)iter.next();
                    ClassdiagramNode superNode = this.getClassdiagramNode4owner(gen.getSuperclass());
                    if (superNode == null) continue;
                    classdiagramNode.addUplink(superNode);
                }
                iter = clazz.iteratorOfRevSuperclass();
                while (iter.hasNext()) {
                    gen = (UMLGeneralization)iter.next();
                    ClassdiagramNode subNode = this.getClassdiagramNode4owner(gen.getSubclass());
                    if (subNode == null) continue;
                    classdiagramNode.addDownlink(subNode);
                }
                ArrayList<UMLClass> associatedClasses = new ArrayList<UMLClass>();
                iter = clazz.iteratorOfAllRoles();
                while (iter.hasNext()) {
                    UMLRole role = (UMLRole)iter.next();
                    UMLClass target = role.getPartnerRole().getTarget();
                    if (associatedClasses.contains(target)) continue;
                    associatedClasses.add(target);
                }
                maptoAssocNodes.put(classdiagramNode, associatedClasses);
            }
            ++i;
        }
        this.rankPackagesAndMoveClassesBelow(maptoAssocNodes);
        this.layoutPackages();
        this.weightAndPlaceClasses();
        ClassdiagramEdge.setVGap(this.vGap);
        ClassdiagramEdge.setHGap(this.hGap);
        i = 0;
        while (i < this.layoutedObjects.size()) {
            if (this.layoutedObjects.elementAt(i) instanceof ClassdiagramEdge) {
                ((ClassdiagramEdge)this.layoutedObjects.elementAt(i)).layout();
            }
            ++i;
        }
    }

    private void rankPackagesAndMoveClassesBelow(HashMap maptoAssocClasses) {
        ClassdiagramNode node;
        int currentColumnPosition = 0;
        int currentRow = 0;
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            node = this.getClassdiagramNode(i);
            if (node.isPackage()) {
                if (currentColumnPosition <= this.vMax) {
                    node.setRank(currentRow);
                    ++currentColumnPosition;
                } else {
                    node.setRank(++currentRow);
                    currentColumnPosition = 0;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (this.getClassdiagramNode(i).isPackage() && this.getClassdiagramNode(i).getRank() > this.maxPackageRank) {
                this.maxPackageRank = this.getClassdiagramNode(i).getRank();
            }
            ++i;
        }
        ++this.maxPackageRank;
        i = 0;
        while (i < this.layoutedClassNodes.size()) {
            Collection assocClasses;
            if (!this.getClassdiagramNode(i).isPackage() && (assocClasses = (Collection)maptoAssocClasses.get(node = this.getClassdiagramNode(i))) != null) {
                Iterator iter = assocClasses.iterator();
                while (iter.hasNext()) {
                    Object me = iter.next();
                    ClassdiagramNode curNode = this.getClassdiagramNode4owner((UMLDiagramItem)me);
                    if (curNode == null || curNode == node || !curNode.isMovable()) continue;
                    LOG.debug((Object)("Moving:" + me));
                    int rank = curNode.getRealRank() == -1 ? node.getRank() : curNode.getRank();
                    LOG.debug((Object)("rank: " + rank));
                    curNode.setRank((rank + node.getRank() + 1) / 2);
                    LOG.debug((Object)("New rank: " + curNode.getRank()));
                    LOG.debug((Object)("Parent Rank: " + node.getRank()));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (!this.getClassdiagramNode(i).isPackage()) {
                node = this.getClassdiagramNode(i);
                node.addRank(this.maxPackageRank);
            }
            ++i;
        }
    }

    private void weightAndPlaceClasses() {
        int rows = this.getRows();
        int curRow = this.maxPackageRank;
        while (curRow < rows) {
            int i;
            this.xPos = this.getHGap() / 2;
            ClassdiagramNode[] rowObject = this.getObjectsInRow(curRow);
            int i2 = 0;
            while (i2 < rowObject.length) {
                if (curRow == this.maxPackageRank) {
                    int nDownlinks = rowObject[i2].getDownlinks().size();
                    rowObject[i2].setWeight(nDownlinks > 0 ? 1 / nDownlinks : 2);
                } else {
                    Vector uplinks = rowObject[i2].getUplinks();
                    int nUplinks = uplinks.size();
                    if (nUplinks > 0) {
                        float averageCol = 0.0f;
                        int j = 0;
                        while (j < uplinks.size()) {
                            averageCol += (float)((ClassdiagramNode)uplinks.elementAt(j)).getColumn();
                            ++j;
                        }
                        rowObject[i2].setWeight(averageCol /= (float)nUplinks);
                    } else {
                        rowObject[i2].setWeight(1000.0f);
                    }
                }
                ++i2;
            }
            int[] pos = new int[rowObject.length];
            int i3 = 0;
            while (i3 < pos.length) {
                pos[i3] = i3;
                ++i3;
            }
            boolean swapped = true;
            while (swapped) {
                swapped = false;
                i = 0;
                while (i < pos.length - 1) {
                    if (rowObject[pos[i]].getWeight() > rowObject[pos[i + 1]].getWeight()) {
                        int temp = pos[i];
                        pos[i] = pos[i + 1];
                        pos[i + 1] = temp;
                        swapped = true;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < pos.length) {
                rowObject[pos[i]].setColumn(i);
                if (i > this.vMax && rowObject[pos[i]].getUplinks().size() == 0 && rowObject[pos[i]].getDownlinks().size() == 0) {
                    if (this.getColumns(rows - 1) > this.vMax) {
                        ++rows;
                    }
                    rowObject[pos[i]].setRank(rows - 1);
                } else {
                    ClassdiagramNode curNode = rowObject[pos[i]];
                    Vector downlinks = curNode.getDownlinks();
                    int bumperX = 0;
                    int currentWidth = (int)curNode.getSize().getWidth();
                    double xOffset = currentWidth;
                    if (downlinks != null && downlinks.size() > 1 && curNode.getUplinks().size() == 0) {
                        xOffset = 0.0;
                        int j = 0;
                        while (j < downlinks.size()) {
                            ClassdiagramNode node = (ClassdiagramNode)downlinks.get(j);
                            xOffset += node.getSize().getWidth();
                            ++j;
                        }
                        bumperX = (int)((xOffset += (double)((downlinks.size() - 1) * this.getHGap())) / 2.0) - currentWidth / 2;
                    }
                    curNode.setLocation(new Point(Math.max(this.xPos + bumperX, curNode.getUplinks().size() == 1 ? curNode.getPlacementHint() : -1), this.yPos));
                    if (downlinks.size() == 1) {
                        ((ClassdiagramNode)downlinks.get(0)).setPlacementHint(this.xPos + bumperX);
                    }
                    this.xPos = (int)((double)this.xPos + Math.max((double)curNode.getPlacementHint(), xOffset + (double)this.getHGap()));
                }
                ++i;
            }
            this.yPos += this.getRowHeight(curRow) + this.getVGap();
            ++curRow;
        }
    }

    void layoutPackages() {
        int rows = this.getRows();
        this.xPos = this.getHGap() / 2;
        this.yPos = this.getVGap() / 2;
        LOG.debug((Object)("Number of rows in layout process: " + rows));
        int curRow = 0;
        while (curRow < this.maxPackageRank) {
            LOG.debug((Object)("Processing row nr: " + curRow));
            this.xPos = this.getHGap() / 2;
            ClassdiagramNode[] rowObject = this.getObjectsInRow(curRow);
            LOG.debug((Object)("Objects in this row: " + rowObject.length));
            int i = 0;
            while (i < rowObject.length) {
                rowObject[i].setColumn(i);
                rowObject[i].setLocation(new Point(this.xPos, this.yPos));
                this.xPos = (int)((double)this.xPos + (rowObject[i].getSize().getWidth() + (double)this.getHGap()));
                ++i;
            }
            this.yPos += this.getRowHeight(curRow) + this.getVGap();
            ++curRow;
        }
    }

    private ClassdiagramNode getClassdiagramNode4owner(UMLIncrement m) {
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (this.layoutedClassNodes.elementAt(i) instanceof ClassdiagramNode && this.getClassdiagramNode(i).getFigure().getLogic() == m) {
                return this.getClassdiagramNode(i);
            }
            ++i;
        }
        return null;
    }

    public Dimension getMinimumDiagramSize() {
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.layoutedObjects.size()) {
            ClassdiagramNode node = this.getClassdiagramNode(i);
            if ((double)node.getLocation().x + node.getSize().getWidth() + (double)(this.getHGap() / 2) >= (double)width) {
                width = (int)((double)node.getLocation().x + node.getSize().getWidth() + (double)(this.getHGap() / 2));
            }
            if ((double)node.getLocation().y + node.getSize().getHeight() + (double)(this.getVGap() / 2) >= (double)height) {
                height = (int)((double)node.getLocation().y + node.getSize().getHeight() + (double)(this.getVGap() / 2));
            }
            ++i;
        }
        return new Dimension(width, height);
    }

    private int getRows() {
        int result = 0;
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            ClassdiagramNode node = this.getClassdiagramNode(i);
            if (node.getRank() >= result) {
                result = node.getRank() + 1;
            }
            ++i;
        }
        return result;
    }

    private int getRowHeight(int row) {
        int currentHeight = 0;
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (this.getClassdiagramNode(i).getRank() == row && this.getClassdiagramNode((int)i).getSize().height > currentHeight) {
                currentHeight = this.getClassdiagramNode((int)i).getSize().height;
            }
            ++i;
        }
        return currentHeight;
    }

    private int getColumns(int row) {
        int result = 0;
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (this.getClassdiagramNode(i).getRank() == row) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private ClassdiagramNode[] getObjectsInRow(int row) {
        Vector<ClassdiagramNode> resultBuffer = new Vector<ClassdiagramNode>();
        int i = 0;
        while (i < this.layoutedClassNodes.size()) {
            if (this.getClassdiagramNode(i).getRank() == row) {
                resultBuffer.add(this.getClassdiagramNode(i));
            }
            ++i;
        }
        Object[] result = new ClassdiagramNode[resultBuffer.size()];
        if (resultBuffer.size() > 0) {
            resultBuffer.copyInto(result);
        }
        return result;
    }

    protected int getVGap() {
        return this.vGap;
    }

    protected int getHGap() {
        return this.hGap;
    }

    public void reLayout(FSAContainer currentCanvas) throws InterruptedException {
        LogicUnparseInterface lui = currentCanvas.getFSAInterface().getLogic();
        LayoutPreferences options = LayoutPreferences.get();
        if (lui instanceof UMLClassDiagram) {
            this.init((UMLClassDiagram)lui, options.getHorizDist(), options.getVertDist());
            this.layout();
        }
    }
}

