/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.options;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;

public class LayoutPreferences
extends AbstractPreferences {
    private static final String PROPERTY_NAME = "MrLayout.";
    private static final String COLLAPSE_CLASSES = "CollapseClasses";
    public static final String SHOW_ROLE_NAMES = "ShowRoleNames";
    private static final String SEL_LAYOUT = "SelectedLayout";
    private static final String SEL_ACTIVITY_DIAGRAM_LAYOUT = "SelectedActivityDiagramLayout";
    private static final String HOR_DIST = "HorizontalDistance";
    private static final String VER_DIST = "VerticalDistance";
    private static final String NUM_OF_ITER = "NumberOfIterations";
    private static final String MINIMUM_WIDTH = "MinimumWidth";
    private static final String STRETCH_FACTOR = "StretchFactor";
    private static final boolean DEF_COLLAPSE_CLASSES = true;
    private static final boolean DEF_SHOW_ROLE_NAMES = false;
    private static final int DEF_SEL_LAYOUT = 0;
    private static final int DEF_SEL_ACTIVITY_DIAGRAM_LAYOUT = 2;
    private static final int DEF_HOR_DIST = 80;
    private static final int DEF_VER_DIST = 80;
    private static final int DEF_MINIMUM_WIDTH = 0;
    private static final int DEF_NUM_OF_ITER = 60;
    private static final double DEF_STRETCH_FACTOR = 1.4;
    private static LayoutPreferences options;

    private LayoutPreferences() {
    }

    public static synchronized LayoutPreferences get() {
        if (options == null) {
            options = new LayoutPreferences();
        }
        return options;
    }

    public void setDefaults() {
        PreferencesProperties options = PreferencesProperties.get();
        options.putSetting("MrLayout.CollapseClasses", true);
        options.putSetting("MrLayout.ShowRoleNames", false);
        options.putSetting("MrLayout.SelectedLayout", 0);
        options.putSetting("MrLayout.SelectedActivityDiagramLayout", 2);
        options.putSetting("MrLayout.HorizontalDistance", 80);
        options.putSetting("MrLayout.VerticalDistance", 80);
        options.putSetting("MrLayout.MinimumWidth", 0);
        options.putSetting("MrLayout.NumberOfIterations", 60);
        options.putSetting("MrLayout.StretchFactor", 1.4);
    }

    public boolean isCollapseClasses() {
        return PreferencesProperties.get().getBoolSetting("MrLayout.CollapseClasses", true);
    }

    public void setCollapseClasses(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("MrLayout.CollapseClasses", true) != value) {
            options.putSetting("MrLayout.CollapseClasses", value);
            this.setModified(true);
        }
    }

    public void setShowRoleNames(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("MrLayout.ShowRoleNames", false) != value) {
            options.putSetting("MrLayout.ShowRoleNames", value);
            this.setModified(true);
        }
    }

    public boolean isShowRoleNames() {
        return PreferencesProperties.get().getBoolSetting("MrLayout.ShowRoleNames", false);
    }

    public int getWhichActivityDiagramLayout() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.SelectedActivityDiagramLayout", 0);
        }
        catch (NumberFormatException e) {
            number = 2;
        }
        return number;
    }

    public void setWhichActivityDiagramLayout(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.SelectedActivityDiagramLayout", 2);
            if (number != value) {
                options.putSetting("MrLayout.SelectedActivityDiagramLayout", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.SelectedActivityDiagramLayout", value);
            this.setModified(true);
        }
    }

    public int getWhichLayout() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.SelectedLayout", 0);
        }
        catch (NumberFormatException e) {
            number = 0;
        }
        return number;
    }

    public void setWhichLayout(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.SelectedLayout", 0);
            if (number != value) {
                options.putSetting("MrLayout.SelectedLayout", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.SelectedLayout", value);
            this.setModified(true);
        }
    }

    public int getHorizDist() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.HorizontalDistance", 80);
        }
        catch (NumberFormatException e) {
            number = 80;
        }
        return number;
    }

    public void setHorizDist(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.HorizontalDistance", 80);
            if (number != value) {
                options.putSetting("MrLayout.HorizontalDistance", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.HorizontalDistance", value);
            this.setModified(true);
        }
    }

    public void setHorizDist(String newDist) {
        try {
            this.setHorizDist(Integer.parseInt(newDist));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getVertDist() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.VerticalDistance", 80);
        }
        catch (NumberFormatException e) {
            number = 80;
        }
        return number;
    }

    public void setVertDist(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.VerticalDistance", 80);
            if (number != value) {
                options.putSetting("MrLayout.VerticalDistance", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.VerticalDistance", value);
            this.setModified(true);
        }
    }

    public void setVertDist(String newDist) {
        try {
            this.setVertDist(Integer.parseInt(newDist));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getMinimumWidth() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.MinimumWidth", 0);
        }
        catch (NumberFormatException e) {
            number = 0;
        }
        return number;
    }

    public void setMinimumWidth(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.MinimumWidth", 0);
            if (number != value) {
                options.putSetting("MrLayout.MinimumWidth", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.MinimumWidth", value);
            this.setModified(true);
        }
    }

    public void setMinimumWidth(String newWidth) {
        try {
            this.setMinimumWidth(Integer.parseInt(newWidth));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getNumberIterations() {
        int number;
        try {
            number = PreferencesProperties.get().getIntSetting("MrLayout.NumberOfIterations", 60);
        }
        catch (NumberFormatException e) {
            number = 60;
        }
        return number;
    }

    public void setNumberIterations(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            int number = options.getIntSetting("MrLayout.NumberOfIterations", 60);
            if (number != value) {
                options.putSetting("MrLayout.NumberOfIterations", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.NumberOfIterations", value);
            this.setModified(true);
        }
    }

    public void setNumberIterations(String newIterations) {
        try {
            this.setNumberIterations(Integer.parseInt(newIterations));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public double getStretchFactor() {
        double number;
        try {
            number = PreferencesProperties.get().getDoubleSetting("MrLayout.StretchFactor", 1.4);
        }
        catch (NumberFormatException e) {
            number = 1.4;
        }
        return number;
    }

    public void setStretchFactor(double value) {
        PreferencesProperties options = PreferencesProperties.get();
        try {
            double number = options.getDoubleSetting("MrLayout.StretchFactor", 1.4);
            if (number != value) {
                options.putSetting("MrLayout.StretchFactor", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("MrLayout.StretchFactor", value);
            this.setModified(true);
        }
    }

    public void setStretchFactor(String newStretchFactor) {
        try {
            Double myDouble = Double.valueOf(newStretchFactor);
            this.setStretchFactor(myDouble);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

