/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.options;

import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LayoutPreferencesPanel
extends PreferencesPanel {
    private JCheckBox collapseClassesCheckBox;
    private JCheckBox showRoleNamesCheckBox;
    private JComboBox defaultLayoutComboBox;
    private JComboBox activityDiagramComboBox;
    private JTextField horizontalDistanceTextField;
    private JTextField verticalDistanceTextField;
    private JTextField iterationsTextField;
    private JTextField stretchFactorTextField;
    private JTextField minimumWidthTextField;

    public LayoutPreferencesPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        JPanel displayPanel = this.createDisplayPanel();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)displayPanel, constraints);
        JPanel algorithmPanel = this.createAlgorithmPanel();
        mainPanel.add((Component)algorithmPanel, constraints);
        JPanel parameterPanel = this.createParameterPanel();
        mainPanel.add((Component)parameterPanel, constraints);
        this.add((Component)mainPanel, "North");
    }

    private JPanel createDisplayPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("UML Class Diagram"));
        panel.setLayout(gridBagLayout);
        this.collapseClassesCheckBox = new JCheckBox("Collapse Attributes and Methods Compartments of UML Classes Initially");
        this.collapseClassesCheckBox.setToolTipText("Classes will be displayed with hidden attributes and methods.");
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.collapseClassesCheckBox, constraints);
        this.showRoleNamesCheckBox = new JCheckBox("Show Association Role Names");
        this.showRoleNamesCheckBox.setToolTipText("For this setting to take effect the current project must be reloaded!");
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.showRoleNamesCheckBox, constraints);
        return panel;
    }

    private JPanel createAlgorithmPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Algorithms"));
        panel.setLayout(gridBagLayout);
        JLabel defaultLayoutLabel = new JLabel("Default Layout:");
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridwidth = 1;
        panel.add((Component)defaultLayoutLabel, constraints);
        this.defaultLayoutComboBox = new JComboBox();
        this.defaultLayoutComboBox.setToolTipText("The default layout algorithm for diagrams.");
        constraints.fill = 1;
        constraints.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)this.defaultLayoutComboBox, constraints);
        JLabel dummyLabel = new JLabel();
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        panel.add((Component)dummyLabel, constraints);
        JLabel activityDiagramLayoutLabel = new JLabel("Activity Diagram Layout:");
        constraints.fill = 0;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        panel.add((Component)activityDiagramLayoutLabel, constraints);
        this.activityDiagramComboBox = new JComboBox();
        this.activityDiagramComboBox.setToolTipText("The layout algorithm for activity diagrams.");
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 3, 3);
        panel.add((Component)this.activityDiagramComboBox, constraints);
        return panel;
    }

    private JPanel createParameterPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Parameter"));
        panel.setLayout(gridBagLayout);
        JLabel horizontalDistanceLabel = new JLabel("Horizontal Distance:");
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)horizontalDistanceLabel, constraints);
        this.horizontalDistanceTextField = new JTextField(10);
        this.horizontalDistanceTextField.setToolTipText("Horizontal distance between layout elements.");
        this.horizontalDistanceTextField.setInputVerifier(new IntegerInputVerifier());
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(3, 0, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.horizontalDistanceTextField, constraints);
        JLabel verticalDistanceLabel = new JLabel("Vertical Distance:");
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        panel.add((Component)verticalDistanceLabel, constraints);
        this.verticalDistanceTextField = new JTextField(10);
        this.verticalDistanceTextField.setToolTipText("Vertical distance between layout elements.");
        this.verticalDistanceTextField.setInputVerifier(new IntegerInputVerifier());
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.verticalDistanceTextField, constraints);
        JLabel minimumWidthLabel = new JLabel("Minimum Width:");
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        panel.add((Component)minimumWidthLabel, constraints);
        this.minimumWidthTextField = new JTextField(10);
        this.minimumWidthTextField.setToolTipText("Minimum width of classes and objects.");
        this.minimumWidthTextField.setInputVerifier(new IntegerInputVerifier());
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.minimumWidthTextField, constraints);
        JLabel iterationsLabel = new JLabel("Iterations for Spring Embedder:");
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        panel.add((Component)iterationsLabel, constraints);
        this.iterationsTextField = new JTextField(10);
        this.iterationsTextField.setToolTipText("Iterations for the spring embedder layout.");
        this.iterationsTextField.setInputVerifier(new IntegerInputVerifier());
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.iterationsTextField, constraints);
        JLabel stretchFactorLabel = new JLabel("Stretch Factor for Spring Embedder:");
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        panel.add((Component)stretchFactorLabel, constraints);
        this.stretchFactorTextField = new JTextField(10);
        this.stretchFactorTextField.setToolTipText("Stretch factor for spring embedder layout.");
        this.stretchFactorTextField.setInputVerifier(new DoubleInputVerifier());
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(0, 0, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.stretchFactorTextField, constraints);
        return panel;
    }

    public String getPreferredTabName() {
        return "Diagram Layout";
    }

    public void setDefaults() {
        LayoutPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        LayoutPreferences options = LayoutPreferences.get();
        this.collapseClassesCheckBox.setSelected(options.isCollapseClasses());
        this.showRoleNamesCheckBox.setSelected(options.isShowRoleNames());
        this.defaultLayoutComboBox.addItem("TreeLayout");
        this.defaultLayoutComboBox.addItem("Spring Embedder");
        this.defaultLayoutComboBox.addItem("Class Diagram Layout");
        this.activityDiagramComboBox.addItem("TreeLayout");
        this.activityDiagramComboBox.addItem("Spring Embedder");
        this.activityDiagramComboBox.addItem("ControlFlowLayout");
        int index = options.getWhichLayout();
        if (index == 3) {
            this.defaultLayoutComboBox.setSelectedIndex(2);
        } else {
            this.defaultLayoutComboBox.setSelectedIndex(index);
        }
        this.activityDiagramComboBox.setSelectedIndex(options.getWhichActivityDiagramLayout());
        this.horizontalDistanceTextField.setText(String.valueOf(options.getHorizDist()));
        this.verticalDistanceTextField.setText(String.valueOf(options.getVertDist()));
        this.minimumWidthTextField.setText(String.valueOf(options.getMinimumWidth()));
        this.iterationsTextField.setText(String.valueOf(options.getNumberIterations()));
        this.stretchFactorTextField.setText(String.valueOf(options.getStretchFactor()));
    }

    public void okPressed() {
        LayoutPreferences options = LayoutPreferences.get();
        options.setCollapseClasses(this.collapseClassesCheckBox.isSelected());
        options.setShowRoleNames(this.showRoleNamesCheckBox.isSelected());
        int index = this.defaultLayoutComboBox.getSelectedIndex();
        if (index == 2) {
            options.setWhichLayout(3);
        } else {
            options.setWhichLayout(index);
        }
        options.setWhichActivityDiagramLayout(this.activityDiagramComboBox.getSelectedIndex());
        options.setHorizDist(this.horizontalDistanceTextField.getText());
        options.setVertDist(this.verticalDistanceTextField.getText());
        options.setMinimumWidth(this.minimumWidthTextField.getText());
        options.setNumberIterations(this.iterationsTextField.getText());
        options.setStretchFactor(this.stretchFactorTextField.getText());
    }

    private class IntegerInputVerifier
    extends InputVerifier {
        IntegerInputVerifier() {
        }

        public boolean verify(JComponent component) {
            boolean result = false;
            JTextField textField = (JTextField)component;
            try {
                Integer.valueOf(textField.getText());
                result = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
    }

    private class DoubleInputVerifier
    extends InputVerifier {
        DoubleInputVerifier() {
        }

        public boolean verify(JComponent component) {
            boolean result = false;
            JTextField textField = (JTextField)component;
            try {
                Double.valueOf(textField.getText());
                result = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
    }
}

