/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.messages;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.IncrSelector;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.messages.MessageView;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.upb.lib.userinterface.UserInterfaceManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.IteratorConcatenation;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Message {
    private LinkedList customActions = new LinkedList();
    private String messageCategory;
    private String text;
    private Set context;
    private MessageView messageView;
    private long time = System.currentTimeMillis();
    private static boolean dobsLoaded = true;
    static Action dobsAction;
    static /* synthetic */ Class class$0;

    public String getMessageCategory() {
        return this.messageCategory;
    }

    public void setMessageCategory(String value) {
        String oldValue = this.messageCategory;
        if (oldValue != value) {
            this.messageCategory = value;
        }
    }

    public Message() {
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Message(String text) {
        this.setText(text);
    }

    public boolean addToContext(FElement value) {
        boolean changed = false;
        if (value != null) {
            if (this.context == null) {
                this.context = new FHashSet();
            }
            if (changed = this.context.add(value)) {
                value.addToUserMessages(this);
            }
        }
        return changed;
    }

    public boolean hasInContext(FElement value) {
        return this.context != null && value != null && this.context.contains(value);
    }

    public Iterator iteratorOfContext() {
        if (this.context == null) {
            return FEmptyIterator.get();
        }
        return this.context.iterator();
    }

    public void removeAllFromContext() {
        Iterator iter = this.iteratorOfContext();
        while (iter.hasNext()) {
            FElement tmpValue = (FElement)iter.next();
            this.removeFromContext(tmpValue);
        }
    }

    public boolean removeFromContext(FElement value) {
        boolean changed = false;
        if (this.context != null && value != null && (changed = this.context.remove(value))) {
            value.removeFromUserMessages(this);
        }
        return changed;
    }

    public int sizeOfContext() {
        return this.context == null ? 0 : this.context.size();
    }

    public Icon getIcon() {
        URL imageURL = this.getIconURL();
        if (imageURL != null) {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
        return null;
    }

    protected URL getIconURL() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.messages.Message");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResource("images/i.png");
    }

    public void removeYou() {
        this.removeAllFromContext();
        MessageView messageView = this.getMessageView();
        if (messageView != null) {
            messageView.removeFromMessages(this);
        }
    }

    public MessageView getMessageView() {
        return this.messageView;
    }

    boolean setMessageView(MessageView value) {
        boolean changed = false;
        MessageView oldValue = this.messageView;
        if (oldValue != value) {
            if (oldValue != null) {
                this.messageView = null;
            }
            this.messageView = value;
            changed = true;
        }
        return changed;
    }

    public String getPath() {
        if (this.sizeOfContext() > 0) {
            Iterator it = this.iteratorOfContext();
            while (it.hasNext()) {
                String fqn = null;
                FElement element = (FElement)it.next();
                while (!(element instanceof FPackage) && element != null) {
                    try {
                        if (element instanceof FMethod) {
                            FMethod method = (FMethod)element;
                            fqn = String.valueOf(method.getFullMethodName()) + (fqn != null ? "." + fqn : "");
                        } else if (element instanceof FClass) {
                            FClass cls = (FClass)element;
                            fqn = String.valueOf(cls.getName()) + (fqn != null ? "." + fqn : "");
                        }
                        element = element.getParentElement();
                    }
                    catch (UnsupportedOperationException e) {
                        e.printStackTrace();
                        element = null;
                    }
                }
                if (element == null) continue;
                FPackage pkg = (FPackage)element;
                if (!"".equals(pkg.getFullPackageName())) {
                    fqn = String.valueOf(pkg.getFullPackageName()) + (fqn != null ? "." + fqn : "");
                }
                return fqn;
            }
        }
        return null;
    }

    public long getTime() {
        return this.time;
    }

    public void showContext() {
        SelectionManager.get().removeAllFromSelectedComponents();
        Iterator it = this.iteratorOfContext();
        while (it.hasNext()) {
            ASGElement element = (ASGElement)it.next();
            IncrSelector.get().gotoElement(element);
        }
    }

    private Action getDobsAction() {
        if (dobsLoaded && dobsAction == null && (dobsAction = UserInterfaceManager.get().getFromActions("dobsAst")) == null) {
            dobsLoaded = false;
        }
        if (dobsLoaded) {
            return new AbstractAction("Show context in DOBS"){

                public void actionPerformed(ActionEvent e) {
                    dobsAction.actionPerformed(new ActionEvent(Message.this.iteratorOfContext(), 0, null));
                }
            };
        }
        return null;
    }

    public Iterator iteratorOfActions() {
        if (this.sizeOfContext() > 0) {
            LinkedList<Action> actions = new LinkedList<Action>();
            Action action = this.getDefaultAction();
            if (action != null) {
                actions.add(action);
            }
            if ((action = this.getDobsAction()) != null) {
                actions.add(action);
            }
            return new IteratorConcatenation(actions.iterator(), this.iteratorOfCustomActions());
        }
        return this.iteratorOfCustomActions();
    }

    public boolean addToCustomActions(Action value) {
        boolean changed = false;
        if (value != null) {
            if (this.customActions == null) {
                this.customActions = new LinkedList();
            }
            if (!this.customActions.contains(value)) {
                changed = this.customActions.add(value);
            }
        }
        return changed;
    }

    public Iterator iteratorOfCustomActions() {
        return this.customActions == null ? FEmptyIterator.get() : this.customActions.iterator();
    }

    public Action getDefaultAction() {
        return new ShowContextAction();
    }

    private class ShowContextAction
    extends AbstractAction {
        public ShowContextAction() {
            super("Show context");
        }

        public void actionPerformed(ActionEvent e) {
            Message.this.showContext();
        }
    }
}

