/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.messages;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.messages.Message;
import de.uni_paderborn.fujaba.messages.MessageListener;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MessageView {
    public static final int COLUMN_ICON = 0;
    public static final int COLUMN_TEXT = 1;
    public static final int COLUMN_PACKAGE = 2;
    public static final int COLUMN_CATEGORY = 3;
    public static final int COLUMN_TIME = 4;
    static final String[] COLUMN_NAMES = new String[]{"", "Message", "Path", "Category", "Time"};
    static final Class[] COLUMN_CLASSES;
    private static final int[] CLOUMN_WIDTHS;
    private static final int IMAGE_SIZE = 16;
    Runnable notifyRunnable;
    public static final int MAX_PREFERRED_WIDTH = 1000;
    private String title;
    JTable table;
    MessageModel model;
    private Set tableModelListeners;
    private List messages;
    private List messageListeners;
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                Iterator it = MessageView.this.iteratorOfSelectedMessages();
                while (it.hasNext()) {
                    Message message = (Message)it.next();
                    message.removeYou();
                }
            }
        }
    };
    int lastClickedColumn = -1;
    int lastClickedRow = -1;
    private MouseListener mouseListener = new MouseAdapter(){
        int lastSortedColumn = -1;

        private void updateLastClicked(MouseEvent e) {
            if (e.getSource() instanceof JTableHeader) {
                JTableHeader header = (JTableHeader)e.getSource();
                MessageView.this.lastClickedRow = -1;
                MessageView.this.lastClickedColumn = header.columnAtPoint(e.getPoint());
            } else if (e.getSource() instanceof JTable) {
                JTable table = (JTable)e.getSource();
                MessageView.this.lastClickedRow = table.rowAtPoint(e.getPoint());
                MessageView.this.lastClickedColumn = table.columnAtPoint(e.getPoint());
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.updateLastClicked(e);
            if (!e.isPopupTrigger()) {
                if (e.getSource() instanceof JTableHeader) {
                    if (this.lastSortedColumn == MessageView.this.lastClickedColumn) {
                        MessageView.this.sortBy(MessageView.this.lastClickedColumn, true);
                        this.lastSortedColumn = -1;
                    } else {
                        MessageView.this.sortBy(MessageView.this.lastClickedColumn, false);
                        this.lastSortedColumn = MessageView.this.lastClickedColumn;
                    }
                }
            } else {
                MessageView.this.showPopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.updateLastClicked(e);
            if (e.isPopupTrigger()) {
                MessageView.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.updateLastClicked(e);
            if (e.isPopupTrigger()) {
                MessageView.this.showPopup(e);
            }
        }
    };
    JPopupMenu headerPopupMenu;
    private AbstractAction hideMessageViewAction = new AbstractAction("Hide message view"){

        public void actionPerformed(ActionEvent e) {
            FrameMain.get().hideMessageView();
        }
    };
    private AbstractAction deleteMessageAction = new AbstractAction("Delete message"){

        public void actionPerformed(ActionEvent e) {
            Message message = MessageView.this.getFromMessages(MessageView.this.lastClickedRow);
            if (message != null) {
                message.removeYou();
            }
        }
    };
    private AbstractAction deleteMessageCategoryAction = new AbstractAction("Delete all from message category"){

        public void actionPerformed(ActionEvent e) {
            Message message = MessageView.this.getFromMessages(MessageView.this.lastClickedRow);
            if (message != null) {
                MessageView.this.deleteMessages(message.getMessageCategory());
            }
        }
    };
    private JComponent component;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.Icon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        COLUMN_CLASSES = classArray;
        CLOUMN_WIDTHS = new int[]{25, -1, 120, 80, 40};
    }

    public MessageView(String title) {
        this.init();
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    boolean addToTableModelListeners(TableModelListener value) {
        boolean changed = false;
        if (value != null) {
            if (this.tableModelListeners == null) {
                this.tableModelListeners = new FHashSet();
            }
            changed = this.tableModelListeners.add(value);
        }
        return changed;
    }

    Iterator iteratorOfTableModelListeners() {
        if (this.tableModelListeners == null) {
            return FEmptyIterator.get();
        }
        return this.tableModelListeners.iterator();
    }

    boolean removeFromTableModelListeners(TableModelListener value) {
        boolean changed = false;
        if (this.tableModelListeners != null && value != null) {
            changed = this.tableModelListeners.remove(value);
        }
        return changed;
    }

    public boolean addToMessages(Message value) {
        boolean changed = false;
        if (value != null) {
            if (this.messages == null) {
                this.messages = new FLinkedList();
            }
            this.messages.add(0, value);
            if (this.messageListeners != null) {
                Iterator it = this.messageListeners.iterator();
                while (it.hasNext()) {
                    MessageListener ml = (MessageListener)it.next();
                    ml.handle(value);
                }
            }
            value.setMessageView(this);
            this.notifyModelChange();
        }
        return changed;
    }

    public boolean addToMessageListeners(MessageListener value) {
        boolean changed = false;
        if (value != null) {
            if (this.messageListeners == null) {
                this.messageListeners = new FLinkedList();
            }
            this.messageListeners.add(0, value);
        }
        return changed;
    }

    public boolean removeFromMessageListeners(MessageListener value) {
        boolean changed = false;
        if (this.messageListeners != null && value != null) {
            changed = this.messageListeners.remove(value);
        }
        return changed;
    }

    private void notifyModelChange() {
        if (this.notifyRunnable == null) {
            this.notifyRunnable = new Runnable(){

                public void run() {
                    MessageView.this.notifyRunnable = null;
                    Iterator it = MessageView.this.iteratorOfTableModelListeners();
                    while (it.hasNext()) {
                        TableModelListener listener = (TableModelListener)it.next();
                        listener.tableChanged(new TableModelEvent(MessageView.this.model));
                    }
                    MessageView.this.getComponent().repaint();
                }
            };
            SwingUtilities.invokeLater(this.notifyRunnable);
        }
    }

    public boolean hasInMessages(Message value) {
        return this.messages != null && value != null && this.messages.contains(value);
    }

    public Iterator iteratorOfMessages() {
        if (this.messages == null) {
            return FEmptyIterator.get();
        }
        return this.messages.iterator();
    }

    public void removeAllFromMessages() {
        Iterator iter = this.iteratorOfMessages();
        while (iter.hasNext()) {
            Message tmpValue = (Message)iter.next();
            this.removeFromMessages(tmpValue);
        }
    }

    public void deleteMessages(String messageClass) {
        Iterator iter = this.iteratorOfMessages();
        while (iter.hasNext()) {
            Message tmpValue = (Message)iter.next();
            if ((messageClass != null || tmpValue.getMessageCategory() != null) && (messageClass == null || !messageClass.equals(tmpValue.getMessageCategory()))) continue;
            tmpValue.removeYou();
        }
    }

    public boolean removeFromMessages(Message value) {
        boolean changed = false;
        if (this.messages != null && value != null && (changed = this.messages.remove(value))) {
            value.setMessageView(null);
            this.notifyModelChange();
        }
        return changed;
    }

    public int sizeOfMessages() {
        return this.messages == null ? 0 : this.messages.size();
    }

    public Message getFromMessages(int index) {
        if (this.messages == null || index < 0 || index >= this.messages.size()) {
            return null;
        }
        return (Message)this.messages.get(index);
    }

    private void init() {
        this.model = new MessageModel();
        this.table = new JTable(this.model){

            public TableCellRenderer getDefaultRenderer(Class columnClass) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.swing.Icon");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(columnClass)) {
                    return new TableCellRenderer(this){
                        private JLabel label;
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                            this.label = new JLabel();
                        }

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            if (value instanceof Icon) {
                                this.label.setIcon((Icon)value);
                            } else {
                                this.label.setText(String.valueOf(value));
                            }
                            return this.label;
                        }
                    };
                }
                return super.getDefaultRenderer(columnClass);
            }
        };
        this.component = new JScrollPane(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Action defaultAction;
                Message message = MessageView.this.getFromMessages(MessageView.this.table.getSelectedRow());
                if (message != null && (defaultAction = message.getDefaultAction()) != null) {
                    defaultAction.actionPerformed(new ActionEvent(MessageView.this.table, 0, null));
                }
            }
        });
        this.table.doLayout();
        int i = 0;
        while (i < CLOUMN_WIDTHS.length) {
            int columnWidth = CLOUMN_WIDTHS[i];
            if (columnWidth >= 0) {
                this.table.getColumnModel().getColumn(i).setPreferredWidth(columnWidth);
            } else {
                this.table.getColumnModel().getColumn(i).setPreferredWidth(1000);
            }
            ++i;
        }
        this.table.doLayout();
        this.table.setAutoResizeMode(1);
        if (this.table.getRowHeight() < 18) {
            this.table.setRowHeight(18);
        }
        this.table.setGridColor(this.table.getBackground());
        this.table.getTableHeader().addMouseListener(this.mouseListener);
        this.table.addMouseListener(this.mouseListener);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.addKeyListener(this.keyListener);
    }

    public Iterator iteratorOfSelectedMessages() {
        int index = 0;
        Vector<Message> selectedMessages = new Vector<Message>();
        Iterator it = this.iteratorOfMessages();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (!this.table.isRowSelected(index++)) continue;
            selectedMessages.add(message);
        }
        return selectedMessages.iterator();
    }

    void showPopup(MouseEvent e) {
        Component component;
        if (this.headerPopupMenu == null) {
            this.headerPopupMenu = new JPopupMenu();
            this.headerPopupMenu.add(new JMenuItem(this.hideMessageViewAction));
        }
        if ((component = (Component)e.getSource()) instanceof JTableHeader) {
            this.headerPopupMenu.show(component, e.getX(), e.getY());
        } else {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(new JMenuItem(this.hideMessageViewAction));
            popupMenu.add(new JSeparator());
            popupMenu.add(new JMenuItem(this.deleteMessageAction));
            popupMenu.add(new JMenuItem(this.deleteMessageCategoryAction));
            Message message = this.getFromMessages(this.lastClickedRow);
            if (message != null) {
                Iterator actionIterator = message.iteratorOfActions();
                if (actionIterator.hasNext()) {
                    popupMenu.add(new JSeparator());
                }
                while (actionIterator.hasNext()) {
                    Action action = (Action)actionIterator.next();
                    popupMenu.add(new JMenuItem(action));
                }
            }
            popupMenu.show(component, e.getX(), e.getY());
        }
    }

    public void sortBy(int column, final boolean ascending) {
        Vector messages = new Vector(this.messages);
        switch (column) {
            case 0: {
                Collections.sort(messages, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Message msg1 = (Message)o1;
                        Message msg2 = (Message)o2;
                        return MessageView.this.compareStrings(msg1.getClass().getName(), msg2.getClass().getName(), ascending);
                    }
                });
                break;
            }
            case 1: {
                Collections.sort(messages, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Message msg1 = (Message)o1;
                        Message msg2 = (Message)o2;
                        return MessageView.this.compareStrings(msg1.getText(), msg2.getText(), ascending);
                    }
                });
                break;
            }
            case 2: {
                Collections.sort(messages, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Message msg1 = (Message)o1;
                        Message msg2 = (Message)o2;
                        return MessageView.this.compareStrings(msg1.getPath(), msg2.getPath(), ascending);
                    }
                });
                break;
            }
            case 3: {
                Collections.sort(messages, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Message msg1 = (Message)o1;
                        Message msg2 = (Message)o2;
                        return MessageView.this.compareStrings(msg1.getMessageCategory(), msg2.getMessageCategory(), ascending);
                    }
                });
                break;
            }
            case 4: {
                Collections.sort(messages, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Message msg1 = (Message)o1;
                        Message msg2 = (Message)o2;
                        return ascending ? (int)(msg1.getTime() - msg2.getTime()) : (int)(msg2.getTime() - msg1.getTime());
                    }
                });
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.getComponent(), "Sorting by this column is not supported.");
            }
        }
        this.messages = new FLinkedList(messages);
        this.notifyModelChange();
    }

    int compareStrings(String text1, String text2, boolean ascending) {
        int cmp = text1 != null ? (text2 != null ? text1.compareTo(text2) : -1) : (text2 != null ? 1 : 0);
        return ascending ? cmp : -cmp;
    }

    public JComponent getComponent() {
        return this.component;
    }

    private class MessageModel
    implements TableModel {
        MessageModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        public int getRowCount() {
            return MessageView.this.sizeOfMessages();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Message message = MessageView.this.getFromMessages(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return message.getIcon();
                }
                case 1: {
                    return message.getText();
                }
                case 2: {
                    return message.getPath();
                }
                case 3: {
                    return message.getMessageCategory();
                }
                case 4: {
                    return DateFormat.getTimeInstance(3).format(new Date(message.getTime()));
                }
            }
            return "";
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void addTableModelListener(TableModelListener l) {
            MessageView.this.addToTableModelListeners(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            MessageView.this.removeFromTableModelListeners(l);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

