/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DirtyDialog;
import de.uni_paderborn.fujaba.mpEdit.DocInterface;
import de.uni_paderborn.fujaba.mpEdit.DocOwnerInterface;
import de.uni_paderborn.fujaba.mpEdit.Hilite;
import de.uni_paderborn.fujaba.mpEdit.HiliteJava;
import de.uni_paderborn.fujaba.mpEdit.HiliteLife;
import de.uni_paderborn.fujaba.mpEdit.JournalItem;
import de.uni_paderborn.fujaba.mpEdit.LineInfo;
import de.uni_paderborn.fujaba.mpEdit.LineMan;
import de.uni_paderborn.fujaba.mpEdit.PrintMan;
import de.uni_paderborn.fujaba.mpEdit.Progress;
import de.uni_paderborn.fujaba.mpEdit.Ruler;
import de.uni_paderborn.fujaba.mpEdit.TagLine;
import de.uni_paderborn.fujaba.mpEdit.TextCanvas;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import de.uni_paderborn.fujaba.mpEdit.TextMenu;
import de.uni_paderborn.fujaba.mpEdit.TextPosition;
import de.uni_paderborn.fujaba.mpEdit.mpEDIT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

class DocMan
implements DocInterface {
    private static final transient Logger log;
    private mpEDIT mpEdit;
    private ResourceBundle strings;
    private Properties props;
    private Hilite hilite;
    private Ruler ruler;
    private LineMan lines = new LineMan();
    private DocOwnerInterface docOwner;
    private Vector frames = new Vector(4, 4);
    private Vector textMenus = new Vector(4, 4);
    private File file;
    private JournalItem undo_list;
    private JournalItem redo_list;
    private boolean dirty;
    private boolean neverNamed;
    private boolean privateProps;
    private boolean highlighting;
    private boolean hiding;
    private Boolean saveReadOnly = null;
    private boolean readOnly;
    private String lineSeparator;
    private static final int REPLACE_LINE = 1;
    private static final int SPLIT_LINE = 2;
    private static final int JOIN_LINE = 3;
    private static final int INSERT = 4;
    private static final int DELETE = 5;
    private static final int SWAP_LINES = 6;
    private static final int DELETE_LINE = 7;
    int nextTag = 123;
    private final int SLOW_READ = 2000;
    private final int SLOW_WRITE = 10000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.mpEdit.DocMan");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public DocMan(mpEDIT mpe, ResourceBundle str, Properties pr) {
        this.lines.addElement("");
        this.mpEdit = mpe;
        this.strings = str;
        this.props = pr;
        this.hilite = new Hilite(this.lines, 0, true);
        this.ruler = new Ruler(this);
        this.lineSeparator = System.getProperty("line.separator");
        this.redo_list = null;
        this.undo_list = null;
        this.setProperty("mpEDIT.hide", String.valueOf(false));
    }

    public void setOwner(DocOwnerInterface o) {
        this.docOwner = o;
    }

    public DocOwnerInterface getOwner() {
        return this.docOwner;
    }

    public void closeDoc(boolean bail) {
        int i = this.frames.size();
        while (--i >= 0) {
            TextFrame textFrame = (TextFrame)this.frames.elementAt(i);
            if (bail || i > 1 || !this.dirty) {
                this.doCloseFrame(textFrame);
                continue;
            }
            DirtyDialog ab = new DirtyDialog(this, textFrame, this.strings, this.strings.getString("DialogDirty"), this.file.getName());
            ab.show();
        }
    }

    public void saveDoc() {
        this.fileSave(this.anyFrame());
    }

    public void saveAsDoc(String pathname) {
        this.file = new File(pathname);
        this.setTitles();
        this.neverNamed = false;
        this.write(this.anyFrame(), this.file);
        this.scan();
    }

    public String getPathname() {
        return this.file.getPath();
    }

    public String getFilename() {
        return this.file.getName();
    }

    public void setFilename(String fileName) {
        this.file = new File(fileName);
        this.setTitles();
        this.neverNamed = false;
        this.scan();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public TagLine tagLine(int line) {
        LineInfo li = this.lines.getLineInfo(line);
        li.tagValue = this.nextTag++;
        TagLine tag = new TagLine();
        tag.tagValue = li.tagValue;
        tag.lastLine = line;
        return tag;
    }

    public TagLine tagLine(int line, Color color) {
        LineInfo li = this.lines.getLineInfo(line);
        li.tagValue = this.nextTag++;
        li.tagColor = color;
        TagLine tag = new TagLine();
        tag.tagValue = li.tagValue;
        tag.lastLine = line;
        this.updateFrames(line, line);
        return tag;
    }

    public int lineFromTag(TagLine tag) {
        int i = tag.lastLine;
        LineInfo li = this.lines.getLineInfo(i);
        if (li.tagValue == tag.tagValue) {
            return i;
        }
        i = this.lines.size();
        while (--i >= 0) {
            li = this.lines.getLineInfo(i);
            if (li.tagValue != tag.tagValue) continue;
            tag.lastLine = i;
            return i;
        }
        return -1;
    }

    public boolean showLine(TagLine tag) {
        int line = this.lineFromTag(tag);
        if (line < 0) {
            return false;
        }
        TextFrame f = this.anyFrame();
        f.showLine(line);
        return true;
    }

    public String getLine(TagLine tag) {
        int line = this.lineFromTag(tag);
        if (line < 0) {
            return null;
        }
        return this.lines.getString(line);
    }

    public boolean setLine(TagLine tag, String s) {
        int line = this.lineFromTag(tag);
        if (line < 0) {
            return false;
        }
        this.lines.setString(s, line);
        this.updateFrames(line, line);
        this.dirty = true;
        return true;
    }

    public boolean addLine(TagLine tag, String s) {
        int line = this.lineFromTag(tag);
        if (line < 0) {
            return false;
        }
        this.lines.insertElementAt(s, line);
        this.updateFrames(line, line + 1);
        this.dirty = true;
        return true;
    }

    public boolean deleteLine(TagLine tag) {
        int line = this.lineFromTag(tag);
        if (line < 0) {
            return false;
        }
        this.lines.removeElementAt(line);
        this.updateFrames(line, line + 1);
        this.dirty = true;
        return true;
    }

    public Document getDocument() {
        PlainDocument doc = new PlainDocument();
        try {
            int i = this.getLineCount() - 1;
            while (i >= 0) {
                TagLine tag = this.tagLine(i);
                doc.insertString(0, String.valueOf(this.getLine(tag)) + "\n", null);
                --i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void setUntitled(int count) {
        String filename = String.valueOf(this.strings.getString("UntitledDoc")) + (count == 1 ? "" : " " + count);
        this.file = new File(filename);
        this.setTitles();
        this.neverNamed = true;
    }

    public void setTitles() {
        String name = this.file.toString();
        int max = this.frames.size();
        int i = 0;
        while (i < max) {
            if (max > 1) {
                name = String.valueOf(this.file.toString()) + ":" + (i + 1);
            }
            ((TextFrame)this.frames.elementAt(i)).setTitle(name);
            ++i;
        }
    }

    public TextFrame newFrame(Point point, Dimension size) {
        TextFrame textFrame = new TextFrame(this.mpEdit, this.strings, this.props, this, this.ruler);
        textFrame.setLocation(point);
        textFrame.setSize(size);
        this.frames.addElement(textFrame);
        this.updateMenus();
        return textFrame;
    }

    public void closeFrame(TextFrame textFrame) {
        int max = this.frames.size();
        if (max > 1 || !this.dirty) {
            this.doCloseFrame(textFrame);
        } else {
            DirtyDialog ab = new DirtyDialog(this, textFrame, this.strings, this.strings.getString("DialogDirty"), this.file.getName());
            ab.show();
        }
    }

    public void doCloseFrame(TextFrame textFrame) {
        int max = this.frames.size();
        int i = 0;
        while (i < max) {
            if (textFrame == (TextFrame)this.frames.elementAt(i)) {
                this.frames.removeElementAt(i);
                textFrame.dispose();
                --max;
                break;
            }
            ++i;
        }
        if (max == 0) {
            this.mpEdit.closeDoc(this);
        } else {
            this.setTitles();
        }
    }

    public void newDoc() {
        this.lines.removeAllElements();
        this.lines.addElement("");
        int max = this.frames.size();
        int i = 0;
        while (i < max) {
            TextFrame f = (TextFrame)this.frames.elementAt(i);
            f.clearCanvas();
            f.redoCanvas();
            ++i;
        }
        this.setUntitled(this.mpEdit.getUntitled());
        this.clear_undo();
        this.updateMenus();
    }

    public boolean isBusy() {
        return this.dirty || !this.neverNamed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean aReadOnly) {
        if (aReadOnly != this.readOnly) {
            this.readOnly = aReadOnly;
            int max = this.frames.size();
            int i = 0;
            while (i < max) {
                ((TextFrame)this.frames.elementAt(i)).setReadOnly(this.readOnly);
                ++i;
            }
        }
    }

    public TextFrame anyFrame() {
        return (TextFrame)this.frames.firstElement();
    }

    public void openDoc(TextFrame textFrame, String filename) {
        this.file = new File(filename);
        if (this.file.isFile()) {
            this.neverNamed = false;
            int max = this.frames.size();
            int i = 0;
            while (i < max) {
                ((TextFrame)this.frames.elementAt(i)).clearCanvas();
                ++i;
            }
            this.setTitles();
            this.ruler.invalidate(0, 1000000);
            this.read(textFrame, filename);
            i = 0;
            while (i < max) {
                ((TextFrame)this.frames.elementAt(i)).redoCanvas();
                ++i;
            }
            this.scan();
        }
        textFrame.getCanvas().requestFocus();
    }

    public void filePrint(TextFrame textFrame) {
        PrintMan pm = new PrintMan(textFrame, this, this.file.getName(), this.getFont(), this.getTabSize());
        pm.start();
    }

    public boolean fileSave(TextFrame textFrame) {
        return this.doSaveFile(textFrame, false);
    }

    public void fileSaveAs(TextFrame textFrame) {
        this.doSaveFile(textFrame, true);
    }

    private boolean doSaveFile(TextFrame textFrame, boolean As) {
        boolean ok = true;
        String filename = null;
        if (this.neverNamed || As) {
            filename = this.getFileForSave(textFrame);
            if (filename == null) {
                ok = false;
            } else {
                this.file = new File(filename);
                this.setTitles();
                this.neverNamed = false;
            }
        }
        if (ok) {
            this.write(textFrame, this.file);
            this.scan();
            if (this.docOwner != null) {
                if (As) {
                    this.docOwner.savedAsDoc(this, filename);
                } else {
                    this.docOwner.savedDoc(this);
                }
            }
        }
        return ok;
    }

    private String getFileForSave(TextFrame textFrame) {
        String prompt = this.strings.getString("DialogSaveAs");
        FileDialog d = new FileDialog((Frame)textFrame, prompt, 1);
        d.setFile(this.file.getName());
        String dirname = this.neverNamed ? this.mpEdit.getSaveDir() : this.file.getParent();
        d.setDirectory(dirname);
        d.setVisible(true);
        String filename = d.getFile();
        dirname = d.getDirectory();
        String pathname = String.valueOf(dirname) + filename;
        d.dispose();
        if (filename != null) {
            if (this.neverNamed) {
                this.mpEdit.setSaveDir(dirname);
            }
            return pathname;
        }
        return null;
    }

    public void read(TextFrame textFrame, String filename) {
        Progress readProgress;
        block7: {
            boolean show_progress;
            readProgress = null;
            long max = this.file.length();
            long tens = max / 10L;
            long part = 0L;
            long all = 0L;
            boolean bl = show_progress = max > 2000L;
            if (show_progress) {
                readProgress = new Progress(textFrame, "Reading file ... ");
                readProgress.show();
            }
            this.lines.freshVectors((int)Math.max(max / 20L, 100L), (int)Math.max(max / 100L, 100L));
            try {
                String line;
                BufferedReader br = null;
                FileReader fr = new FileReader(filename);
                br = filename.endsWith(".zip") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))), 32768) : new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    if (show_progress && (part += (long)line.length()) > tens) {
                        readProgress.update((int)(100L * (all += part) / max));
                        part = 0L;
                    }
                    this.lines.addElement(line);
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) break block7;
                log.info((Object)"Error - could not read file");
            }
        }
        if (readProgress != null) {
            readProgress.dispose();
        }
        if (this.lines.size() < 1) {
            this.lines.addElement("");
        }
    }

    public void write(TextFrame textFrame, File file) {
        Progress writeProgress;
        block6: {
            boolean show_progress;
            writeProgress = null;
            long max = this.lines.size();
            long tens = max / 10L;
            long part = 0L;
            long all = 0L;
            boolean bl = show_progress = max > 10000L;
            if (show_progress) {
                writeProgress = new Progress(textFrame, "Writing file ... ");
                writeProgress.show();
            }
            try {
                FileWriter fw = new FileWriter(file);
                BufferedWriter bw = new BufferedWriter(fw);
                int i = 0;
                while ((long)i < max) {
                    String line = this.lines.getString(i);
                    bw.write(line, 0, line.length());
                    bw.newLine();
                    if (show_progress && ++part > tens) {
                        writeProgress.update((int)(100L * (all += part) / max));
                        part = 0L;
                    }
                    ++i;
                }
                bw.close();
                fw.close();
                this.dirty = false;
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) break block6;
                log.info((Object)"Error - could not write file");
            }
        }
        if (writeProgress != null) {
            writeProgress.dispose();
        }
    }

    public void clear_undo() {
        this.redo_list = null;
        this.undo_list = null;
    }

    public void scan() {
        this.highlighting = Boolean.valueOf(this.getProperty("mpEDIT.hilite"));
        if (this.saveReadOnly == null) {
            this.saveReadOnly = this.isReadOnly();
        }
        if (this.highlighting && this.mpEdit.getHighlightingEnabled()) {
            if (this.hiding) {
                HiliteLife myHilite = new HiliteLife(this.lines, this.getTabSize(), false);
                myHilite.scan(this.lines.size() - 1);
                if (!myHilite.isHideLevelEmpty() && log.isInfoEnabled()) {
                    log.info((Object)"mpEDIT: Not all hide tags are closed!");
                }
                this.hilite = myHilite;
                this.setReadOnly(true);
            } else {
                this.hilite = new HiliteJava(this.lines, this.getTabSize(), false);
                this.setReadOnly(this.saveReadOnly);
                this.hilite.scan(this.getHighest());
            }
        } else {
            this.hilite = new Hilite(this.lines, 0, true);
            this.highlighting = false;
            this.hiding = false;
            this.setReadOnly(this.saveReadOnly);
            this.hilite.scan(this.getHighest());
        }
        int i = this.frames.size();
        while (i-- > 0) {
            TextFrame textFrame = (TextFrame)this.frames.elementAt(i);
            TextCanvas textCanvas = textFrame.getCanvas();
            textCanvas.repaint();
        }
    }

    public void extendHilite(int highest) {
        int temp = this.lines.size() - 1;
        if (highest > temp) {
            highest = temp;
        }
        this.hilite.extendScan(highest);
    }

    public Hilite getHilite() {
        return this.hilite;
    }

    public Color getTextColor() {
        return this.hilite.getTextColor();
    }

    public Color getTextXColor() {
        return this.hilite.getTextXColor();
    }

    public Color getCommentColor() {
        return this.hilite.getCommentColor();
    }

    public Color getCommentXColor() {
        return this.hilite.getCommentXColor();
    }

    public Color getKeywordColor() {
        return this.hilite.getKeywordColor();
    }

    public Color getKeywordXColor() {
        return this.hilite.getKeywordXColor();
    }

    public Color getQuoteColor() {
        return this.hilite.getQuoteColor();
    }

    public Color getQuoteXColor() {
        return this.hilite.getQuoteXColor();
    }

    public Color getHideColor() {
        return this.hilite.getHideColor();
    }

    public Color getHideXColor() {
        return this.hilite.getHideXColor();
    }

    public void updateFrames(int first, int last) {
        this.ruler.invalidate(first, last);
        last = this.hilite.update(first, last, this.getHighest());
        int i = this.frames.size();
        while (i > 0) {
            TextFrame textFrame = (TextFrame)this.frames.elementAt(--i);
            TextCanvas textCanvas = textFrame.getCanvas();
            textCanvas.legalizeCursor();
            textCanvas.linesChanged(first, last);
        }
    }

    private void legalizeCursors() {
        int max = this.frames.size();
        int i = 0;
        while (i < max) {
            TextFrame f = (TextFrame)this.frames.elementAt(i);
            f.legalizeCursor();
            ++i;
        }
    }

    private int getHighest() {
        int temp;
        int i = this.frames.size();
        int highest = 0;
        while (i-- > 0) {
            TextFrame textFrame = (TextFrame)this.frames.elementAt(i);
            TextCanvas textCanvas = textFrame.getCanvas();
            temp = textCanvas.getHighest();
            if (temp <= highest) continue;
            highest = temp;
        }
        temp = this.lines.size() - 1;
        if (highest > temp) {
            highest = temp;
        }
        return highest;
    }

    public String getProperty(String p) {
        return this.props.getProperty(p);
    }

    public void setProperty(String p, String v) {
        this.props.put(p, v);
    }

    public void setProperties(Properties p) {
        this.props = p;
        this.privateProps = false;
    }

    public void splitProperties() {
        if (!this.privateProps) {
            this.props = new Properties(this.props);
            this.privateProps = true;
        }
    }

    public void updateProperties(boolean global) {
        if (global) {
            this.mpEdit.updateProperties(this.props);
        } else {
            this.applyProperties();
        }
    }

    public void applyProperties() {
        this.scan();
        int i = this.frames.size();
        while (i-- > 0) {
            TextFrame textFrame = (TextFrame)this.frames.elementAt(i);
            TextCanvas textCanvas = textFrame.getCanvas();
            textCanvas.applyProperties();
        }
    }

    public String getFontStyle() {
        String style = this.props.getProperty("mpEDIT.font.style");
        switch (Integer.valueOf(style)) {
            case 0: {
                return this.strings.getString("ChoicePlain");
            }
            case 1: {
                return this.strings.getString("ChoiceBold");
            }
            case 2: {
                return this.strings.getString("ChoiceItalic");
            }
            case 3: {
                return this.strings.getString("ChoiceBoldItalic");
            }
        }
        return this.strings.getString("ChoicePlain");
    }

    public void setFontStyle(String style) {
        int s = 0;
        if (style.equals(this.strings.getString("ChoiceBold"))) {
            s = 1;
        } else if (style.equals(this.strings.getString("ChoiceItalic"))) {
            s = 2;
        } else if (style.equals(this.strings.getString("ChoiceBoldItalic"))) {
            s = 3;
        }
        this.props.put("mpEDIT.font.style", String.valueOf(s));
    }

    public Font getFont() {
        String name = this.props.getProperty("mpEDIT.font.name");
        String style = this.props.getProperty("mpEDIT.font.style");
        String size = this.props.getProperty("mpEDIT.font.size");
        return new Font(name, (int)Integer.valueOf(style), Integer.valueOf(size));
    }

    public int getTabSize() {
        int tabs;
        try {
            tabs = Integer.valueOf(this.props.getProperty("mpEDIT.tab.size"));
        }
        catch (NumberFormatException e) {
            this.props.put("mpEDIT.tab.size", "4");
            tabs = 4;
        }
        return tabs;
    }

    public int getHideLevel() {
        int hideLevel;
        try {
            hideLevel = Integer.valueOf(this.props.getProperty("mpEDIT.hide.level"));
        }
        catch (NumberFormatException e) {
            this.props.put("mpEDIT.hide.level", "0");
            hideLevel = 0;
        }
        return hideLevel;
    }

    public String getLine(int i) {
        return this.lines.getString(i);
    }

    public LineInfo getLineInfo(int i) {
        return this.lines.getLineInfo(i);
    }

    public void addTextMenu(TextMenu e) {
        this.textMenus.addElement(e);
    }

    public void updateUndoItems(boolean un, boolean re) {
        int max = this.frames.size();
        int i = 0;
        while (i < max) {
            TextCanvas tc = ((TextFrame)this.frames.elementAt(i)).getCanvas();
            tc.updateUndoActions(un, re);
            ++i;
        }
    }

    private void updateMenus() {
        boolean got_undo = this.undo_list != null;
        boolean got_redo = this.redo_list != null;
        this.updateUndoItems(got_undo, got_redo);
    }

    public void undo(TextFrame textFrame) {
        if (this.undo_list != null) {
            TextPosition tp;
            JournalItem temp = this.undo_list;
            this.undo_list = temp.next;
            int last = temp.line;
            int first = last++;
            switch (temp.action) {
                case 1: {
                    this.redo_line(temp);
                    break;
                }
                case 2: {
                    this.split_or_join(temp, true);
                    break;
                }
                case 3: {
                    this.split_or_join(temp, false);
                    break;
                }
                case 4: {
                    this.copy_or_cut(temp, true);
                    break;
                }
                case 5: {
                    tp = this.insert(temp);
                    last = tp.line;
                    break;
                }
                case 6: {
                    this.internal_swap_lines(temp.line, temp.eline);
                    ++last;
                    break;
                }
                case 7: {
                    this.insert(temp);
                    ++last;
                }
            }
            this.updateFrames(first, last);
            tp = new TextPosition(temp.line, temp.column);
            textFrame.setPos(tp);
            this.legalizeCursors();
            temp.next = this.redo_list;
            this.redo_list = temp;
        }
        this.updateMenus();
    }

    public void redo(TextFrame textFrame) {
        if (this.redo_list != null) {
            TextPosition tp;
            int line;
            JournalItem temp = this.redo_list;
            this.redo_list = temp.next;
            int last = line = temp.line;
            int first = line;
            int column = temp.column;
            switch (temp.action) {
                case 1: {
                    column = temp.text.length();
                    this.redo_line(temp);
                    break;
                }
                case 2: {
                    this.split_or_join(temp, false);
                    column = 0;
                    break;
                }
                case 3: {
                    this.split_or_join(temp, true);
                    ++last;
                    break;
                }
                case 4: {
                    tp = this.insert(temp);
                    last = tp.line;
                    line = temp.eline;
                    column = temp.ecolumn;
                    break;
                }
                case 5: {
                    this.copy_or_cut(temp, true);
                    break;
                }
                case 6: {
                    this.internal_swap_lines(temp.line, temp.eline);
                    ++last;
                    break;
                }
                case 7: {
                    this.lines.removeElementAt(temp.line);
                }
            }
            this.updateFrames(first, last);
            tp = new TextPosition(line, column);
            textFrame.setPos(tp);
            this.legalizeCursors();
            temp.next = this.undo_list;
            this.undo_list = temp;
        }
        this.updateMenus();
    }

    public void insert_char(int line, int column, char c) {
        String s = this.lines.getString(line);
        this.remember_line(line, column, s);
        s = String.valueOf(s.substring(0, column)) + c + s.substring(column, s.length());
        this.lines.setString(s, line);
        this.updateFrames(line, line);
        this.dirty = true;
    }

    public void delete_char(int line, int column) {
        String s = this.lines.getString(line);
        this.remember_line(line, column, s);
        s = String.valueOf(s.substring(0, column)) + s.substring(column + 1, s.length());
        this.lines.setString(s, line);
        this.updateFrames(line, line);
        this.dirty = true;
    }

    private void remember_line(int line, int column, String s) {
        boolean new_line = true;
        if (this.undo_list != null) {
            boolean bl = new_line = this.undo_list.action != 1 || this.undo_list.line != line;
        }
        if (new_line) {
            JournalItem new_journal = new JournalItem();
            new_journal.action = 1;
            new_journal.line = line;
            new_journal.column = column;
            new_journal.text = s;
            new_journal.next = this.undo_list;
            this.undo_list = new_journal;
        }
        this.redo_list = null;
        this.updateMenus();
    }

    private void redo_line(JournalItem i) {
        int line = i.line;
        String s = this.lines.getString(line);
        this.lines.setString(i.text, line);
        i.text = s;
    }

    public void split_line(int line, int column) {
        JournalItem new_journal = new JournalItem();
        new_journal.action = 2;
        new_journal.line = line;
        new_journal.column = column;
        this.split_or_join(new_journal, false);
        new_journal.next = this.undo_list;
        this.undo_list = new_journal;
        this.redo_list = null;
        this.updateMenus();
        this.updateFrames(line, line + 1);
        this.dirty = true;
    }

    public void join_line(int line, int column) {
        JournalItem new_journal = new JournalItem();
        new_journal.action = 3;
        new_journal.line = line;
        new_journal.column = column;
        this.split_or_join(new_journal, true);
        new_journal.next = this.undo_list;
        this.undo_list = new_journal;
        this.redo_list = null;
        this.updateMenus();
        this.updateFrames(line, line + 1);
        this.dirty = true;
    }

    public void split_or_join(JournalItem i, boolean join) {
        int line = i.line;
        int column = i.column;
        if (join) {
            String s = this.lines.getString(line);
            s = s.concat(this.lines.getString(line + 1));
            this.lines.setString(s, line);
            this.lines.removeElementAt(line + 1);
            this.hilite.lineRemoved(line + 1);
        } else {
            String s = this.lines.getString(line);
            this.lines.setString(s.substring(0, column), line);
            this.lines.insertElementAt(s.substring(column, s.length()), ++line);
        }
    }

    public TextPosition insert_section(int line, int column, String s, boolean update) {
        JournalItem new_journal = new JournalItem();
        new_journal.action = 4;
        new_journal.text = s;
        new_journal.line = line;
        new_journal.column = column;
        TextPosition tp = this.insert(new_journal);
        new_journal.eline = tp.line;
        new_journal.ecolumn = tp.column;
        new_journal.next = this.undo_list;
        this.undo_list = new_journal;
        this.redo_list = null;
        this.updateMenus();
        if (update) {
            this.updateFrames(line, tp.line);
        }
        this.dirty = true;
        return tp;
    }

    public TextPosition insert(JournalItem i) {
        int line = i.line;
        int column = i.column;
        String s = i.text;
        String s2 = null;
        int charMax = s.length();
        int saveCt = 0;
        int charCt = 0;
        while (charCt < charMax) {
            char c = s.charAt(charCt);
            ++charCt;
            if (c != '\r' && c != '\n') continue;
            s2 = this.lines.getString(line);
            this.lines.setString(String.valueOf(s2.substring(0, column)) + s.substring(saveCt, charCt - 1), line);
            this.lines.insertElementAt(s2.substring(column, s2.length()), ++line);
            column = 0;
            if (charCt < charMax) {
                char c2 = s.charAt(charCt);
                if (c == '\r' && c2 == '\n' || c2 != '\r' || c == '\n') {
                    // empty if block
                }
            }
            saveCt = ++charCt;
        }
        if (saveCt < charCt) {
            s2 = this.lines.getString(line);
            s = s.substring(saveCt, charCt);
            s2 = column == 0 ? String.valueOf(s) + s2 : String.valueOf(s2.substring(0, column)) + s + s2.substring(column, s2.length());
            column += s.length();
            this.lines.setString(s2, line);
        }
        return new TextPosition(line, column);
    }

    public String delete_section(int line, int column, int eline, int ecolumn, boolean cut) {
        JournalItem new_journal = new JournalItem();
        new_journal.action = 5;
        new_journal.line = line;
        new_journal.column = column;
        new_journal.eline = eline;
        new_journal.ecolumn = ecolumn;
        String text = this.copy_or_cut(new_journal, cut);
        if (cut) {
            new_journal.text = text;
            new_journal.next = this.undo_list;
            this.undo_list = new_journal;
            this.redo_list = null;
            this.updateMenus();
            this.dirty = true;
        }
        return text;
    }

    private String copy_or_cut(JournalItem i, boolean cut) {
        String text = null;
        int line = i.line;
        int column = i.column;
        int eline = i.eline;
        int ecolumn = i.ecolumn;
        if (line == eline) {
            String s = this.lines.getString(line);
            text = s.substring(column, ecolumn);
            if (cut) {
                s = String.valueOf(s.substring(0, column)) + s.substring(ecolumn, s.length());
                this.lines.setString(s, line);
            }
        } else {
            String s2;
            String s = this.lines.getString(line);
            text = s.substring(column, s.length());
            s = s.substring(0, column);
            int diff = eline - line;
            int k = line + 1;
            int j = 1;
            while (j < diff) {
                s2 = this.lines.getString(k);
                text = String.valueOf(text) + this.lineSeparator + s2;
                if (cut) {
                    this.lines.removeElementAt(k);
                    this.hilite.lineRemoved(k);
                } else {
                    ++k;
                }
                ++j;
            }
            if (k != this.lines.size()) {
                s2 = this.lines.getString(k);
                text = String.valueOf(text) + this.lineSeparator + s2.substring(0, ecolumn);
                s = String.valueOf(s) + s2.substring(ecolumn, s2.length());
                if (cut) {
                    this.lines.removeElementAt(k);
                    this.hilite.lineRemoved(k);
                }
            }
            if (cut) {
                this.lines.setString(s, line);
            }
        }
        return text;
    }

    public String delete_line(int line) {
        JournalItem ji = new JournalItem();
        ji.action = 7;
        ji.line = line;
        ji.column = 0;
        ji.text = this.lines.getString(line);
        ji.ecolumn = ji.text.length();
        ji.text = String.valueOf(ji.text) + '\n';
        ji.next = this.undo_list;
        this.undo_list = ji;
        this.redo_list = null;
        this.lines.removeElementAt(line);
        this.updateMenus();
        this.updateFrames(line, line);
        return ji.text;
    }

    public String clear_line(int line) {
        return this.delete_section(line, 0, line, this.lines.getString(line).length(), true);
    }

    public void insert_line(int after, String txt) {
        this.insert_section(after, 0, String.valueOf(txt) + '\n', true);
    }

    private void internal_swap_lines(int first, int second) {
        LineInfo li = this.lines.getLineInfo(first);
        this.lines.setLineInfo(this.lines.getLineInfo(second), first);
        this.lines.setLineInfo(li, second);
        this.updateFrames(first, second);
    }

    public void swap_lines(int first, int second) {
        JournalItem ji = new JournalItem();
        ji.action = 6;
        ji.line = first;
        ji.eline = second;
        ji.next = this.undo_list;
        this.undo_list = ji;
        this.redo_list = null;
        this.internal_swap_lines(first, second);
        this.updateMenus();
    }
}

