/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.AboutDialog;
import de.uni_paderborn.fujaba.mpEdit.AbstractMpAction;
import de.uni_paderborn.fujaba.mpEdit.ButtonPusher;
import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.FindDialog;
import de.uni_paderborn.fujaba.mpEdit.GotoDialog;
import de.uni_paderborn.fujaba.mpEdit.LineInfo;
import de.uni_paderborn.fujaba.mpEdit.MpAction;
import de.uni_paderborn.fujaba.mpEdit.PropDialog;
import de.uni_paderborn.fujaba.mpEdit.ReplaceDialog;
import de.uni_paderborn.fujaba.mpEdit.Ruler;
import de.uni_paderborn.fujaba.mpEdit.TextCursor;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import de.uni_paderborn.fujaba.mpEdit.TextMenu;
import de.uni_paderborn.fujaba.mpEdit.TextPosition;
import de.uni_paderborn.fujaba.mpEdit.TextScroller;
import de.uni_paderborn.fujaba.mpEdit.mpEDIT;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

final class TextCanvas
extends JComponent
implements MouseMotionListener,
MouseListener,
ComponentListener,
AdjustmentListener,
KeyListener,
FocusListener {
    static final transient Logger log;
    protected final int EDGE = 10;
    protected JScrollBar horiz;
    protected JScrollBar vert;
    protected boolean eactive;
    protected boolean hactive;
    protected boolean mouseDown;
    protected boolean autoIndent = true;
    protected boolean doSeparator = false;
    protected int sx;
    protected int sy;
    protected int ny;
    protected int line;
    protected int column;
    protected int pix;
    protected int eline;
    protected int ecolumn;
    protected int epix;
    protected int oldlines;
    protected int fontHeight;
    protected int fontDescent;
    protected int tabSize;
    protected Font font;
    protected FontMetrics fontMetrics;
    protected Ruler ruler;
    protected TextFrame textFrame;
    protected TextCursor textCursor;
    protected TextMenu textMenu;
    protected Dimension dimension;
    protected DocMan docMan;
    protected mpEDIT mpEdit;
    protected Color textColor;
    protected Color textXColor;
    protected Color commentColor;
    protected Color commentXColor;
    protected Color keywordColor;
    protected Color keywordXColor;
    protected Color quoteColor;
    protected Color quoteXColor;
    protected Color hideColor;
    protected Color hideXColor;
    protected int linesEmpty = 0;
    protected int lastVerticalSize = 10;
    protected TextScroller textScroller = null;
    protected Hashtable actionDictionary;
    final int LINE_MAX = 2000;
    protected boolean gotFocus = false;
    protected int opix;
    protected int oepix;
    protected int oline;
    protected int oeline;
    protected int hpix;
    protected int hepix;
    protected int hline;
    protected int heline;
    protected int hcolumn;
    protected int hecolumn;
    protected int lastx;
    protected int lasty;
    protected int cline;
    protected int ccolumn;
    protected int cpix;
    char[] buffer;
    static Color separatorInsideColor;
    MpAction undoAction = new AbstractMpAction("undo"){

        public void actionPerformed(ActionEvent e) {
            TextCanvas.this.docMan.undo(TextCanvas.this.textFrame);
        }
    };
    MpAction redoAction = new AbstractMpAction("redo"){

        public void actionPerformed(ActionEvent e) {
            TextCanvas.this.docMan.redo(TextCanvas.this.textFrame);
        }
    };
    MpAction copyAction;
    MpAction cutAction;
    private String[] readonlyActions = new String[]{"line-swap", "line-delete", "line-clone", "character-delete-forward", "character-delete-backward", "replace-dialog", "selection-cut", "buffer-paste", "line-break", "document-save", "cursor-forward", "cursor-backward"};
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.mpEdit.TextCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        separatorInsideColor = new Color(160, 0, 0);
    }

    public TextCanvas(mpEDIT mpe, DocMan doc, TextFrame tf, JScrollBar h, JScrollBar v, Ruler r) {
        this.mpEdit = mpe;
        this.docMan = doc;
        this.ruler = r;
        this.createActionDictionary();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.textFrame = tf;
        this.horiz = h;
        this.horiz.addAdjustmentListener(this);
        this.horiz.addKeyListener(this);
        this.vert = v;
        this.vert.addAdjustmentListener(this);
        this.vert.addKeyListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.applyProperties();
        this.clear();
        this.validate();
        this.requestFocus();
        this.textCursor = new TextCursor(this);
        this.textCursor.start();
    }

    public void focusGained(FocusEvent e) {
        this.gotFocus = true;
        this.release_cursor();
    }

    public void focusLost(FocusEvent e) {
        this.pause_cursor();
        this.gotFocus = false;
    }

    public void release_cursor() {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.release_cursor(true);
        }
    }

    public void pause_cursor() {
        if (this.textCursor != null && !this.eactive && this.gotFocus) {
            this.textCursor.pause_cursor(true);
        }
    }

    public void setTextMenu(TextMenu tm) {
        this.textMenu = tm;
    }

    public int getHighest() {
        return this.sy + this.ny - 1;
    }

    public void clear() {
        this.clear_area(null);
        this.eactive = false;
        this.hactive = false;
        this.updateCopyActions(false);
        this.sy = 0;
        this.sx = 0;
        this.column = 0;
        this.line = 0;
        this.oldlines = 0;
        this.pix = 10;
        this.horiz.setValue(0);
        this.vert.setValue(0);
    }

    public void applyProperties() {
        this.font = this.docMan.getFont();
        this.tabSize = this.docMan.getTabSize();
        Graphics g = this.getGraphics();
        if (g != null) {
            this.clear_area(g);
            this.updateFonts(g);
            this.ruler.setTabSize(this.tabSize);
            this.resizeLines();
            this.redoCanvas();
            this.repaint();
            g.dispose();
        } else {
            this.fontMetrics = null;
        }
    }

    protected void clear_area(Graphics g) {
        boolean foobar = false;
        this.pause_cursor();
        if (g == null) {
            g = this.getGraphics();
            foobar = true;
        }
        if (g != null) {
            g.clearRect(0, 0, this.dimension.width, this.dimension.height);
        }
        if (foobar && g != null) {
            g.dispose();
        }
    }

    public void setPos(TextPosition tp) {
        this.eactive = false;
        this.hactive = false;
        this.line = this.eline = tp.line;
        this.column = this.ecolumn = tp.column;
        this.pix = this.epix = this.ruler.length(this.line, this.column) + 10;
        this.shiftVert(this.line);
        this.shiftHoriz(this.pix);
        this.repaint();
    }

    public void Goto(int y) {
        if (--y >= 0 && y < this.docMan.getLineCount()) {
            boolean paint = this.hactive;
            this.eactive = false;
            this.hactive = false;
            this.line = this.eline = y;
            this.ecolumn = 0;
            this.column = 0;
            this.epix = 10;
            this.pix = 10;
            if (this.shiftVert(this.line)) {
                paint = true;
            }
            if (this.shiftHoriz(this.pix)) {
                paint = true;
            }
            if (paint) {
                this.repaint();
            }
        }
    }

    public int getLine() {
        return this.line + 1;
    }

    public void legalizeCursor() {
        String whole;
        int max_column;
        boolean illegal = false;
        int max_line = this.docMan.getLineCount();
        if (this.line >= max_line) {
            this.line = max_line - 1;
            illegal = true;
        }
        if (this.column > (max_column = (whole = this.docMan.getLine(this.line)).length())) {
            this.column = max_column;
            illegal = true;
        }
        if (this.eactive && this.eline >= max_line) {
            illegal = true;
        }
        if (this.eactive && !illegal && this.ecolumn > (max_column = (whole = this.detabbed(this.docMan.getLine(this.eline))).length())) {
            illegal = true;
        }
        if (this.line < 0) {
            this.line = 0;
        }
        if (this.column < 0) {
            this.column = 0;
        }
        if (illegal) {
            this.eactive = false;
            this.hactive = false;
            this.pix = this.epix = this.ruler.length(this.line, this.column) + 10;
            this.shiftVert(this.line);
            this.shiftHoriz(this.pix);
            this.repaint();
        }
    }

    protected void updateFonts(Graphics g) {
        boolean foobar = false;
        if (g == null) {
            g = this.getGraphics();
            foobar = true;
        }
        if (g != null) {
            g.setFont(this.font);
            this.fontMetrics = g.getFontMetrics(this.font);
            this.fontHeight = this.fontMetrics.getHeight();
            this.fontDescent = this.fontMetrics.getDescent();
            this.ruler.setFontMetrics(this.fontMetrics);
            if (foobar) {
                g.dispose();
            }
        }
    }

    public void addSearchPattern(String patt) {
        this.mpEdit.addSearchPattern(patt);
    }

    public String[] getSearchPatterns() {
        return this.mpEdit.getSearchPatterns();
    }

    public String getLatestSearchPattern() {
        return this.mpEdit.getLatestSearchPattern();
    }

    public void findAgain(int direction) {
        String lastFind = this.getLatestSearchPattern();
        if (lastFind == null) {
            this.release_cursor();
        } else {
            this.find(lastFind, direction);
        }
    }

    public boolean find(String pattern) {
        return this.find(pattern, 1);
    }

    public boolean find(String pattern, int direction) {
        this.pause_cursor();
        int max = this.docMan.getLineCount();
        int i = this.line;
        int ct = 0;
        while (ct++ <= max) {
            String whole = this.docMan.getLine(i);
            int from = i == this.line && ct == 1 ? (this.eactive ? this.column + direction : this.column) : (direction > 0 ? 0 : whole.length());
            int start = direction > 0 ? whole.indexOf(pattern, from) : whole.lastIndexOf(pattern, from);
            if (start >= 0) {
                this.line = this.eline = i;
                this.column = start;
                this.pix = this.ruler.length(this.line, this.column) + 10;
                this.ecolumn = start + pattern.length();
                this.epix = this.ruler.length(this.eline, this.ecolumn) + 10;
                this.eactive = true;
                this.setup_h();
                this.save_h();
                this.updateCopyActions(this.eactive);
                this.shiftVert(this.line);
                this.shiftHoriz(this.pix);
                this.shiftHoriz(this.epix);
                this.repaint();
                return true;
            }
            i = direction > 0 ? ++i : --i;
            if (i >= max) {
                i = 0;
                this.showStatus("Search wrapped");
                continue;
            }
            if (i >= 0) continue;
            i = max - 1;
            this.showStatus("Search wrapped");
        }
        this.release_cursor();
        return false;
    }

    public synchronized void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (this.mouseDown) {
            return;
        }
        this.mouseDown = true;
        this.pause_cursor();
        Graphics g = this.getGraphics();
        this.updateFonts(g);
        this.clickPosition(e.getX(), e.getY());
        if (this.cline < 0 || this.cline >= this.docMan.getLineCount()) {
            return;
        }
        this.eline = this.cline;
        this.ecolumn = this.ccolumn;
        this.epix = this.cpix;
        int clickCount = e.getClickCount();
        if (clickCount == 3) {
            this.eline = this.line = this.cline;
            this.column = 0;
            this.pix = 10;
            String whole = this.docMan.getLine(this.cline);
            this.ecolumn = whole.length();
            this.epix = this.ruler.length(this.cline, 10000000) + 10;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            this.updateCopyActions(this.eactive);
            this.repaint();
        } else if (clickCount == 2) {
            this.eline = this.line = this.cline;
            String whole = this.docMan.getLine(this.cline);
            this.column = this.ecolumn = this.ccolumn;
            while (this.column != 0 && Character.isLetterOrDigit(whole.charAt(this.column - 1))) {
                --this.column;
            }
            this.pix = this.ruler.length(this.cline, this.column) + 10;
            int max = whole.length();
            while (this.ecolumn < max && Character.isLetterOrDigit(whole.charAt(this.ecolumn))) {
                ++this.ecolumn;
            }
            this.epix = this.ruler.length(this.cline, this.ecolumn) + 10;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            this.updateCopyActions(this.eactive);
            this.repaint();
        } else if (e.isShiftDown()) {
            this.eline = this.cline;
            this.ecolumn = this.ccolumn;
            this.epix = this.cpix;
            this.eactive = true;
            this.setup_h();
            this.save_h();
            this.updateCopyActions(this.eactive);
            this.repaint();
        } else {
            if (this.hactive) {
                this.flip_h(g, this.oline, this.opix, this.oeline, this.oepix);
            }
            this.eline = this.line = this.cline;
            this.ecolumn = this.column = this.ccolumn;
            this.epix = this.pix = this.cpix;
            this.hactive = false;
            this.eactive = true;
            this.updateCopyActions(this.eactive);
            this.addMouseMotionListener(this);
        }
        this.repaint();
        g.dispose();
    }

    public synchronized void mouseDragged(MouseEvent e) {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.updateFonts(g);
            if (e != null) {
                this.lastx = e.getX();
                this.lasty = e.getY();
            }
            this.clickPosition(this.lastx, this.lasty);
            this.eline = this.cline;
            this.ecolumn = this.ccolumn;
            this.epix = this.cpix;
            boolean bl = this.eactive = this.eline != this.line || this.ecolumn != this.column;
            if (this.eactive || this.hactive) {
                this.setup_h();
                if (this.eline < this.sy || this.eline >= this.sy + this.ny || this.epix < this.sx || this.epix >= this.dimension.width) {
                    if (this.textScroller == null) {
                        this.textScroller = new TextScroller(this);
                        this.textScroller.start();
                    }
                    this.shiftVert(this.eline);
                    this.shiftHoriz(this.epix);
                    this.setup_h();
                    this.save_h();
                    this.docMan.extendHilite(this.sy + this.ny - 1);
                    int i = 0;
                    while (i < this.ny) {
                        this.drawLine(g, this.sy + i);
                        ++i;
                    }
                } else {
                    if (this.textScroller != null) {
                        this.textScroller.setStopThread(true);
                        this.textScroller = null;
                    }
                    if (this.hactive) {
                        if (this.hline < this.oline || this.hline == this.oline && this.hpix < this.opix) {
                            this.flip_h(g, this.hline, this.hpix, this.oline, this.opix);
                        }
                        if (this.hline > this.oline || this.hline == this.oline && this.hpix > this.opix) {
                            this.flip_h(g, this.oline, this.opix, this.hline, this.hpix);
                        }
                        if (this.heline < this.oeline || this.heline == this.oeline && this.hepix < this.oepix) {
                            this.flip_h(g, this.heline, this.hepix, this.oeline, this.oepix);
                        }
                        if (this.heline > this.oeline || this.heline == this.oeline && this.hepix > this.oepix) {
                            this.flip_h(g, this.oeline, this.oepix, this.heline, this.hepix);
                        }
                    } else {
                        this.flip_h(g, this.hline, this.hpix, this.heline, this.hepix);
                    }
                    this.hactive = this.eactive;
                    this.save_h();
                }
            }
            g.dispose();
        }
    }

    void clickPosition(int x, int y) {
        this.cline = y / this.fontHeight + this.sy;
        if (this.cline < 0) {
            this.cpix = 0;
            this.ccolumn = 0;
            this.cline = 0;
            return;
        }
        if (this.cline >= this.docMan.getLineCount()) {
            this.cline = this.docMan.getLineCount() - 1;
            String whole = this.docMan.getLine(this.cline);
            this.ccolumn = whole.length();
            this.cpix = this.ruler.length(this.cline, 10000000) + 10;
            return;
        }
        x = x + this.sx - 10;
        this.cpix = 0;
        this.ccolumn = 0;
        if (x > 0) {
            TextPosition tp = this.ruler.position(this.cline, x);
            this.ccolumn = tp.column;
            this.cpix = tp.pix + 10;
        }
    }

    protected void flip_h(Graphics g, int sline, int spix, int eline, int epix) {
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        if (eline >= this.sy + this.ny) {
            eline = this.sy + this.ny - 1;
            epix = 5000;
        }
        int i = sline;
        while (i <= eline) {
            int by = (i - this.sy) * this.fontHeight;
            int bx = 0;
            int ex = 5000;
            if (i == sline) {
                bx = spix - this.sx;
            }
            if (i == eline) {
                ex = epix - this.sx;
                if (sline == eline) {
                    ex -= bx;
                }
            }
            g.fillRect(bx, by, ex, this.fontHeight);
            ++i;
        }
    }

    protected void setup_h() {
        if (this.line < this.eline || this.line == this.eline && this.column <= this.ecolumn) {
            this.hline = this.line;
            this.hcolumn = this.column;
            this.hpix = this.pix;
            this.heline = this.eline;
            this.hecolumn = this.ecolumn;
            this.hepix = this.epix;
        } else {
            this.hline = this.eline;
            this.hcolumn = this.ecolumn;
            this.hpix = this.epix;
            this.heline = this.line;
            this.hecolumn = this.column;
            this.hepix = this.pix;
        }
    }

    protected void save_h() {
        this.opix = this.hpix;
        this.oepix = this.hepix;
        this.oline = this.hline;
        this.oeline = this.heline;
        this.hactive = this.eactive;
    }

    public void findMatchingBrace(int direction) {
        char opposite;
        char atchar;
        String tmplineStr = this.docMan.getLine(this.line);
        int tmpcolumn = this.column;
        int tmpline = this.line;
        boolean bracesearch = true;
        if (this.column >= tmplineStr.length()) {
            return;
        }
        char nestchar = atchar = tmplineStr.charAt(this.column);
        switch (atchar) {
            case '[': {
                opposite = ']';
                break;
            }
            case ']': {
                opposite = '[';
                break;
            }
            case '(': {
                opposite = ')';
                break;
            }
            case ')': {
                opposite = '(';
                break;
            }
            case '{': {
                opposite = '}';
                break;
            }
            case '}': {
                opposite = '{';
                break;
            }
            default: {
                opposite = atchar;
                nestchar = '\u0000';
                bracesearch = false;
            }
        }
        if (bracesearch) {
            direction = nestchar == '(' || nestchar == '{' || nestchar == '[' ? 1 : -1;
        }
        int nest = 1;
        if (direction < 0) {
            while (true) {
                if (--tmpcolumn < 0) {
                    if (--tmpline < 0) {
                        return;
                    }
                    tmplineStr = this.docMan.getLine(tmpline);
                    tmpcolumn = tmplineStr.length() - 1;
                    if (tmpcolumn < 0) continue;
                }
                if ((atchar = tmplineStr.charAt(tmpcolumn)) == opposite && (!bracesearch || this.docMan.getLineInfo(tmpline).isFreeStanding(tmpcolumn))) {
                    if (--nest != 0) continue;
                    this.line = tmpline;
                    this.column = tmpcolumn;
                    this.cursorAdjust();
                    return;
                }
                if (atchar != nestchar || !this.docMan.getLineInfo(tmpline).isFreeStanding(tmpcolumn)) continue;
                ++nest;
            }
        }
        while (true) {
            if (++tmpcolumn >= tmplineStr.length()) {
                if (++tmpline >= this.docMan.getLineCount()) {
                    return;
                }
                tmplineStr = this.docMan.getLine(tmpline);
                if (tmplineStr.length() == 0) continue;
                tmpcolumn = 0;
            }
            if ((atchar = tmplineStr.charAt(tmpcolumn)) == opposite && (!bracesearch || this.docMan.getLineInfo(tmpline).isFreeStanding(tmpcolumn))) {
                if (--nest != 0) continue;
                this.line = tmpline;
                this.column = tmpcolumn;
                this.cursorAdjust();
                return;
            }
            if (atchar != nestchar || !this.docMan.getLineInfo(tmpline).isFreeStanding(tmpcolumn)) continue;
            ++nest;
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        if (this.textScroller != null) {
            this.textScroller.setStopThread(true);
            this.textScroller = null;
        }
        this.removeMouseMotionListener(this);
        this.eactive = this.eline != this.line || this.ecolumn != this.column;
        this.release_cursor();
        this.updateCopyActions(this.eactive);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        MpAction act;
        int keyModifiers = e.getModifiers();
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (!this.gotFocus) {
            return;
        }
        String s = this.mpEdit.getKeyAction(keyModifiers, keyCode);
        if (s != null && (act = (MpAction)this.actionDictionary.get(s)) != null) {
            e.consume();
            if (!act.isEnabled()) {
                return;
            }
            this.pause_cursor();
            if (s.indexOf("dialog") >= 0) {
                ButtonPusher bp = new ButtonPusher(act);
                bp.start();
            } else {
                act.actionPerformed(null);
            }
            this.release_cursor();
            return;
        }
        if (e.isMetaDown() || e.isControlDown() || e.isAltDown()) {
            return;
        }
        if (this.docMan.isReadOnly()) {
            return;
        }
        this.pause_cursor();
        if (keyChar != '\uffff' && keyCode != 27 && keyChar != '\n' && keyChar != '\b') {
            e.consume();
            if (this.hactive) {
                this.copy(true, false);
            }
            ++this.column;
            this.docMan.insert_char(this.line, this.column - 1, keyChar);
            this.pix = this.ruler.length(this.line, this.column) + 10;
            this.shiftHoriz(this.pix);
            return;
        }
        this.release_cursor();
    }

    public void paste(String s) {
        this.pause_cursor();
        if (this.hactive) {
            this.copy(true, false);
        }
        int oldline = this.line;
        TextPosition tp = this.docMan.insert_section(this.line, this.column, s, false);
        this.line = tp.line;
        this.column = tp.column;
        this.ruler.invalidate(oldline, this.line);
        this.pix = this.ruler.length(this.line, this.column) + 10;
        this.docMan.updateFrames(oldline, this.line);
        boolean paint = oldline != this.line;
        paint = false;
        if (this.shiftVert(this.line)) {
            paint = true;
        }
        if (this.shiftHoriz(this.pix)) {
            paint = true;
        }
        if (paint) {
            this.repaint();
        }
    }

    public String copy(boolean cut, boolean visible) {
        boolean paint = false;
        if (!this.hactive) {
            return null;
        }
        if (this.hline != this.heline) {
            paint = true;
        }
        String s = this.docMan.delete_section(this.hline, this.hcolumn, this.heline, this.hecolumn, cut);
        if (visible) {
            this.docMan.updateFrames(this.hline, this.heline);
        }
        if (cut) {
            this.line = this.hline;
            this.column = this.hcolumn;
            this.eactive = false;
            this.hactive = false;
            if (this.shiftVert(this.line)) {
                paint = true;
            }
            this.pix = this.ruler.length(this.line, this.column) + 10;
            if (this.shiftHoriz(this.pix)) {
                paint = true;
            }
            if (paint) {
                this.repaint();
            } else if (visible) {
                this.linesChanged(this.line, this.line);
            }
        }
        return s;
    }

    protected void cursorAdjust() {
        this.cursorAdjust(false);
    }

    protected void cursorAdjust(boolean force_paint) {
        int max;
        boolean paint = force_paint;
        if (this.eactive) {
            paint = true;
            this.eactive = false;
            this.hactive = false;
            this.updateCopyActions(this.eactive);
        }
        if (this.line < 0) {
            this.line = 0;
        } else {
            max = this.docMan.getLineCount();
            if (this.line >= max) {
                this.line = max - 1;
            }
        }
        if (this.column < 0) {
            this.column = 0;
        } else {
            max = this.docMan.getLine(this.line).length();
            if (this.column > max) {
                this.column = max;
            }
        }
        if (this.shiftVert(this.line)) {
            paint = true;
        }
        this.pix = this.ruler.length(this.line, this.column) + 10;
        if (this.shiftHoriz(this.pix)) {
            paint = true;
        }
        if (paint) {
            this.repaint();
        } else {
            this.release_cursor();
        }
    }

    protected boolean shiftVert(int line) {
        if (line < this.sy) {
            this.sy = line;
            if (this.sy < 0) {
                this.sy = 0;
            }
            this.vert.setValue(this.sy);
            return true;
        }
        if (line >= this.sy + this.ny) {
            this.sy = line - this.ny + 1;
            this.vert.setValue(this.sy);
            this.docMan.extendHilite(this.sy + this.ny - 1);
            return true;
        }
        return false;
    }

    protected boolean shiftHoriz(int x) {
        if (x <= this.sx) {
            this.sx = x - this.dimension.width / 5;
            if (this.sx < 0) {
                this.sx = 0;
            }
            this.horiz.setValue(this.sx);
            return true;
        }
        if (x >= this.sx + this.dimension.width) {
            this.sx = x - this.dimension.width + this.dimension.width / 5;
            this.horiz.setValue(this.sx);
            return true;
        }
        return false;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.redoControls(this.horiz.getValue(), this.vert.getValue(), true);
    }

    public void redoCanvas() {
        this.redoControls(this.horiz.getValue(), this.vert.getValue(), false);
    }

    protected void redoControls(int h, int v, boolean clear) {
        Graphics g = this.getGraphics();
        if (g != null) {
            int maxpix;
            int bubble;
            this.updateFonts(g);
            this.dimension = this.getSize();
            if (clear) {
                this.clear_area(g);
            }
            if ((bubble = this.dimension.width) > (maxpix = 6000)) {
                maxpix = bubble;
            }
            this.horiz.setValues(h, bubble, 0, maxpix);
            int maxline = this.docMan.getLineCount();
            if (maxline <= 0) {
                maxline = 10;
            }
            bubble = this.ny = this.dimension.height / this.fontHeight;
            this.docMan.extendHilite(this.sy + this.ny - 1);
            if (bubble > maxline) {
                bubble = maxline;
            }
            if (v > maxline) {
                v = maxline;
            }
            this.vert.setValues(v, bubble, 0, maxline);
            this.repaint();
            g.dispose();
        }
    }

    protected void resizeLines() {
        if (this.hline >= 0 && this.hline < this.docMan.getLineCount()) {
            this.opix = this.hpix = this.ruler.length(this.hline, this.hcolumn) + 10;
        }
        if (this.heline >= 0 && this.heline < this.docMan.getLineCount()) {
            this.oepix = this.hepix = this.ruler.length(this.heline, this.hecolumn) + 10;
        }
    }

    protected String detabbed(String s) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        String t = "";
        int j = 0;
        int max = s.length();
        int i = 0;
        while (i < max) {
            char c = s.charAt(i);
            if (c == '\t') {
                int tabs = this.tabSize - j % this.tabSize;
                j += tabs;
                while (tabs-- > 0) {
                    t = String.valueOf(t) + ' ';
                }
            } else {
                t = String.valueOf(t) + c;
                ++j;
            }
            ++i;
        }
        return t;
    }

    protected int fillBuffer(LineInfo li) {
        char[] before = li.data.toCharArray();
        int max = before.length;
        int i = 0;
        int j = 0;
        while (i < max) {
            if (before[i] == '\t') {
                ++j;
            }
            ++i;
        }
        if (j == 0) {
            this.buffer = before;
            j = max;
        } else {
            this.buffer = new char[max + j * (this.tabSize - 1)];
            i = 0;
            j = 0;
            while (i < max) {
                char c = before[i];
                if (c == '\t') {
                    int tabs = this.tabSize - j % this.tabSize;
                    while (tabs-- > 0) {
                        this.buffer[j++] = 32;
                    }
                } else {
                    this.buffer[j++] = c;
                }
                ++i;
            }
        }
        return j;
    }

    protected int charsLength(int start, int length) {
        if (this.fontMetrics == null) {
            return -1;
        }
        return this.fontMetrics.charsWidth(this.buffer, start, length);
    }

    public void getCursorPos(Graphics g, Rectangle r) {
        this.updateFonts(g);
        r.width = 2;
        r.height = this.fontHeight;
        r.y = (this.line - this.sy) * r.height;
        r.x = this.column > 0 ? this.ruler.length(this.line, this.column) + 10 - this.sx : 10 - this.sx;
    }

    public String getSelectionOrWordUnderCursor() {
        String str = this.copy(false, false);
        if (str != null) {
            return str;
        }
        int leftBound = this.column;
        int rightBound = this.column;
        String currLine = this.docMan.getLine(this.line);
        int rightMax = currLine.length();
        block6: while (--leftBound >= 0) {
            switch (currLine.charAt(leftBound)) {
                case '\t': 
                case ' ': 
                case '(': 
                case ')': 
                case '.': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    ++leftBound;
                    break block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        if (leftBound < 0) {
            leftBound = 0;
        }
        block7: while (rightBound < rightMax) {
            switch (currLine.charAt(rightBound)) {
                case '\t': 
                case ' ': 
                case '(': 
                case ')': 
                case '.': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    break block7;
                }
                default: {
                    ++rightBound;
                }
            }
        }
        if (rightBound == 0) {
            return "";
        }
        return currLine.substring(leftBound, rightBound);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int temp;
        boolean paint = false;
        this.pause_cursor();
        if (e.getSource() == this.horiz) {
            int temp2 = e.getValue();
            if (temp2 != this.sx) {
                this.sx = temp2;
                this.horiz.setValue(this.sx);
                paint = true;
            }
        } else if (e.getSource() == this.vert && (temp = e.getValue()) != this.sy) {
            this.sy = temp;
            this.vert.setValue(this.sy);
            this.docMan.extendHilite(this.sy + this.ny - 1);
            paint = true;
        }
        if (paint) {
            this.repaint();
        } else {
            this.release_cursor();
        }
    }

    public void linesChanged(int first, int last) {
        if (first > this.sy + this.ny || last < this.sy) {
            return;
        }
        if (first == last) {
            Graphics g = this.getGraphics();
            this.updateFonts(g);
            this.drawLine(g, first);
            g.dispose();
            this.release_cursor();
        } else {
            this.repaint();
        }
    }

    public void updateUndoActions(boolean un, boolean re) {
        this.undoAction.setEnabled(un);
        this.redoAction.setEnabled(re);
    }

    public void updateCopyActions(boolean active) {
        this.cutAction.setEnabled(active);
        this.copyAction.setEnabled(active);
    }

    public void showStatus(String txt) {
        if (log.isInfoEnabled()) {
            log.info((Object)txt);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void getColors() {
        this.textColor = this.docMan.getTextColor();
        this.textXColor = this.docMan.getTextXColor();
        this.commentColor = this.docMan.getCommentColor();
        this.commentXColor = this.docMan.getCommentXColor();
        this.keywordColor = this.docMan.getKeywordColor();
        this.keywordXColor = this.docMan.getKeywordXColor();
        this.quoteColor = this.docMan.getQuoteColor();
        this.quoteXColor = this.docMan.getQuoteXColor();
        this.hideColor = this.docMan.getHideColor();
        this.hideXColor = this.docMan.getHideXColor();
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        this.pause_cursor();
        this.getColors();
        g.setPaintMode();
        this.updateFonts(g);
        int i = this.docMan.getLineCount();
        if (this.oldlines != i) {
            this.oldlines = i;
            this.redoControls(this.horiz.getValue(), this.vert.getValue(), true);
        }
        if (this.dimension == null) {
            this.dimension = this.getSize();
        }
        Rectangle clip = g.getClipBounds();
        Color oldColor = g.getColor();
        g.setColor(Color.white);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(oldColor);
        i = clip.y / this.fontHeight;
        int t = clip.y + clip.height;
        int j = t / this.fontHeight;
        if (t % this.fontHeight == 0) {
            --j;
        }
        if (j >= this.ny) {
            j = this.ny - 1;
        }
        this.linesEmpty = 0;
        this.lastVerticalSize = j;
        i = 0;
        while (i <= j) {
            this.drawLine(g, this.sy + i);
            ++i;
        }
        this.release_cursor();
    }

    protected void drawLineSeparator(Graphics g, int y) {
        int center = y - this.fontHeight - 2;
        g.setColor(separatorInsideColor);
        g.drawLine(3, center, this.dimension.width - 12, center);
        g.setColor(Color.gray);
        g.drawLine(3, center, 6, center + 1);
        g.drawLine(3, center, 6, center - 1);
        g.drawLine(6, center + 1, this.dimension.width - 15, center + 1);
        g.drawLine(6, center - 1, this.dimension.width - 15, center - 1);
        g.drawLine(this.dimension.width - 15, center + 1, this.dimension.width - 12, center);
        g.drawLine(this.dimension.width - 15, center - 1, this.dimension.width - 12, center);
    }

    protected synchronized void drawLine(Graphics g, int i) {
        boolean xor = false;
        int x = 10 - this.sx;
        int y = (i - this.sy + 1) * this.fontHeight;
        int m = this.fontHeight;
        g.setColor(Color.black);
        g.setPaintMode();
        if (i >= this.docMan.getLineCount()) {
            return;
        }
        if (this.hactive && i > this.oline && i < this.oeline) {
            g.fillRect(0, y - this.fontHeight, this.dimension.width, m);
            xor = true;
        } else {
            Color oldColor = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, y - this.fontHeight, this.dimension.width, m);
            g.setColor(oldColor);
        }
        LineInfo hi = this.docMan.getLineInfo(i);
        int max = this.fillBuffer(hi);
        int a = 0;
        int key = 0;
        if (hi.tagColor != null) {
            if (this.hactive && i > this.oline && i < this.oeline) {
                g.setColor(new Color(hi.tagColor.getRGB() ^ 0xFFFFFF));
            } else {
                g.setColor(hi.tagColor);
            }
            g.fillRect(0, y - this.fontHeight, this.dimension.width, m);
        }
        while (a < max) {
            int c;
            int b;
            if (key < hi.keyCt) {
                b = hi.keyStarts[key];
                c = hi.keyEnds[key];
            } else {
                b = max;
                c = max;
            }
            if (b > a) {
                if (xor) {
                    g.setColor(this.textXColor);
                } else {
                    g.setColor(this.textColor);
                }
                g.drawChars(this.buffer, a, b - a, x, y - this.fontDescent);
                x += this.charsLength(a, b - a);
            }
            if (c > b) {
                if (hi.keyTypes[key] >= 100) {
                    a = hi.keyTypes[key] > 100 + this.docMan.getHideLevel() ? max : b;
                    ++key;
                    continue;
                }
                switch (hi.keyTypes[key]) {
                    case 2: {
                        if (xor) {
                            g.setColor(this.commentXColor);
                            break;
                        }
                        g.setColor(this.commentColor);
                        break;
                    }
                    case 1: {
                        if (xor) {
                            g.setColor(this.keywordXColor);
                            break;
                        }
                        g.setColor(this.keywordColor);
                        break;
                    }
                    case 3: {
                        if (xor) {
                            g.setColor(this.quoteXColor);
                            break;
                        }
                        g.setColor(this.quoteColor);
                    }
                }
                g.drawChars(this.buffer, b, c - b, x, y - this.fontDescent);
                x += this.charsLength(b, c - b);
            }
            a = c;
            ++key;
        }
        if (this.doSeparator) {
            this.linesEmpty = max == 0 ? ++this.linesEmpty : 0;
            if (this.linesEmpty == 2) {
                this.drawLineSeparator(g, y);
            }
        }
        if (this.hactive && (i == this.oline || i == this.oeline)) {
            int bx = 0;
            int ex = 5000;
            if (i == this.oline) {
                bx = this.opix - this.sx;
            }
            if (i == this.oeline) {
                ex = this.oepix - this.sx;
                if (this.oline == this.oeline) {
                    ex -= bx;
                }
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.fillRect(bx, y - this.fontHeight, ex, m);
        }
    }

    protected void addToDict(MpAction mpa) {
        this.actionDictionary.put(mpa.getIdString(), mpa);
    }

    public MpAction getMpAction(String id) {
        return (MpAction)this.actionDictionary.get(id);
    }

    protected void createActionDictionary() {
        this.actionDictionary = new Hashtable();
        this.addToDict(this.undoAction);
        this.addToDict(this.redoAction);
        this.addToDict(new AbstractMpAction("line-swap"){

            public void actionPerformed(ActionEvent e) {
                if (TextCanvas.this.docMan.getLineCount() - 1 == TextCanvas.this.line) {
                    return;
                }
                TextCanvas.this.docMan.swap_lines(TextCanvas.this.line, TextCanvas.this.line + 1);
                TextCanvas.this.cursorAdjust(true);
            }
        });
        this.addToDict(new AbstractMpAction("cursor-up"){

            public void actionPerformed(ActionEvent e) {
                --TextCanvas.this.line;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-down"){

            public void actionPerformed(ActionEvent e) {
                ++TextCanvas.this.line;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-forward"){

            public void actionPerformed(ActionEvent e) {
                ++TextCanvas.this.column;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-backward"){

            public void actionPerformed(ActionEvent e) {
                --TextCanvas.this.column;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-word-forward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._wordForward();
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-word-backward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._wordBackward();
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-line-begin"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.column = 0;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-line-end"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.column = TextCanvas.this.docMan.getLine(TextCanvas.this.line).length();
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-page-begin"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.line = TextCanvas.this.sy;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-page-end"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.line = Math.min(TextCanvas.this.docMan.getLineCount() - 1, TextCanvas.this.sy + TextCanvas.this.ny - 1);
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-document-begin"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.line = 0;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("cursor-document-end"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.line = TextCanvas.this.docMan.getLineCount() - 1;
                TextCanvas.this.cursorAdjust();
            }
        });
        this.addToDict(new AbstractMpAction("page-up"){

            public void actionPerformed(ActionEvent e) {
                int offset = TextCanvas.this.line - TextCanvas.this.sy;
                TextCanvas.this.line -= TextCanvas.this.lastVerticalSize;
                TextCanvas.this.shiftVert(Math.max(TextCanvas.this.line - offset, 0));
                TextCanvas.this.cursorAdjust(true);
            }
        });
        this.addToDict(new AbstractMpAction("page-down"){

            public void actionPerformed(ActionEvent e) {
                int offset = TextCanvas.this.line - TextCanvas.this.sy;
                TextCanvas.this.line += TextCanvas.this.lastVerticalSize;
                TextCanvas.this.shiftVert(Math.min(TextCanvas.this.line - offset + TextCanvas.this.ny - 1, TextCanvas.this.docMan.getLineCount() - 1));
                TextCanvas.this.cursorAdjust(true);
            }
        });
        this.addToDict(new AbstractMpAction("find-next-forward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.findAgain(1);
            }
        });
        this.addToDict(new AbstractMpAction("find-next-backward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.findAgain(-1);
            }
        });
        this.addToDict(new AbstractMpAction("brace-match-forward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.findMatchingBrace(1);
            }
        });
        this.addToDict(new AbstractMpAction("brace-match-backward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.findMatchingBrace(-1);
            }
        });
        this.addToDict(new AbstractMpAction("character-delete-forward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._pressedDelete();
            }
        });
        this.addToDict(new AbstractMpAction("character-delete-backward"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._pressedBackspace();
            }
        });
        this.addToDict(new AbstractMpAction("line-break"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._insertNewline();
            }
        });
        this.addToDict(new AbstractMpAction("line-clone"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.insert_line(TextCanvas.this.line, TextCanvas.this.docMan.getLine(TextCanvas.this.line));
                ++TextCanvas.this.line;
                TextCanvas.this.cursorAdjust(true);
            }
        });
        this.addToDict(new AbstractMpAction("line-delete"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this._deleteLine();
            }
        });
        this.addToDict(new AbstractMpAction("document-save"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.fileSave(TextCanvas.this.textFrame);
            }
        });
        this.addToDict(new AbstractMpAction("frame-close"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.closeFrame(TextCanvas.this.textFrame);
            }
        });
        this.addToDict(new AbstractMpAction("mode-autoindent-switch"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.autoIndent = !TextCanvas.this.autoIndent;
                TextCanvas.this.showStatus("Autindentation turned " + (TextCanvas.this.autoIndent ? "ON" : "OFF"));
            }
        });
        this.addToDict(new AbstractMpAction("document-new"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.mpEdit.newDoc();
            }
        });
        this.addToDict(new AbstractMpAction("document-open-dialog"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.mpEdit.openDocDialog(TextCanvas.this.docMan, TextCanvas.this.textFrame);
            }
        });
        this.addToDict(new AbstractMpAction("document-save-as-dialog"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.fileSave(TextCanvas.this.textFrame);
            }
        });
        this.addToDict(new AbstractMpAction("document-print-dialog"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.filePrint(TextCanvas.this.textFrame);
            }
        });
        this.addToDict(new AbstractMpAction("find-dialog"){

            public void actionPerformed(ActionEvent e) {
                String search = TextCanvas.this.getSelectionOrWordUnderCursor();
                if (!search.equals("")) {
                    TextCanvas.this.addSearchPattern(search);
                }
                FindDialog findDialog = new FindDialog(TextCanvas.this.textFrame, TextCanvas.this.textMenu, TextCanvas.this.textMenu.getStrings(), TextCanvas.this.textMenu.getStrings().getString("DialogFind"));
                findDialog.show();
            }
        });
        this.addToDict(new AbstractMpAction("goto-dialog"){

            public void actionPerformed(ActionEvent e) {
                GotoDialog gotoDialog = new GotoDialog(TextCanvas.this.textFrame, TextCanvas.this.textMenu, TextCanvas.this.textMenu.getStrings(), TextCanvas.this.textMenu.getStrings().getString("DialogGoto"));
                gotoDialog.show();
            }
        });
        this.addToDict(new AbstractMpAction("replace-dialog"){

            public void actionPerformed(ActionEvent e) {
                ReplaceDialog replaceDialog = new ReplaceDialog(TextCanvas.this.textFrame, TextCanvas.this.textMenu, TextCanvas.this.textMenu.getStrings(), TextCanvas.this.textMenu.getStrings().getString("DialogReplace"));
                replaceDialog.show();
            }
        });
        this.copyAction = new AbstractMpAction("selection-copy"){

            public void actionPerformed(ActionEvent e) {
                String srcData = TextCanvas.this.copy(false, false);
                if (srcData != null) {
                    StringSelection contents = new StringSelection(srcData);
                    TextCanvas.this.textMenu.getClipboard().setContents(contents, TextCanvas.this.textMenu);
                }
            }
        };
        this.addToDict(this.copyAction);
        this.cutAction = new AbstractMpAction("selection-cut"){

            public void actionPerformed(ActionEvent e) {
                String srcData = TextCanvas.this.copy(true, true);
                if (srcData != null) {
                    StringSelection contents = new StringSelection(srcData);
                    TextCanvas.this.textMenu.getClipboard().setContents(contents, TextCanvas.this.textMenu);
                }
            }
        };
        this.addToDict(this.cutAction);
        this.addToDict(new AbstractMpAction("buffer-paste"){

            public void actionPerformed(ActionEvent e) {
                Transferable content = TextCanvas.this.textMenu.getClipboard().getContents(TextCanvas.this.textMenu);
                if (content != null) {
                    String dstData;
                    try {
                        dstData = (String)content.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception exc) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Could not read clipboard");
                        }
                        return;
                    }
                    TextCanvas.this.paste(dstData);
                }
            }
        });
        this.addToDict(new AbstractMpAction("properties-dialog"){

            public void actionPerformed(ActionEvent e) {
                PropDialog pd = new PropDialog(TextCanvas.this.textFrame, TextCanvas.this.textMenu.getStrings(), TextCanvas.this.docMan, TextCanvas.this.textMenu.getStrings().getString("DialogProps"));
                pd.show();
            }
        });
        this.addToDict(new AbstractMpAction("frame-clone"){

            public void actionPerformed(ActionEvent e) {
                Dimension size = TextCanvas.this.mpEdit.getWindowSize();
                Point place = TextCanvas.this.mpEdit.getPlace(size);
                TextFrame textFrame = TextCanvas.this.docMan.newFrame(place, size);
                TextCanvas.this.docMan.setTitles();
                textFrame.setVisible(true);
            }
        });
        this.addToDict(new AbstractMpAction("help-about-dialog"){

            public void actionPerformed(ActionEvent e) {
                AboutDialog ab = new AboutDialog(TextCanvas.this.textFrame, TextCanvas.this.textMenu.getStrings(), TextCanvas.this.textMenu.getStrings().getString("DialogAbout"));
                ab.show();
            }
        });
        this.addToDict(new AbstractMpAction("keytable-save"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.mpEdit.saveKeytable();
            }
        });
        this.addToDict(new AbstractMpAction("keytable-load"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.mpEdit.loadKeytable();
            }
        });
        this.addToDict(new AbstractMpAction("mode-readonly-switch"){

            public void actionPerformed(ActionEvent e) {
                TextCanvas.this.docMan.setReadOnly(!TextCanvas.this.docMan.isReadOnly());
            }
        });
    }

    void _deleteLine() {
        if (this.docMan.getLineCount() == 1) {
            this.docMan.clear_line(0);
            this.column = 0;
            this.pix = 10;
        } else if (this.docMan.getLineCount() - 1 == this.line) {
            this.docMan.clear_line(this.line);
            --this.line;
        } else {
            this.docMan.delete_line(this.line);
        }
        this.cursorAdjust(true);
    }

    /*
     * Unable to fully structure code
     */
    void _wordForward() {
        skippedWord = false;
        buf = this.docMan.getLine(this.line).toCharArray();
        if (buf.length != 0) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            if (buf[this.column] != ' ' && buf[this.column] != '\t') {
                if (skippedWord) {
                    break;
                }
            } else {
                skippedWord = true;
            }
            ++this.column;
lbl11:
            // 2 sources

            ** while (this.column < buf.length)
        }
lbl12:
        // 2 sources

    }

    void _wordBackward() {
        boolean skippedSpace = false;
        char[] buf = this.docMan.getLine(this.line).toCharArray();
        if (buf.length == 0) {
            return;
        }
        this.column = Math.min(this.column, buf.length - 1);
        if (buf[this.column] != ' ' && buf[this.column] != '\t') {
            --this.column;
        }
        while (this.column >= 0) {
            if (buf[this.column] == ' ' || buf[this.column] == '\t') {
                if (skippedSpace) {
                    ++this.column;
                    break;
                }
            } else {
                skippedSpace = true;
            }
            --this.column;
        }
    }

    void _pressedDelete() {
        if (this.hactive) {
            this.copy(true, true);
            return;
        }
        String s = this.docMan.getLine(this.line);
        int max = s.length();
        if (this.column < max) {
            this.docMan.delete_char(this.line, this.column);
            return;
        }
        if (this.line + 1 < this.docMan.getLineCount()) {
            this.docMan.join_line(this.line, this.column);
            this.repaint();
            return;
        }
    }

    void _pressedBackspace() {
        if (this.hactive) {
            this.copy(true, true);
            return;
        }
        if (this.column > 0) {
            --this.column;
            this.docMan.delete_char(this.line, this.column);
            this.pix = this.ruler.length(this.line, this.column) + 10;
            this.shiftHoriz(this.pix);
            return;
        }
        if (this.line > 0) {
            --this.line;
            String s = this.docMan.getLine(this.line);
            this.column = s.length();
            this.shiftHoriz(this.ruler.length(this.line, 10000000) + 10);
            this.docMan.join_line(this.line, this.column);
            this.shiftVert(this.line);
            this.repaint();
            return;
        }
    }

    void _insertNewline() {
        if (this.hactive) {
            this.copy(true, false);
        }
        this.docMan.split_line(this.line, this.column);
        this.shiftVert(++this.line);
        this.column = 0;
        if (this.autoIndent) {
            char ch;
            int i = 0;
            String prevline = this.docMan.getLine(this.line - 1);
            while (i < prevline.length() && ((ch = prevline.charAt(i)) == ' ' || ch == '\t')) {
                this.docMan.insert_char(this.line, this.column, ch);
                ++this.column;
                ++i;
            }
            this.pix = this.ruler.length(this.line, this.column) + 10;
            this.shiftHoriz(this.pix);
        } else {
            this.pix = 10;
            this.shiftHoriz(0);
        }
        this.repaint();
    }

    public void setReadOnly(boolean readOnly) {
        int max = this.readonlyActions.length;
        int i = 0;
        while (i < max) {
            this.getMpAction(this.readonlyActions[i]).setEnabled(!readOnly);
            ++i;
        }
    }
}

