/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.TextCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class TextCursor
extends Thread {
    private TextCanvas canvas;
    private boolean flash;
    private boolean undraw;
    private Rectangle r;

    public TextCursor(TextCanvas c) {
        this.canvas = c;
        this.r = new Rectangle();
    }

    public void run() {
        while (true) {
            try {
                TextCursor.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sync_draw();
        }
    }

    private synchronized void sync_draw() {
        if (this.flash) {
            this.draw_or_undraw();
        }
    }

    public synchronized void pause_cursor(boolean draw) {
        if (this.undraw) {
            this.draw_or_undraw();
        }
        this.flash = false;
    }

    public synchronized void release_cursor(boolean draw) {
        if (!this.undraw) {
            this.draw_or_undraw();
        }
        this.flash = true;
    }

    private boolean draw_or_undraw() {
        Graphics g = this.canvas.getGraphics();
        if (g != null) {
            if (!this.undraw) {
                this.canvas.getCursorPos(g, this.r);
            }
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            g.drawLine(this.r.x, this.r.y, this.r.x, this.r.y + this.r.height - 1);
            this.undraw = !this.undraw;
            g.dispose();
        }
        return this.undraw;
    }
}

