/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.packagediagrams;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gui.comp.StringCellRenderer;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AddToPackageDiagramDialog
extends FujabaDialog {
    private transient JList jDiagList = new JList();
    private transient PackageDiagram packageDiag;

    public AddToPackageDiagramDialog(JFrame frame, PackageDiagram diagram) {
        super(frame, "Package Diagram Usages", true);
        this.packageDiag = diagram;
        this.guiInit();
        this.unparse();
    }

    private final void guiInit() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.guiWorkPanel(), "Center");
        container.add((Component)this.guiPanelOkCancelHelp(), "South");
        this.jDiagList.setCellRenderer(new MyListCellRenderer());
        this.jDiagList.setModel(new MyListModel());
        this.pack();
    }

    private final JPanel guiWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Select diagram to be added"));
        JScrollPane scroll = new JScrollPane(this.jDiagList);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    public void parse() {
        UMLDiagram diag = (UMLDiagram)this.jDiagList.getSelectedValue();
        if (diag != null) {
            DiagramUsage usage = new DiagramUsage();
            usage.setDiagram(diag);
            this.packageDiag.addToElements(usage);
        }
    }

    class MyListCellRenderer
    extends StringCellRenderer {
        MyListCellRenderer() {
        }

        public void setValue(Object obj) {
            UMLDiagram diag = (UMLDiagram)obj;
            this.setText(diag.getName());
        }
    }

    class MyListModel
    extends DefaultListModel {
        public MyListModel() {
            Iterator iter = UMLProject.get().iteratorOfDiags();
            while (iter.hasNext()) {
                this.addElement(iter.next());
            }
        }
    }
}

