/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.parser;

import de.uni_paderborn.fujaba.parser.Parser;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;

public class ParserManager {
    private static ParserManager theParserManager = null;
    private Parser currentParser;
    private FHashSet parsers;

    private ParserManager() {
    }

    public static ParserManager get() {
        if (theParserManager == null) {
            theParserManager = new ParserManager();
        }
        return theParserManager;
    }

    public boolean setCurrentParser(Parser value) {
        boolean changed = false;
        if (this.currentParser == null && value != null || this.currentParser != null && !this.currentParser.equals(value)) {
            this.currentParser = value;
            changed = true;
        }
        return changed;
    }

    public Parser getCurrentParser() {
        return this.currentParser;
    }

    public boolean addToParsers(Parser value) {
        boolean changed = false;
        if (value != null) {
            if (this.parsers == null) {
                this.parsers = new FHashSet();
            }
            if (changed = this.parsers.add(value)) {
                value.setParserManager(this);
            }
        }
        return changed;
    }

    public Iterator iteratorOfParsers() {
        return this.parsers == null ? FEmptyIterator.get() : this.parsers.iterator();
    }

    public boolean hasInParsers(Parser value) {
        return this.parsers != null && value != null && this.parsers.contains(value);
    }

    public int sizeOfParsers() {
        return this.parsers == null ? 0 : this.parsers.size();
    }

    public boolean removeFromParsers(Parser value) {
        boolean changed = false;
        if (this.parsers != null && value != null && (changed = this.parsers.remove(value))) {
            value.setParserManager(null);
        }
        return changed;
    }

    public void removeAllFromParsers() {
        Iterator iter = this.iteratorOfParsers();
        while (iter.hasNext()) {
            Parser tmpValue = (Parser)iter.next();
            this.removeFromParsers(tmpValue);
        }
    }

    public void removeYou() {
        this.removeAllFromParsers();
        Parser tmpCurrentParser = this.getCurrentParser();
        if (tmpCurrentParser != null) {
            this.setCurrentParser(null);
        }
    }
}

