/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FTreeMap;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ColorsPreferences
extends AbstractPreferences {
    public static final String PROPERTY_PREFIX = "Colors.";
    public static final String PROPERTY_NAMES = "names";
    private static final Vector DEF_CODE_GEN_TARGET_NAME = new Vector();
    public Color DEFAULT_FOREGROUND = Color.black;
    public Color DEFAULT_BACKGROUND;
    public Color DIAGRAM_BACKGROUND = this.DEFAULT_BACKGROUND = Color.white;
    public Color DEFAULT_FOCUSED = Color.decode("2987775");
    public Color DEFAULT_SELECTED = Color.blue;
    public Color DEFAULT_BORDER = this.DEFAULT_FOREGROUND;
    public Color SELECTED_BORDER = this.DEFAULT_SELECTED;
    public Color CREATION;
    public Color ASSIGNMENT = this.CREATION = Color.GREEN.darker();
    public Color DELETION = Color.red;
    public Color OPTIONAL = Color.gray;
    public Color ERROR = Color.red;
    public Color ACTIVITY_BACKGROUND = new Color(255, 255, 240);
    public Color CLASS_BACKGROUND = this.DEFAULT_BACKGROUND;
    public Color STORY_BACKGROUND = new Color(235, 235, 255);
    public Color SELECTION_RECT = Color.lightGray;
    public Color COLLAPSE_ANCHOR = Color.gray;
    public Color EDITOR_BORDER = Color.gray;
    public Color MULTILINK = Color.lightGray;
    private Map colors;
    private static ColorsPreferences options;
    static /* synthetic */ Class class$0;

    private ColorsPreferences(boolean init) {
        if (init) {
            this.setDefaults(true);
            this.load();
        }
    }

    public void setDefaults() {
        this.setDefaults(false);
    }

    private void setDefaults(boolean temporarily) {
        ColorsPreferences defaultOptions = new ColorsPreferences(false);
        Field[] constants = this.getClass().getFields();
        int i = 0;
        while (i < constants.length) {
            Class<?> clazz = constants[i].getType();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("java.awt.Color");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                try {
                    this.setColor(constants[i].getName(), (Color)constants[i].get(defaultOptions));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (!temporarily) {
            this.save();
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().removePropertyChangeListener(propertyName, listener);
    }

    public void setColor(String name, Color color) {
        block7: {
            if (this.colors == null) {
                this.colors = new FTreeMap();
            }
            this.setModified(true);
            this.colors.put(name, color);
            try {
                Field constant = this.getClass().getField(name);
                if (constant == null) break block7;
                Class<?> clazz = constant.getType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.awt.Color");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    constant.set(this, color);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void load() {
        Vector names = PreferencesProperties.get().getVectorSetting("Colors.names", DEF_CODE_GEN_TARGET_NAME);
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Color color = this.getColor(name);
            if (color == null) {
                color = this.getDefaultColor(name);
            }
            color = PreferencesProperties.get().getColorSetting(PROPERTY_PREFIX + name, color);
            this.setColor(name, color);
        }
    }

    private Color getDefaultColor(String name) {
        return name == null ? null : Color.black;
    }

    public void save() {
        Vector<String> names = new Vector<String>();
        Iterator it = this.getColors();
        while (it.hasNext()) {
            String name = (String)it.next();
            PreferencesProperties.get().putSetting(PROPERTY_PREFIX + name, this.getColor(name));
            names.add(name);
        }
        PreferencesProperties.get().putSetting("Colors.names", names);
    }

    public Color getColor(String name) {
        if (this.colors == null) {
            this.colors = new FTreeMap();
        }
        return (Color)this.colors.get(name);
    }

    public Iterator getColors() {
        if (this.colors == null) {
            return FEmptyIterator.get();
        }
        return this.colors.keySet().iterator();
    }

    public static ColorsPreferences get() {
        if (options == null) {
            options = new ColorsPreferences(true);
        }
        return options;
    }
}

