/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.beans.PropertyChangeListener;

public class DebugPreferences
extends AbstractPreferences {
    public static final String PROPERTY_NAME = "Debug.";
    public static final String MODE = "Mode";
    public static final String GENERATED = "SaveGenerated";
    public static final String DEBUG_LEVEL = "DebugLevel";
    public static final boolean DEF_MODE = false;
    public static final boolean DEF_GENERATED = true;
    public static final int DEF_DEBUG_LEVEL = 0;
    public static final int DEBUG_LEVEL_SAVELOAD = 1;
    public static final int DEBUG_LEVEL_CODEGENERATION = 2;
    public static final int DEBUG_LEVEL_DISPLAY = 4;
    public static final int DEBUG_LEVEL_ANALYZING = 8;
    public static final int DEBUG_LEVEL_UML = 16;
    public static final int DEBUG_LEVEL_PARSING = 32;
    public static final int DEBUG_LEVEL_GUI = 64;
    public static final int DEBUG_LEVEL_REMOVEYOU = 128;
    public static final int DEBUG_LEVEL_PLUGINS = 256;
    public static final int DEBUG_LEVEL_ELSE = 512;
    private int debugLevel = -1;
    private static DebugPreferences options;

    protected DebugPreferences() {
    }

    public static synchronized DebugPreferences get() {
        if (options == null) {
            options = new DebugPreferences();
        }
        return options;
    }

    public void setDefaults() {
        PreferencesProperties options = PreferencesProperties.get();
        options.putSetting("Debug.Mode", false);
        options.putSetting("Debug.DebugLevel", 0);
        options.putSetting("Debug.SaveGenerated", true);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().removePropertyChangeListener(propertyName, listener);
    }

    public void setDebugMode(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("Debug.Mode", false) != value) {
            options.putSetting("Debug.Mode", value);
            this.setModified(true);
        }
    }

    public boolean isDebugMode() {
        return PreferencesProperties.get().getBoolSetting("Debug.Mode");
    }

    public void setSaveGenerated(boolean value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getBoolSetting("Debug.SaveGenerated", true) != value) {
            options.putSetting("Debug.SaveGenerated", value);
            this.setModified(true);
        }
    }

    public boolean isSaveGenerated() {
        return PreferencesProperties.get().getBoolSetting("Debug.SaveGenerated");
    }

    public void setDebugLevel(int value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (options.getIntSetting("Debug.DebugLevel", 0) != value) {
            options.putSetting("Debug.DebugLevel", value);
            this.setModified(true);
        }
    }

    public int getDebugLevel() {
        if (this.debugLevel < 0) {
            this.debugLevel = PreferencesProperties.get().getIntSetting("Debug.DebugLevel", 0);
        }
        return this.debugLevel;
    }

    public boolean isSpecificDebugLevel(int value) {
        return (this.getDebugLevel() & value) == value;
    }
}

