/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class IconsPreferences
extends AbstractPreferences {
    public static final String PROPERTY_NAME = "Icons.";
    public static final String CURRENT_DIR = "CurrentDirectory";
    public static final String VIS_ICONS = "VisibilityIcons.";
    public static final String DOBS_CLASSES = "DobsClasses.";
    public static final String PUB_METH = "public method";
    public static final String PUB_FIELD = "public attribute";
    public static final String PROT_METH = "protected method";
    public static final String PROT_FIELD = "protected attribute";
    public static final String PRIV_METH = "private method";
    public static final String PRIV_FIELD = "private attribute";
    public static final String PACK_METH = "package method";
    public static final String PACK_FIELD = "package attribute";
    public static final String USER_FIELD = "user attribute";
    public static final String NO_ENTRY = "no entry";
    public static final String DEF_CURRENT_DIR = System.getProperty("user.home");
    private static boolean visibilityIconsDirty;
    private static IconsPreferences options;
    private Hashtable visibilityIconPaths;

    private IconsPreferences() {
        visibilityIconsDirty = false;
    }

    public static synchronized IconsPreferences get() {
        if (options == null) {
            options = new IconsPreferences();
        }
        return options;
    }

    public synchronized void setDefaults() {
        PreferencesProperties options = PreferencesProperties.get();
        Hashtable<String, String> visIcons = new Hashtable<String, String>();
        visIcons.put(PUB_METH, "de/uni_paderborn/fujaba/app/images/PublicMethod.gif");
        visIcons.put(PROT_METH, "de/uni_paderborn/fujaba/app/images/ProtectedMethod.gif");
        visIcons.put(PRIV_METH, "de/uni_paderborn/fujaba/app/images/PrivateMethod.gif");
        visIcons.put(PACK_METH, "de/uni_paderborn/fujaba/app/images/PackageMethod.gif");
        visIcons.put(PUB_FIELD, "de/uni_paderborn/fujaba/app/images/PublicAttribute.gif");
        visIcons.put(PROT_FIELD, "de/uni_paderborn/fujaba/app/images/ProtectedAttribute.gif");
        visIcons.put(PRIV_FIELD, "de/uni_paderborn/fujaba/app/images/PrivateAttribute.gif");
        visIcons.put(PACK_FIELD, "de/uni_paderborn/fujaba/app/images/PackageAttribute.gif");
        visIcons.put(USER_FIELD, "de/uni_paderborn/fujaba/app/images/UserAttribute.gif");
        options.putSetting(PROPERTY_NAME, VIS_ICONS, visIcons);
        options.putSetting("Icons.VisibilityIcons.CurrentDirectory", DEF_CURRENT_DIR);
        options.putSetting("Icons.DobsClasses.CurrentDirectory", DEF_CURRENT_DIR);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get().removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void putHashtableItem(String key, Hashtable hashtable) {
        PreferencesProperties.get().putSetting(PROPERTY_NAME, key, hashtable);
        this.setModified(true);
        if (key.equals(VIS_ICONS)) {
            this.setVisibilityIconsDirty(true);
        }
    }

    public synchronized Hashtable getHashtableItem(String key) {
        return PreferencesProperties.get().getHashtableSetting(PROPERTY_NAME, key);
    }

    public synchronized void setCurrentDir(String key, String value) {
        PreferencesProperties options = PreferencesProperties.get();
        if (!options.getSetting(PROPERTY_NAME + key + CURRENT_DIR, DEF_CURRENT_DIR).equals(value)) {
            options.putSetting(PROPERTY_NAME + key + CURRENT_DIR, value);
            this.setModified(true);
        }
    }

    public synchronized String getCurrentDir(String key) {
        return PreferencesProperties.get().getSetting(PROPERTY_NAME + key + CURRENT_DIR, DEF_CURRENT_DIR);
    }

    public synchronized void setVisibilityIconsDirty(boolean dirty) {
        visibilityIconsDirty = dirty;
    }

    public synchronized boolean isVisibilityIconsDirty() {
        return visibilityIconsDirty;
    }

    public synchronized ImageIcon getVisibilityIcon(String visibility) {
        ImageResourceManager imgManager = ImageResourceManager.get();
        ImageIcon tmpIcon = null;
        if (this.visibilityIconPaths == null || this.isVisibilityIconsDirty()) {
            this.visibilityIconPaths = this.getHashtableItem(VIS_ICONS);
            this.setVisibilityIconsDirty(false);
        }
        String iconPath = (String)this.visibilityIconPaths.get(visibility);
        tmpIcon = imgManager.getImageIcon("fujaba.core", iconPath);
        return tmpIcon;
    }
}

