/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class GeneralPreferencesPanel
extends PreferencesPanel {
    private JTextField workspaceTextField;
    private JTextField viewFilterTextField;
    private JTextField jdkTextField;
    private JCheckBox jdkIgnored;
    private JCheckBox externalEditorCheckBox;
    JTextField externalEditorTextField;
    JButton extEditorBrowseButton;
    private JTextField tmpDirTextField;
    JCheckBox repositoryCheckBox;
    JCheckBox fprSaveCheckBox;
    JCheckBox recoverCheckBox;
    private JCheckBox createBackupCheckBox;
    private JRadioButton workspaceRadioButton;
    private JRadioButton projectRadioButton;
    private JRadioButton tmpDirRadioButton;
    private JCheckBox parseCommandLinesCheckBox;
    private JComboBox lookAndFeelComboBox;

    public GeneralPreferencesPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        JPanel folderPanel = this.createFolderPanel();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        mainPanel.add((Component)folderPanel, constraints);
        JPanel editorPanel = this.createEditorPanel();
        mainPanel.add((Component)editorPanel, constraints);
        JPanel projectsPanel = this.createProjectPanel();
        constraints.gridwidth = -1;
        mainPanel.add((Component)projectsPanel, constraints);
        JPanel exportFolderPanel = this.createExportFolderPanel();
        constraints.gridwidth = 0;
        mainPanel.add((Component)exportFolderPanel, constraints);
        JPanel processPanel = this.createProcessPanel();
        mainPanel.add((Component)processPanel, constraints);
        JPanel lafPanel = this.createLookAndFeelPanel();
        mainPanel.add((Component)lafPanel, constraints);
        this.add((Component)mainPanel, "North");
    }

    private JPanel createFolderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Folder"));
        panel.setLayout(gridBagLayout);
        JLabel workspaceLabel = new JLabel("Workspace:");
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)workspaceLabel, constraints);
        this.workspaceTextField = new JTextField();
        this.workspaceTextField.setToolTipText("This folder will be used for import/export of source files.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.workspaceTextField, constraints);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener(this.workspaceTextField, 1));
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)browseButton, constraints);
        JLabel tmpDirLabel = new JLabel("Temporary Data:");
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridx = 0;
        constraints.gridy = 1;
        panel.add((Component)tmpDirLabel, constraints);
        this.tmpDirTextField = new JTextField();
        this.tmpDirTextField.setToolTipText("This folder will be used to save temporary data.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.tmpDirTextField, constraints);
        browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener(this.tmpDirTextField, 1));
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)browseButton, constraints);
        JLabel viewFilterLabel = new JLabel("Views Filter:");
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridx = 0;
        constraints.gridy = 2;
        panel.add((Component)viewFilterLabel, constraints);
        this.viewFilterTextField = new JTextField();
        this.viewFilterTextField.setToolTipText("This folder contains the diagram view filters.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.viewFilterTextField, constraints);
        browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener(this.viewFilterTextField, 1));
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)browseButton, constraints);
        JLabel jdkLabel = new JLabel("JDK:");
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridx = 0;
        constraints.gridy = 3;
        panel.add((Component)jdkLabel, constraints);
        this.jdkTextField = new JTextField();
        this.jdkTextField.setToolTipText("This folder contains your JDK.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.jdkTextField, constraints);
        browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener(this.jdkTextField, 1));
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)browseButton, constraints);
        JLabel jdkIgnoreLabel = new JLabel("");
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridx = 0;
        constraints.gridy = 4;
        panel.add((Component)jdkIgnoreLabel, constraints);
        this.jdkIgnored = new JCheckBox("Ignore missing/wrong JDK");
        this.jdkIgnored.setToolTipText("If checked no dialog will be raised to ask for a correct JDK.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.jdkIgnored, constraints);
        return panel;
    }

    private JPanel createEditorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Editor"));
        panel.setLayout(gridBagLayout);
        this.externalEditorCheckBox = new JCheckBox();
        this.externalEditorCheckBox.addActionListener(new UseExtEditorButtonListener());
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(3, 3, 0, 1);
        panel.add((Component)this.externalEditorCheckBox, constraints);
        JLabel useExternalEditorLabel = new JLabel("Use External Editor");
        constraints.insets = new Insets(3, 0, 0, 0);
        constraints.gridx = 1;
        panel.add((Component)useExternalEditorLabel, constraints);
        JLabel externalEditorLabel = new JLabel("Editor:");
        constraints.insets = new Insets(3, 0, 0, 0);
        constraints.gridx = 1;
        constraints.gridy = 1;
        panel.add((Component)externalEditorLabel, constraints);
        this.externalEditorTextField = new JTextField();
        this.externalEditorTextField.setToolTipText("This program will be executed as editor.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 2;
        panel.add((Component)this.externalEditorTextField, constraints);
        this.extEditorBrowseButton = new JButton("Browse");
        this.extEditorBrowseButton.addActionListener(new BrowseButtonListener(this.externalEditorTextField, 2));
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)this.extEditorBrowseButton, constraints);
        return panel;
    }

    private JPanel createProjectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Project"));
        panel.setLayout(gridBagLayout);
        JPanel repositoryPanel = new JPanel();
        repositoryPanel.setLayout(new GridLayout());
        this.repositoryCheckBox = new JCheckBox("Activate Versioning Repository");
        this.repositoryCheckBox.setToolTipText("Repository will be activated for versioning projects (requires restart)");
        repositoryPanel.add(this.repositoryCheckBox);
        this.fprSaveCheckBox = new JCheckBox("though allow FPR Files");
        this.fprSaveCheckBox.setToolTipText("Allow to save as FPR although the versioning repository is activated");
        repositoryPanel.add(this.fprSaveCheckBox);
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)repositoryPanel, constraints);
        this.recoverCheckBox = new JCheckBox("Activate Auto-Recover");
        this.recoverCheckBox.setToolTipText("Auto-Recover enables Fujaba to recover the open project after a program crash");
        this.repositoryCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneralPreferencesPanel.this.recoverCheckBox.setEnabled(GeneralPreferencesPanel.this.repositoryCheckBox.isSelected());
                if (!GeneralPreferencesPanel.this.repositoryCheckBox.isSelected()) {
                    GeneralPreferencesPanel.this.recoverCheckBox.setSelected(false);
                }
                GeneralPreferencesPanel.this.fprSaveCheckBox.setEnabled(GeneralPreferencesPanel.this.repositoryCheckBox.isSelected());
                GeneralPreferencesPanel.this.fprSaveCheckBox.setSelected(!GeneralPreferencesPanel.this.repositoryCheckBox.isSelected());
            }
        });
        panel.add((Component)this.recoverCheckBox, constraints);
        this.createBackupCheckBox = new JCheckBox("Create Backup Files for Project");
        this.createBackupCheckBox.setToolTipText("Files will be saved with *.bak.fpr suffix.");
        constraints.insets = new Insets(0, 3, 3, 3);
        constraints.weighty = 1.0;
        panel.add((Component)this.createBackupCheckBox, constraints);
        return panel;
    }

    private JPanel createExportFolderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Export Folder"));
        panel.setLayout(gridBagLayout);
        this.workspaceRadioButton = new JRadioButton("Export to Workspace Folder");
        this.workspaceRadioButton.setToolTipText("Source code files will be exported to the workspace folder.");
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.workspaceRadioButton, constraints);
        this.projectRadioButton = new JRadioButton("Export to Project Folder");
        this.projectRadioButton.setToolTipText("Source code files will be exported to the project folder.");
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.projectRadioButton, constraints);
        this.tmpDirRadioButton = new JRadioButton("Export to Temporary Folder");
        this.tmpDirRadioButton.setToolTipText("Source code files will be exported to the temporary folder.");
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 3, 3, 3);
        panel.add((Component)this.tmpDirRadioButton, constraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.workspaceRadioButton);
        group.add(this.projectRadioButton);
        group.add(this.tmpDirRadioButton);
        return panel;
    }

    private JPanel createProcessPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Program Execution"));
        panel.setLayout(gridBagLayout);
        this.parseCommandLinesCheckBox = new JCheckBox("Enable Command Line Parsing");
        this.parseCommandLinesCheckBox.setToolTipText("Parse the command line for wildcards when starting programs (e.g. Java Compiler).");
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.parseCommandLinesCheckBox, constraints);
        return panel;
    }

    private JPanel createLookAndFeelPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Look & Feel"));
        panel.setLayout(gridBagLayout);
        JLabel lafLabel = new JLabel("Select Look & Feel:");
        constraints.anchor = 17;
        constraints.gridwidth = -1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)lafLabel, constraints);
        this.lookAndFeelComboBox = new JComboBox();
        this.lookAndFeelComboBox.setToolTipText("Fujaba needs to be restarted for changes to take effect.");
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 1.0;
        panel.add((Component)this.lookAndFeelComboBox, constraints);
        return panel;
    }

    public String getPreferredTabName() {
        return "General";
    }

    public void setPreferences() {
        GeneralPreferences options = GeneralPreferences.get();
        this.workspaceTextField.setText(options.getWorkspaceFolder());
        this.viewFilterTextField.setText(options.getViewFilterFolder());
        this.tmpDirTextField.setText(options.getTemporaryFolder());
        this.jdkTextField.setText(options.getJDKFolder());
        this.jdkIgnored.setSelected(options.isJDKFolderIgnored());
        this.externalEditorCheckBox.setSelected(options.isUseExtEditor());
        this.externalEditorTextField.setText(options.getExternalEditor());
        if (!options.isUseExtEditor()) {
            this.externalEditorTextField.setEnabled(false);
            this.extEditorBrowseButton.setEnabled(false);
        }
        this.repositoryCheckBox.setSelected(options.isRepositoryActivated());
        this.recoverCheckBox.setSelected(options.isRecoverActivated());
        this.fprSaveCheckBox.setSelected(options.isFPRActivated());
        this.createBackupCheckBox.setSelected(options.isCreateProjectBackup());
        this.workspaceRadioButton.setSelected(options.isExportToWorkspaceFolder());
        this.projectRadioButton.setSelected(options.isExportToProjectFolder());
        this.tmpDirRadioButton.setSelected(options.isExportToTemporaryFolder());
        this.parseCommandLinesCheckBox.setSelected(options.isCommandLineParsing());
        UIManager.LookAndFeelInfo[] installedLaFs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < installedLaFs.length) {
            this.lookAndFeelComboBox.addItem(installedLaFs[i].getName());
            ++i;
        }
        this.lookAndFeelComboBox.setSelectedItem(options.getLookAndFeel());
    }

    public void setDefaults() {
        GeneralPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void okPressed() {
        GeneralPreferences options = GeneralPreferences.get();
        options.setWorkspaceFolder(this.workspaceTextField.getText());
        options.setViewFilterFolder(this.viewFilterTextField.getText());
        options.setTemporaryFolder(this.tmpDirTextField.getText());
        options.setJDKFolder(this.jdkTextField.getText());
        options.setJDKFolderIgnored(this.jdkIgnored.isSelected());
        options.setUseExtEditor(this.externalEditorCheckBox.isSelected());
        options.setExternalEditor(this.externalEditorTextField.getText());
        options.setRepositoryActivated(this.repositoryCheckBox.isSelected());
        options.setRecoverActivated(this.recoverCheckBox.isSelected());
        options.setFPRActivated(this.fprSaveCheckBox.isSelected());
        options.setCreateProjectBackup(this.createBackupCheckBox.isSelected());
        options.setExportToWorkspaceFolder(this.workspaceRadioButton.isSelected());
        options.setExportToProjectFolder(this.projectRadioButton.isSelected());
        options.setExportToTemporaryFolder(this.tmpDirRadioButton.isSelected());
        options.setCommandLineParsing(this.parseCommandLinesCheckBox.isSelected());
        options.setLookAndFeel((String)this.lookAndFeelComboBox.getSelectedItem());
    }

    private class UseExtEditorButtonListener
    implements ActionListener {
        UseExtEditorButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            JCheckBox checkBox = (JCheckBox)event.getSource();
            boolean enabled = checkBox.isSelected();
            GeneralPreferencesPanel.this.externalEditorTextField.setEnabled(enabled);
            GeneralPreferencesPanel.this.extEditorBrowseButton.setEnabled(enabled);
        }
    }

    private static class BrowseButtonListener
    implements ActionListener {
        private int selectionMode;
        private JTextField targetTextField;

        public BrowseButtonListener(JTextField targetTextField, int selectionMode) {
            this.targetTextField = targetTextField;
            this.selectionMode = selectionMode;
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File(System.getProperty("user.dir"), "*.*");
            JFileChooser fileChooser = new JFileChooser(file);
            fileChooser.setFileSelectionMode(this.selectionMode);
            if (fileChooser.showOpenDialog(FrameMain.get().getFrame()) == 0 && (file = fileChooser.getSelectedFile()).exists()) {
                this.targetTextField.setText(file.getPath());
            }
        }
    }
}

