/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.preferences.IconsPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.java.io.FileComparator;
import de.uni_paderborn.lib.java.io.GIFJPGFileFilter;
import de.upb.tools.fca.FCollections;
import de.upb.tools.fca.FLinkedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconsPreferencesPanel
extends PreferencesPanel {
    private String tabName;
    private String key;
    Hashtable correlation;
    JComboBox chooserComboBox;
    JTextField iconTextField;
    ImagePreview imagePreview;
    JTextField dirLabel;
    JList iconList;
    FilesListModel filesListModel;
    File currentDir;

    public IconsPreferencesPanel(String tabName, String key) {
        this.tabName = tabName;
        this.key = key;
        this.iconTextField = new JTextField(25);
        this.iconTextField.setEditable(false);
        IconsPreferences options = IconsPreferences.get();
        this.correlation = options.getHashtableItem(key);
        this.currentDir = new File(options.getCurrentDir(key));
        if (!this.currentDir.isDirectory()) {
            this.currentDir = new File(System.getProperty("user.home"));
        }
        this.dirLabel = new JTextField(this.currentDir.getPath(), 25);
        this.dirLabel.setEditable(false);
        this.filesListModel = new FilesListModel();
        this.imagePreview = new ImagePreview();
        this.iconList = new JList(this.filesListModel);
        this.chooserComboBox = new JComboBox();
        this.chooserComboBox.addActionListener(new ComboBoxListener());
        Enumeration enumeration = this.correlation.keys();
        while (enumeration.hasMoreElements()) {
            this.chooserComboBox.addItem(enumeration.nextElement());
        }
        this.setLayout(new GridLayout(0, 2));
        JPanel leftPanel = this.createLeftPanel();
        this.add(leftPanel);
        JPanel rightPanel = this.createRightPanel();
        this.add(rightPanel);
    }

    protected JPanel createLeftPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        JPanel chooserPanel = new JPanel();
        chooserPanel.setBorder(new TitledBorder("Current settings"));
        chooserPanel.setLayout(new GridLayout(2, 0));
        chooserPanel.add(this.chooserComboBox);
        chooserPanel.add(this.iconTextField);
        constraints.gridwidth = 0;
        constraints.fill = 1;
        gridBag.setConstraints(chooserPanel, constraints);
        panel.add(chooserPanel);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BorderLayout());
        iconPanel.setBorder(new TitledBorder("Current selected image"));
        iconPanel.add("Center", this.imagePreview);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        gridBag.setConstraints(iconPanel, constraints);
        panel.add(iconPanel);
        return panel;
    }

    protected JPanel createRightPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        this.iconList.addListSelectionListener(this.imagePreview);
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.getViewport().setScrollMode(2);
        listScrollPane.getViewport().add(this.iconList);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        listPanel.setBorder(new TitledBorder("Directory listing"));
        listPanel.add((Component)this.dirLabel, "North");
        listPanel.add((Component)listScrollPane, "Center");
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        gridBag.setConstraints(listPanel, constraints);
        panel.add(listPanel);
        JButton dirButton = new JButton("Change directory");
        dirButton.addActionListener(new DirButtonListener());
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        gridBag.setConstraints(dirButton, constraints);
        panel.add(dirButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 2));
        JButton setButton = new JButton("Set icon");
        setButton.addActionListener(new SetButtonListener());
        buttonPanel.add(setButton);
        JButton removeButton = new JButton("Remove icon");
        removeButton.addActionListener(new RemoveButtonListener());
        buttonPanel.add(removeButton);
        constraints.gridwidth = 0;
        gridBag.setConstraints(buttonPanel, constraints);
        panel.add(buttonPanel);
        return panel;
    }

    public String getPreferredTabName() {
        return this.tabName;
    }

    public void setDefaults() {
        IconsPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        String iconName;
        IconsPreferences options = IconsPreferences.get();
        this.correlation = options.getHashtableItem(this.key);
        this.currentDir = new File(options.getCurrentDir(this.key));
        if (!this.currentDir.isDirectory()) {
            this.currentDir = new File(System.getProperty("user.home"));
        }
        this.dirLabel.setText(this.currentDir.getPath());
        Object item = this.chooserComboBox.getSelectedItem();
        if (item != null && (iconName = (String)this.correlation.get(item.toString())) != null && !iconName.equals("no entry")) {
            this.iconTextField.setText(iconName);
        }
    }

    public void okPressed() {
        IconsPreferences options = IconsPreferences.get();
        Enumeration enumeration = this.correlation.keys();
        while (enumeration.hasMoreElements()) {
            Object tmpKey = enumeration.nextElement();
            if (!this.correlation.get(tmpKey).equals("no entry")) continue;
            this.correlation.remove(tmpKey);
        }
        options.putHashtableItem(this.key, this.correlation);
        options.setCurrentDir(this.key, this.currentDir.toString());
    }

    private class DirButtonListener
    implements ActionListener {
        DirButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            File dir;
            JFileChooser fileChooser = new JFileChooser(IconsPreferencesPanel.this.currentDir);
            fileChooser.setFileSelectionMode(1);
            int value = fileChooser.showDialog(null, "Choose directory");
            if (value == 0 && (dir = fileChooser.getSelectedFile()).isDirectory()) {
                IconsPreferencesPanel.this.currentDir = dir;
                IconsPreferencesPanel.this.filesListModel.update();
            }
        }
    }

    private class FilesListModel
    extends AbstractListModel {
        private FLinkedList files = new FLinkedList();

        public FilesListModel() {
            this.update();
        }

        public void update() {
            GIFJPGFileFilter filter = GIFJPGFileFilter.get();
            Object[] fileArray = IconsPreferencesPanel.this.currentDir.listFiles(filter);
            if (fileArray != null && fileArray.length > 0) {
                this.files = new FLinkedList(fileArray);
                FCollections.sort(this.files, FileComparator.get());
                IconsPreferencesPanel.this.dirLabel.setText(IconsPreferencesPanel.this.currentDir.getPath());
            } else {
                if (this.files != null) {
                    this.files.clear();
                }
                IconsPreferencesPanel.this.dirLabel.setText("");
            }
            IconsPreferencesPanel.this.dirLabel.validate();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Object getElementAt(int index) {
            return this.files.get(index);
        }

        public int getSize() {
            return this.files.size();
        }
    }

    private class ImagePreview
    extends JComponent
    implements ListSelectionListener {
        private ImageIcon thumbnail;
        private String pathName;

        ImagePreview() {
        }

        public void loadImage() {
            if (this.pathName != null && !this.pathName.equals("no entry")) {
                this.thumbnail = ImageResourceManager.get().getImageIcon("fujaba.core", this.pathName);
                if (this.thumbnail != null && (this.thumbnail.getIconWidth() > this.getSize().width || this.thumbnail.getIconHeight() > this.getSize().height)) {
                    this.thumbnail = this.thumbnail.getIconWidth() > this.thumbnail.getIconHeight() ? new ImageIcon(this.thumbnail.getImage().getScaledInstance(this.getSize().width, -1, 1)) : new ImageIcon(this.thumbnail.getImage().getScaledInstance(-1, this.getSize().height, 1));
                }
            }
        }

        public void valueChanged(String pathName) {
            this.pathName = pathName;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            JList list = (JList)e.getSource();
            if (list.getSelectedValue() == null) {
                return;
            }
            this.pathName = ((File)list.getSelectedValue()).getAbsolutePath();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }

        public void paint(Graphics g) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int x = this.getInsets().left + (this.getWidth() - this.getInsets().left - this.getInsets().right - this.thumbnail.getIconWidth()) / 2;
                int y = this.getInsets().top + (this.getHeight() - this.getInsets().top - this.getInsets().bottom - this.thumbnail.getIconHeight()) / 2;
                this.thumbnail.paintIcon(this, g, x, y);
            }
        }
    }

    private class ComboBoxListener
    implements ActionListener {
        ComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            String iconName = (String)IconsPreferencesPanel.this.correlation.get(comboBox.getSelectedItem().toString());
            if (!iconName.equals("no entry")) {
                IconsPreferencesPanel.this.iconTextField.setText(iconName);
            } else {
                IconsPreferencesPanel.this.iconTextField.setText("");
            }
            IconsPreferencesPanel.this.imagePreview.valueChanged(iconName);
            IconsPreferencesPanel.this.iconList.clearSelection();
        }
    }

    private class SetButtonListener
    implements ActionListener {
        SetButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            File selectedIcon = (File)IconsPreferencesPanel.this.iconList.getSelectedValue();
            if (selectedIcon != null) {
                String pathName = selectedIcon.getAbsolutePath();
                Object item = IconsPreferencesPanel.this.chooserComboBox.getSelectedItem();
                if (item != null) {
                    IconsPreferencesPanel.this.correlation.put(item.toString(), pathName);
                    IconsPreferencesPanel.this.iconTextField.setText(pathName);
                }
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        RemoveButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object item = IconsPreferencesPanel.this.chooserComboBox.getSelectedItem();
            if (item != null) {
                IconsPreferencesPanel.this.correlation.put(item.toString(), "no entry");
                IconsPreferencesPanel.this.iconTextField.setText("");
            }
        }
    }
}

