/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.logging.LoggerInfo;
import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.gui.FujabaPreferencesDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LoggerTree
extends JTree {
    static final Logger logger;
    JPopupMenu popup;
    JMenu recursiveLevels;
    List nonRoot = new Vector();
    List toDelete = new Vector();
    Map iconMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.preferences.gui.LoggerTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public LoggerTree(Map theIconMap) {
        this.iconMap = theIconMap;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("iconMap == null? " + (this.iconMap == null)));
        }
        this.loadTree();
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                LoggerInfo loggerInfo = (LoggerInfo)node.getUserObject();
                String level = loggerInfo.getLevel();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("iconMap == null? " + (LoggerTree.this.iconMap == null)));
                }
                this.setIcon((Icon)LoggerTree.this.iconMap.get(level));
                this.setToolTipText("Right click to bring up an options menu");
                return this;
            }
        });
        this.initialiseMenu();
        this.addMouseListener(new PopupListener());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void loadTree() {
        this.toDelete = new Vector();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(LoggingPreferences.get().getRootLogger());
        this.addLoggers(root);
        this.setModel(new DefaultTreeModel(root));
        this.getSelectionModel().setSelectionMode(1);
    }

    private void initialiseMenu() {
        this.popup = new JPopupMenu();
        JMenu individualLevels = new JMenu("Set level for this logger");
        individualLevels.add(new LevelSetterItem("Off", false));
        individualLevels.add(new LevelSetterItem("Fatal", false));
        individualLevels.add(new LevelSetterItem("Error", false));
        individualLevels.add(new LevelSetterItem("Warn", false));
        individualLevels.add(new LevelSetterItem("Info", false));
        individualLevels.add(new LevelSetterItem("Debug", false));
        LevelSetterItem individualInherited = new LevelSetterItem("Inherited", false);
        individualLevels.add(individualInherited);
        this.nonRoot.add(individualInherited);
        this.popup.add(individualLevels);
        this.recursiveLevels = new JMenu("Set level for this logger and all descendants");
        this.recursiveLevels.add(new LevelSetterItem("Off", true));
        this.recursiveLevels.add(new LevelSetterItem("Fatal", true));
        this.recursiveLevels.add(new LevelSetterItem("Error", true));
        this.recursiveLevels.add(new LevelSetterItem("Warn", true));
        this.recursiveLevels.add(new LevelSetterItem("Info", true));
        this.recursiveLevels.add(new LevelSetterItem("Debug", true));
        LevelSetterItem recursiveInherited = new LevelSetterItem("Inherited", true);
        this.recursiveLevels.add(recursiveInherited);
        this.nonRoot.add(recursiveInherited);
        this.popup.add(this.recursiveLevels);
        this.popup.addSeparator();
        JMenuItem addLoggerItem = new JMenuItem("Add a logger...");
        addLoggerItem.addActionListener(this.getAddLoggerListener());
        this.popup.add(addLoggerItem);
        JMenuItem deleteLoggerItem = new JMenuItem("Delete logger");
        deleteLoggerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)LoggerTree.this.getModel();
                DefaultMutableTreeNode rootLogger = (DefaultMutableTreeNode)model.getRoot();
                DefaultMutableTreeNode currentLogger = (DefaultMutableTreeNode)LoggerTree.this.getLastSelectedPathComponent();
                String name = ((LoggerInfo)currentLogger.getUserObject()).getName();
                int areYouSure = JOptionPane.showConfirmDialog(FujabaPreferencesDialog.get(), "Are you sure you want to delete logger '" + name + "'?", "Really delete logger?", 0, 2);
                if (areYouSure == 0) {
                    currentLogger.removeFromParent();
                    while (currentLogger.getChildCount() > 0) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)currentLogger.getFirstChild();
                        LoggerTree.this.placeNodeInTree(child, rootLogger);
                    }
                    LoggerTree.this.toDelete.add(name);
                    model.reload();
                }
            }
        });
        this.nonRoot.add(deleteLoggerItem);
        this.popup.add(deleteLoggerItem);
    }

    public void updateOptions() {
        Iterator deletables = this.toDelete.iterator();
        while (deletables.hasNext()) {
            String deleteMe = (String)deletables.next();
            LoggingPreferences.get().deleteLogger(deleteMe);
        }
        this.toDelete = new Vector();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> nodes = rootNode.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodes.nextElement();
            LoggerInfo currentInfo = (LoggerInfo)currentNode.getUserObject();
            if (currentNode == rootNode) {
                LoggingPreferences.get().updateRootLogger(currentInfo);
                continue;
            }
            LoggingPreferences.get().updateLogger(currentInfo);
        }
    }

    private void addLoggers(DefaultMutableTreeNode root) {
        Collection loggers = LoggingPreferences.get().getLoggers();
        Iterator iter = loggers.iterator();
        while (iter.hasNext()) {
            LoggerInfo loggerInfo = (LoggerInfo)iter.next();
            DefaultMutableTreeNode loggerNode = new DefaultMutableTreeNode(loggerInfo);
            this.placeNodeInTree(loggerNode, root);
        }
    }

    void placeNodeInTree(DefaultMutableTreeNode insertee, DefaultMutableTreeNode parent) {
        LoggerInfo currentInfo;
        DefaultMutableTreeNode currentNode;
        LoggerInfo inserteeInfo = (LoggerInfo)insertee.getUserObject();
        boolean success = false;
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            currentNode = (DefaultMutableTreeNode)children.nextElement();
            currentInfo = (LoggerInfo)currentNode.getUserObject();
            if (!inserteeInfo.getName().startsWith(String.valueOf(currentInfo.getName()) + ".")) continue;
            this.placeNodeInTree(insertee, currentNode);
            success = true;
        }
        if (!success) {
            int i = 0;
            while (i < parent.getChildCount()) {
                currentNode = (DefaultMutableTreeNode)parent.getChildAt(i);
                currentInfo = (LoggerInfo)currentNode.getUserObject();
                if (inserteeInfo.getName().compareTo(currentInfo.getName()) < 0) break;
                ++i;
            }
            parent.insert(insertee, i);
            int j = 0;
            while (j < parent.getChildCount()) {
                DefaultMutableTreeNode currentNode2 = (DefaultMutableTreeNode)parent.getChildAt(j);
                LoggerInfo currentInfo2 = (LoggerInfo)currentNode2.getUserObject();
                if (currentInfo2.getName().startsWith(String.valueOf(inserteeInfo.getName()) + ".")) {
                    this.placeNodeInTree(currentNode2, insertee);
                    continue;
                }
                ++j;
            }
        }
    }

    void setLoggerLevel(DefaultMutableTreeNode logger, String level, boolean recursive) {
        LoggerInfo loggerInfo = (LoggerInfo)logger.getUserObject();
        loggerInfo.setLevel(level);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeChanged(logger);
        if (recursive) {
            Enumeration<TreeNode> children = logger.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                this.setLoggerLevel(child, level, recursive);
            }
        }
    }

    public ActionListener getAddLoggerListener() {
        return new AddLoggerListener();
    }

    class PopupListener
    extends MouseAdapter {
        boolean gotSomething = false;

        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            TreePath selPath = LoggerTree.this.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                LoggerTree.this.setSelectionPath(selPath);
                this.gotSomething = true;
                this.maybeShowPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
            this.gotSomething = false;
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.gotSomething) {
                DefaultMutableTreeNode currentLogger = (DefaultMutableTreeNode)LoggerTree.this.getLastSelectedPathComponent();
                boolean root = currentLogger.isRoot();
                Iterator nonRootItems = LoggerTree.this.nonRoot.iterator();
                while (nonRootItems.hasNext()) {
                    ((JComponent)nonRootItems.next()).setEnabled(!root);
                }
                LoggerTree.this.recursiveLevels.setEnabled(!currentLogger.isLeaf());
                LoggerTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class LevelSetterItem
    extends JMenuItem {
        String level;
        boolean recursive;

        public LevelSetterItem(String theLevel, boolean recurse) {
            super(theLevel);
            this.level = theLevel;
            this.recursive = recurse;
            this.setIcon((Icon)LoggerTree.this.iconMap.get(this.level));
            this.addActionListener(new ActionListener(this){
                final /* synthetic */ LevelSetterItem this$1;
                {
                    this.this$1 = levelSetterItem;
                }

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode logger = (DefaultMutableTreeNode)LevelSetterItem.access$0(this.this$1).getLastSelectedPathComponent();
                    if (logger != null) {
                        LevelSetterItem.access$0(this.this$1).setLoggerLevel(logger, this.this$1.level, this.this$1.recursive);
                    }
                }
            });
        }

        static /* synthetic */ LoggerTree access$0(LevelSetterItem levelSetterItem) {
            return levelSetterItem.LoggerTree.this;
        }
    }

    class AddLoggerListener
    implements ActionListener {
        AddLoggerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String loggerName;
            String currentLoggerName = null;
            DefaultMutableTreeNode currentLogger = (DefaultMutableTreeNode)LoggerTree.this.getLastSelectedPathComponent();
            if (currentLogger != null && !currentLogger.isRoot()) {
                LoggerInfo info = (LoggerInfo)currentLogger.getUserObject();
                currentLoggerName = info.getName();
            }
            if ((loggerName = (String)JOptionPane.showInputDialog(FujabaPreferencesDialog.get(), "Enter the name of the logger:", "Add a logger", 3, null, null, currentLoggerName)) != null) {
                if (!LoggingPreferences.get().isValidLoggerName(loggerName)) {
                    JOptionPane.showMessageDialog(FujabaPreferencesDialog.get(), "'" + loggerName + "' is not a valid logger name.", "Invalid logger name", 0);
                } else {
                    boolean alreadyThere = false;
                    DefaultTreeModel model = (DefaultTreeModel)LoggerTree.this.getModel();
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                    Enumeration<TreeNode> nodes = root.depthFirstEnumeration();
                    while (nodes.hasMoreElements()) {
                        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodes.nextElement();
                        LoggerInfo currentInfo = (LoggerInfo)currentNode.getUserObject();
                        if (!currentInfo.getName().equals(loggerName)) continue;
                        JOptionPane.showMessageDialog(FujabaPreferencesDialog.get(), "There is already a logger with the name '" + loggerName + "'.", "Invalid logger name", 0);
                        alreadyThere = true;
                        break;
                    }
                    if (!alreadyThere) {
                        LoggerInfo loggerInfo = new LoggerInfo(loggerName, "Inherited");
                        DefaultMutableTreeNode loggerNode = new DefaultMutableTreeNode(loggerInfo);
                        LoggerTree.this.placeNodeInTree(loggerNode, root);
                        model.reload();
                        TreePath toNewNode = new TreePath(loggerNode.getPath());
                        LoggerTree.this.setSelectionPath(toNewNode);
                    }
                }
            }
        }
    }
}

