/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.SchemaFilter;
import de.uni_paderborn.fujaba.logging.LoggerInfo;
import de.uni_paderborn.fujaba.logging.LoggingConfigException;
import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.gui.AppenderPanel;
import de.uni_paderborn.fujaba.preferences.gui.LoggerTree;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.upb.lib.html.HtmlDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class LoggingPreferencesPanel
extends PreferencesPanel {
    private static final Logger logger;
    private JPanel mainPanel;
    private JButton addButton = new JButton("Add a logger...");
    private JScrollPane treeScroller = new JScrollPane();
    private LoggerTree loggerTree;
    private List appenderPanels = new Vector();
    private Map iconMap = new Hashtable(7);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.preferences.gui.LoggingPreferencesPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public LoggingPreferencesPanel() {
        this.initialiseIcons();
        this.setLayout(new BorderLayout());
        this.mainPanel = this.createMainPanel();
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.createBottomPanel(), "South");
    }

    public String getPreferredTabName() {
        return "Logging";
    }

    public void setPreferences() {
        if (!this.checkValidConfig()) {
            return;
        }
        if (this.loggerTree == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("iconMap == null? " + (this.iconMap == null)));
            }
            this.loggerTree = new LoggerTree(this.iconMap);
            this.addButton.addActionListener(this.loggerTree.getAddLoggerListener());
            this.treeScroller.setViewportView(this.loggerTree);
        } else {
            this.loggerTree.loadTree();
        }
        Iterator iter = this.appenderPanels.iterator();
        while (iter.hasNext()) {
            AppenderPanel panel = (AppenderPanel)iter.next();
            try {
                panel.setOptions();
            }
            catch (NullPointerException e) {
                System.err.println("The appender " + panel.getConfigName() + " could not be initialized - try to load default values for logging to fix this problem");
            }
        }
    }

    public void setDefaults() {
        LoggingPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void okPressed() {
        LoggingPreferences options = LoggingPreferences.get();
        if (!this.checkValidConfig()) {
            return;
        }
        this.loggerTree.updateOptions();
        Iterator iter = this.appenderPanels.iterator();
        while (iter.hasNext()) {
            AppenderPanel panel = (AppenderPanel)iter.next();
            panel.updateOptions();
        }
        options.configureLog4J();
    }

    private void initialiseIcons() {
        String[] imageNames = new String[]{"inherited-grey.gif", "debug-blue.gif", "info-green.gif", "warn-yellow.gif", "error-orange.gif", "fatal-red.gif", "off-black.gif"};
        Class<?> clazz = this.getClass();
        String iconsDir = "/de/uni_paderborn/fujaba/logging/images/";
        int i = 0;
        while (i < imageNames.length) {
            URL url = clazz.getResource(String.valueOf(iconsDir) + imageNames[i]);
            if (url != null) {
                this.iconMap.put(LoggerInfo.LEVELS[i], new ImageIcon(url));
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Icons initialised; iconMap = " + this.iconMap));
        }
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        GridLayout grid = new GridLayout(1, 2);
        mainPanel.setLayout(grid);
        JPanel loggerPanel = this.createLoggerPanel();
        mainPanel.add(loggerPanel);
        JPanel appendersPanel = this.createAppendersPanel();
        mainPanel.add(appendersPanel);
        return mainPanel;
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 4));
        JPanel loadFilePanel = new JPanel();
        JButton loadFileButton = new JButton("Load config file...");
        loadFileButton.addActionListener(new LoadFileListener());
        loadFilePanel.add(loadFileButton);
        bottomPanel.add(loadFilePanel);
        JPanel applyConfigPanel = new JPanel();
        JButton applyConfigButton = new JButton("Apply configuration");
        applyConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoggingPreferencesPanel.this.okPressed();
            }
        });
        applyConfigPanel.add(applyConfigButton);
        bottomPanel.add(applyConfigPanel);
        JPanel testMsgsPanel = new JPanel();
        JButton testMsgsButton = new JButton("Generate test messages");
        testMsgsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoggingPreferencesPanel.this.checkValidConfig();
                LoggingPreferences.get().generateTestMsgs();
            }
        });
        testMsgsPanel.add(testMsgsButton);
        bottomPanel.add(testMsgsPanel);
        JPanel helpBoxPanel = new JPanel();
        JButton helpButton = new JButton("Help!");
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String helpFile = "/de/uni_paderborn/fujaba/logging/logginghelp.html";
                URL url = this.getClass().getResource(helpFile);
                if (url != null) {
                    HtmlDialog html = new HtmlDialog(FrameMain.get(), url, "Help - Fujaba Logging", true);
                    html.getHtmlPanel().setNavigationBarButtonEnablity(false, false, false);
                    html.show();
                } else {
                    JOptionPane.showMessageDialog(LoggingPreferencesPanel.this, "Unable to locate help file " + helpFile, "Error loading help file", 0);
                }
            }
        });
        helpBoxPanel.add(helpButton);
        bottomPanel.add(helpBoxPanel);
        return bottomPanel;
    }

    private JPanel createLoggerPanel() {
        JPanel loggerPanel = new JPanel();
        loggerPanel.setLayout(new BorderLayout());
        loggerPanel.setBorder(new TitledBorder("Loggers"));
        loggerPanel.add((Component)this.treeScroller, "Center");
        JPanel addPanel = new JPanel();
        addPanel.add(this.addButton);
        loggerPanel.add((Component)addPanel, "South");
        return loggerPanel;
    }

    private JPanel createAppendersPanel() {
        JPanel containerPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        JPanel panel = new JPanel();
        scrollPane.setViewportView(panel);
        containerPanel.add(scrollPane);
        containerPanel.setBorder(new TitledBorder("Appenders"));
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        AppenderPanel consolePanel = new AppenderPanel("Console output", "Console");
        AppenderPanel errorConsolePanel = new AppenderPanel("Error console output", "ErrorConsole");
        consolePanel.addPatternField();
        errorConsolePanel.addPatternField();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        gridBag.setConstraints(consolePanel, constraints);
        gridBag.setConstraints(errorConsolePanel, constraints);
        panel.add(consolePanel);
        panel.add(errorConsolePanel);
        this.appenderPanels.add(consolePanel);
        this.appenderPanels.add(errorConsolePanel);
        AppenderPanel filePanel = new AppenderPanel("File output", "File");
        filePanel.addFileSelector("File to log to", "File");
        filePanel.addPatternField();
        filePanel.addCheckBox("Append to file?", "Append");
        gridBag.setConstraints(filePanel, constraints);
        panel.add(filePanel);
        this.appenderPanels.add(filePanel);
        AppenderPanel socketPanel = new AppenderPanel("Socket output", "Socket");
        socketPanel.addPortField();
        gridBag.setConstraints(socketPanel, constraints);
        panel.add(socketPanel);
        this.appenderPanels.add(socketPanel);
        return containerPanel;
    }

    boolean checkValidConfig() {
        LoggingPreferences options = LoggingPreferences.get();
        Iterator appPanelIter = this.appenderPanels.iterator();
        if (!options.configLoaded()) {
            this.addButton.setEnabled(false);
            this.treeScroller.setEnabled(false);
            while (appPanelIter.hasNext()) {
                AppenderPanel panel = (AppenderPanel)appPanelIter.next();
                panel.setContentsEnabled(false);
            }
            JOptionPane.showMessageDialog(this, "Fujaba has not been able to successfully load a configuration file for log4j. Please load a valid configuration file.", "No configuration loaded for log4j", 2);
            return false;
        }
        this.addButton.setEnabled(true);
        this.treeScroller.setEnabled(true);
        while (appPanelIter.hasNext()) {
            AppenderPanel panel = (AppenderPanel)appPanelIter.next();
            panel.setContentsEnabled(true);
        }
        return true;
    }

    private class LoadFileListener
    implements ActionListener {
        LoadFileListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent e) {
            LoggingPreferencesPanel thisPanel = LoggingPreferencesPanel.this;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new SchemaFilter(".xml", "XML files (*.xml)"));
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(thisPanel) != 0) return;
            File file = fileChooser.getSelectedFile();
            if (!file.exists()) return;
            if (!file.isFile()) return;
            try {
                try {
                    thisPanel.setCursor(new Cursor(3));
                    LoggingPreferences.get().loadFile(file);
                    LoggingPreferencesPanel.this.setPreferences();
                }
                catch (LoggingConfigException except) {
                    JOptionPane.showMessageDialog(thisPanel, except.getMessage(), "Error loading " + file.getName(), 0);
                    LoggingPreferencesPanel.this.checkValidConfig();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                thisPanel.setCursor(new Cursor(0));
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            thisPanel.setCursor(new Cursor(0));
        }
    }
}

