/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.uni_paderborn.fujaba.preferences.gui.ServerListParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class PlugInsPreferencesPanel
extends PreferencesPanel {
    JList foldersList;
    StringListModel foldersListModel;
    JList downloadURLsList;
    StringListModel downloadURLsListModel;

    public PlugInsPreferencesPanel() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridBagLayout);
        JPanel folderPanel = this.createPluginsFolderPanel();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        mainPanel.add((Component)folderPanel, constraints);
        JPanel editorPanel = this.createDownloadURLsPanel();
        mainPanel.add((Component)editorPanel, constraints);
        this.add((Component)mainPanel, "North");
    }

    private JPanel createPluginsFolderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Plug-in Folders"));
        panel.setLayout(gridBagLayout);
        this.foldersList = new JList();
        this.foldersList.setToolTipText("Fujaba will search for plug-ins in these folders.");
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 4, 3, 4);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.foldersList);
        panel.add((Component)scrollPane, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton addButton = new JButton("Add");
        addButton.setToolTipText("Add a new plug-in folder.");
        addButton.addActionListener(new AddFolderButtonListener());
        buttonPanel.add(addButton);
        JButton editButton = new JButton("Edit");
        editButton.setToolTipText("Edit the selected plug-in folder.");
        editButton.addActionListener(new EditFolderButtonListener());
        buttonPanel.add(editButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setToolTipText("Remove the selected plug-in folders.");
        removeButton.addActionListener(new RemoveButtonListener(this.foldersList));
        buttonPanel.add(removeButton);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weighty = 0.0;
        panel.add((Component)buttonPanel, constraints);
        return panel;
    }

    private JPanel createDownloadURLsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Plug-in Download URLs"));
        panel.setLayout(gridBagLayout);
        this.downloadURLsList = new JList();
        this.downloadURLsList.setToolTipText("URLs for downloading plug-ins for Fujaba.");
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 4, 3, 4);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.downloadURLsList);
        panel.add((Component)scrollPane, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton addButton = new JButton("Add");
        addButton.setToolTipText("Add a new server URL for downloading plug-ins.");
        addButton.addActionListener(new AddURLButtonListener());
        buttonPanel.add(addButton);
        JButton retrieveButton = new JButton("Retrieve List");
        retrieveButton.setToolTipText("Retrieve a list of available plug-in server URLs from Fujaba's homepage.");
        retrieveButton.addActionListener(new RetrieveURLsButtonListener());
        buttonPanel.add(retrieveButton);
        JButton editButton = new JButton("Edit");
        editButton.setToolTipText("Edit the selected server URL.");
        editButton.addActionListener(new EditURLButtonListener());
        buttonPanel.add(editButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setToolTipText("Remove the selected server URLs.");
        removeButton.addActionListener(new RemoveButtonListener(this.downloadURLsList));
        buttonPanel.add(removeButton);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weighty = 0.0;
        panel.add((Component)buttonPanel, constraints);
        return panel;
    }

    public String getPreferredTabName() {
        return "Plug-Ins";
    }

    public void setPreferences() {
        PlugInsPreferences preferences = PlugInsPreferences.get();
        Vector folders = preferences.getPluginFolders();
        this.foldersListModel = new StringListModel(folders);
        this.foldersList.setModel(this.foldersListModel);
        Vector downloadURLs = preferences.getPluginDownloadURLs();
        this.downloadURLsListModel = new StringListModel(downloadURLs);
        this.downloadURLsList.setModel(this.downloadURLsListModel);
    }

    public void setDefaults() {
        PlugInsPreferences.get().setDefaults();
        this.setPreferences();
    }

    public void okPressed() {
        PlugInsPreferences preferences = PlugInsPreferences.get();
        preferences.setPluginFolders(this.foldersListModel.getStrings());
        preferences.setPluginDownloadURLs(this.downloadURLsListModel.getStrings());
    }

    private class StringListModel
    extends AbstractListModel {
        private Vector strings;

        public StringListModel(Vector str) {
            this.strings = str;
        }

        public Vector getStrings() {
            return this.strings;
        }

        public void add(String newString) {
            if (!this.strings.contains(newString)) {
                this.strings.add(newString);
                this.fireIntervalAdded(this, this.strings.indexOf(newString), this.strings.indexOf(newString));
            }
        }

        public void remove(String oldString) {
            if (this.strings.contains(oldString)) {
                this.strings.remove(oldString);
                this.fireIntervalRemoved(this, 0, this.strings.size());
            }
        }

        public int getSize() {
            return this.strings.size();
        }

        public Object getElementAt(int index) {
            return this.strings.elementAt(index);
        }
    }

    private class AddFolderButtonListener
    implements ActionListener {
        AddFolderButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            JFileChooser chooser = new JFileChooser(".");
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showDialog(PlugInsPreferencesPanel.this, "Choose Directory");
            if (returnVal == 0) {
                try {
                    PlugInsPreferencesPanel.this.foldersListModel.add(chooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class EditFolderButtonListener
    implements ActionListener {
        EditFolderButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String oldFolder = (String)PlugInsPreferencesPanel.this.foldersList.getSelectedValue();
            if (oldFolder != null) {
                JFileChooser chooser = new JFileChooser(oldFolder);
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showDialog(PlugInsPreferencesPanel.this, "Choose Directory");
                if (returnVal == 0) {
                    try {
                        PlugInsPreferencesPanel.this.foldersListModel.remove(oldFolder);
                        PlugInsPreferencesPanel.this.foldersListModel.add(chooser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private JList list;

        public RemoveButtonListener(JList list) {
            this.list = list;
        }

        public void actionPerformed(ActionEvent event) {
            Object[] selectedValues = this.list.getSelectedValues();
            int i = 0;
            while (i < selectedValues.length) {
                String str = (String)selectedValues[i];
                StringListModel listModel = (StringListModel)this.list.getModel();
                listModel.remove(str);
                ++i;
            }
        }
    }

    private class AddURLButtonListener
    implements ActionListener {
        AddURLButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String newURL = JOptionPane.showInputDialog(PlugInsPreferencesPanel.this, (Object)"Add a new download URL:");
            if (newURL != null && newURL.trim().length() != 0) {
                PlugInsPreferencesPanel.this.downloadURLsListModel.add(newURL);
            }
        }
    }

    private class EditURLButtonListener
    implements ActionListener {
        EditURLButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String newURL;
            String oldURL = (String)PlugInsPreferencesPanel.this.downloadURLsList.getSelectedValue();
            if (oldURL != null && (newURL = JOptionPane.showInputDialog(PlugInsPreferencesPanel.this, "Edit the download URL:", oldURL)) != null && newURL.trim().length() != 0) {
                PlugInsPreferencesPanel.this.downloadURLsListModel.remove(oldURL);
                PlugInsPreferencesPanel.this.downloadURLsListModel.add(newURL);
            }
        }
    }

    private class RetrieveURLsButtonListener
    implements ActionListener {
        RetrieveURLsButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            String downloadURL = null;
            try {
                ServerListParser serverListParser = new ServerListParser();
                Iterator urlIter = serverListParser.getURLs(new URL("http://www.uni-paderborn.de/cs/fujaba/downloads/plugins/PluginServer.xml"));
                if (urlIter != null) {
                    while (urlIter.hasNext()) {
                        downloadURL = (String)urlIter.next();
                        PlugInsPreferencesPanel.this.downloadURLsListModel.add(downloadURL);
                    }
                } else {
                    JOptionPane.showMessageDialog(FrameMain.get(), "An error occurred while retrieving the server list. Are you connected to the Internet? Consult the console for a more detailed message.", "Error", 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

