/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.upb.tools.fca.FLinkedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class PreferencesDialog
extends JDialog {
    protected JTabbedPane tabbedPane;
    private FLinkedList preferencesPanels = new FLinkedList();

    protected PreferencesDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.addWindowListener(new DialogClose());
        this.initPreferencesPanels();
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)this.createButtonPanel(), "South");
        this.getContentPane().add(container);
    }

    public void show() {
        this.initTabbedPane();
        this.pack();
        this.centerDialog();
        this.setPreferences();
        super.show();
    }

    protected abstract void initPreferencesPanels();

    protected void initTabbedPane() {
        Iterator iter = this.iteratorOfPreferencesPanels();
        while (iter.hasNext()) {
            PreferencesPanel tmpOptionsPanel = (PreferencesPanel)iter.next();
            if (this.tabbedPane.indexOfComponent(tmpOptionsPanel) != -1) continue;
            this.tabbedPane.addTab(tmpOptionsPanel.getPreferredTabName(), tmpOptionsPanel);
        }
    }

    protected JPanel createButtonPanel() {
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new FlowLayout(0));
        JButton setDefaults = new JButton("Set Defaults");
        setDefaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.defaultPressed(false);
            }
        });
        setDefaults.setToolTipText("Set defaults for this tab.");
        leftButtonPanel.add(setDefaults);
        JButton setAllDefaults = new JButton("Set Defaults For All");
        setAllDefaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.defaultPressed(true);
            }
        });
        setAllDefaults.setToolTipText("Set defaults for all tabs.");
        leftButtonPanel.add(setAllDefaults);
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.savePressed();
                PreferencesDialog.this.okPressed();
            }
        });
        rightButtonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.cancelPressed();
            }
        });
        rightButtonPanel.add(cancel);
        this.getRootPane().setDefaultButton(ok);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 2));
        buttonPanel.add(leftButtonPanel);
        buttonPanel.add(rightButtonPanel);
        return buttonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        this.setLocation(x, y);
    }

    public void defaultPressed(boolean all) {
        if (all) {
            Iterator iter = this.iteratorOfPreferencesPanels();
            while (iter.hasNext()) {
                ((PreferencesPanel)iter.next()).setAllDefaults();
            }
        } else {
            PreferencesPanel panel = (PreferencesPanel)this.tabbedPane.getSelectedComponent();
            if (panel != null) {
                panel.setDefaults();
            }
        }
    }

    public void setPreferences() {
        Iterator iter = this.iteratorOfPreferencesPanels();
        while (iter.hasNext()) {
            ((PreferencesPanel)iter.next()).setPreferences();
        }
    }

    public void okPressed() {
        Iterator iter = this.iteratorOfPreferencesPanels();
        while (iter.hasNext()) {
            ((PreferencesPanel)iter.next()).okPressed();
        }
        this.setVisible(false);
    }

    public void savePressed() {
        Iterator iter = this.iteratorOfPreferencesPanels();
        while (iter.hasNext()) {
            PreferencesPanel optionsPanel = (PreferencesPanel)iter.next();
            optionsPanel.okPressed();
        }
        PreferencesProperties.saveAll();
        LoggingPreferences.get().saveSettings();
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    public void setSelectedTab(PreferencesPanel panel) {
        if (this.hasInPreferencesPanels(panel)) {
            this.tabbedPane.setSelectedComponent(panel);
        }
    }

    public boolean hasInPreferencesPanels(PreferencesPanel elem) {
        return this.preferencesPanels.contains(elem);
    }

    public Iterator iteratorOfPreferencesPanels() {
        return this.preferencesPanels.iterator();
    }

    public void addToPreferencesPanels(PreferencesPanel elem) {
        if (elem != null && !this.hasInPreferencesPanels(elem)) {
            this.preferencesPanels.add(elem);
            elem.setPreferencesDialog(this);
        }
    }

    public void removeFromPreferencesPanels(PreferencesPanel elem) {
        if (this.hasInPreferencesPanels(elem)) {
            this.preferencesPanels.remove(elem);
            elem.setPreferencesDialog(null);
        }
    }

    public int sizeOfPreferencesPanels() {
        return this.preferencesPanels.size();
    }

    public void removeAllFromPreferencesPanels() {
        Iterator iter = this.iteratorOfPreferencesPanels();
        while (iter.hasNext()) {
            PreferencesPanel item = (PreferencesPanel)iter.next();
            item.setPreferencesDialog(null);
        }
    }

    private class DialogClose
    extends WindowAdapter {
        DialogClose() {
        }

        public void windowClosing(WindowEvent e) {
            PreferencesDialog.this.cancelPressed();
        }
    }
}

